/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.load;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.vungle.ads.AdExpiredError;
import com.vungle.ads.AdPayloadError;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.AssetRequestError;
import com.vungle.ads.AssetWriteError;
import com.vungle.ads.InvalidAssetUrlError;
import com.vungle.ads.InvalidEventIdError;
import com.vungle.ads.InvalidTemplateURLError;
import com.vungle.ads.NativeAssetError;
import com.vungle.ads.OmSdkJsError;
import com.vungle.ads.PlacementMismatchError;
import com.vungle.ads.PrivacyIconFallbackError;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.TimeIntervalMetric;
import com.vungle.ads.VungleError;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.downloader.AssetDownloadListener;
import com.vungle.ads.internal.downloader.DefaultPrivacyIconInjector;
import com.vungle.ads.internal.downloader.DownloadRequest;
import com.vungle.ads.internal.downloader.Downloader;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.load.AdLoaderCallback;
import com.vungle.ads.internal.load.AdRequest;
import com.vungle.ads.internal.load.BaseAdLoader;
import com.vungle.ads.internal.model.AdAsset;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.network.TpatRequest;
import com.vungle.ads.internal.network.TpatSender;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.omsdk.OMInjector;
import com.vungle.ads.internal.platform.DeviceCheckUtils;
import com.vungle.ads.internal.presenter.PreloadDelegate;
import com.vungle.ads.internal.presenter.WebViewManager;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.task.JobRunner;
import com.vungle.ads.internal.task.ResendTpatJob;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.LogEntry;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import com.vungle.ads.internal.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b&\u0018\u0000 f2\u00020\u0001:\u0001fB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010H\u001a\u00020IJ\b\u0010J\u001a\u00020IH\u0002J\u0018\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0013H\u0002J\u0010\u0010P\u001a\u00020Q2\u0006\u0010O\u001a\u00020\u0013H\u0002J\u0012\u0010R\u001a\u0004\u0018\u00010N2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u001dH\u0002J\u0012\u0010V\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020\u001dH\u0002J!\u0010W\u001a\u00020I2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010X\u001a\u0004\u0018\u00010=H\u0000\u00a2\u0006\u0002\bYJ\u000e\u0010Z\u001a\u00020I2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010[\u001a\u00020I2\u0006\u0010\\\u001a\u00020TJ\b\u0010]\u001a\u00020IH&J\b\u0010^\u001a\u00020IH\u0002J\u0010\u0010_\u001a\u00020I2\u0006\u0010`\u001a\u00020\u000fH\u0003J\b\u0010a\u001a\u00020IH\u0002J\u001a\u0010b\u001a\u00020L2\u0006\u0010c\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010d\u001a\u00020IH$J\u0012\u0010e\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020\u001dH\u0002R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u000201X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u000107X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u000e\u0010B\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u000e\u0010E\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010G\u00a8\u0006g\u00b2\u0006\n\u0010h\u001a\u00020iX\u008a\u0084\u0002\u00b2\u0006\n\u0010j\u001a\u00020kX\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/load/BaseAdLoader;", "", "context", "Landroid/content/Context;", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "sdkExecutors", "Lcom/vungle/ads/internal/executor/Executors;", "omInjector", "Lcom/vungle/ads/internal/omsdk/OMInjector;", "downloader", "Lcom/vungle/ads/internal/downloader/Downloader;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "adRequest", "Lcom/vungle/ads/internal/load/AdRequest;", "(Landroid/content/Context;Lcom/vungle/ads/internal/network/VungleApiClient;Lcom/vungle/ads/internal/executor/Executors;Lcom/vungle/ads/internal/omsdk/OMInjector;Lcom/vungle/ads/internal/downloader/Downloader;Lcom/vungle/ads/internal/util/PathProvider;Lcom/vungle/ads/internal/load/AdRequest;)V", "adAssets", "", "Lcom/vungle/ads/internal/model/AdAsset;", "adLoaderCallback", "Lcom/vungle/ads/internal/load/AdLoaderCallback;", "adOptionalDownloadDurationMetric", "Lcom/vungle/ads/TimeIntervalMetric;", "adPreloadToReadyDurationMetric", "getAdRequest", "()Lcom/vungle/ads/internal/load/AdRequest;", "adRequiredDownloadDurationMetric", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "getAdvertisement$vungle_ads_release", "()Lcom/vungle/ads/internal/model/AdPayload;", "setAdvertisement$vungle_ads_release", "(Lcom/vungle/ads/internal/model/AdPayload;)V", "assetDownloadDurationMetric", "assetDownloadListener", "Lcom/vungle/ads/internal/downloader/AssetDownloadListener;", "getAssetDownloadListener", "()Lcom/vungle/ads/internal/downloader/AssetDownloadListener;", "getContext", "()Landroid/content/Context;", "downloadCount", "Ljava/util/concurrent/atomic/AtomicLong;", "downloadRequiredAssets", "", "", "fullyDownloaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "loadStart", "", "getLoadStart$vungle_ads_release", "()J", "setLoadStart$vungle_ads_release", "(J)V", "logEntry", "Lcom/vungle/ads/internal/util/LogEntry;", "getLogEntry$vungle_ads_release", "()Lcom/vungle/ads/internal/util/LogEntry;", "setLogEntry$vungle_ads_release", "(Lcom/vungle/ads/internal/util/LogEntry;)V", "mainVideoSizeMetric", "Lcom/vungle/ads/SingleValueMetric;", "notifyFailed", "notifySuccess", "getPathProvider", "()Lcom/vungle/ads/internal/util/PathProvider;", "requiredAssetDownloaded", "getSdkExecutors", "()Lcom/vungle/ads/internal/executor/Executors;", "templateHtmlSizeMetric", "getVungleApiClient", "()Lcom/vungle/ads/internal/network/VungleApiClient;", "cancel", "", "downloadAssets", "fileIsValid", "", "file", "Ljava/io/File;", "adAsset", "getAssetPriority", "Lcom/vungle/ads/internal/downloader/DownloadRequest$Priority;", "getDestinationDir", "getErrorInfo", "Lcom/vungle/ads/VungleError;", "adPayload", "getTemplateError", "handleAdMetaData", "metric", "handleAdMetaData$vungle_ads_release", "loadAd", "onAdLoadFailed", "error", "onAdLoadReady", "onAdReady", "onDownloadCompleted", "request", "onRequiredDownloadCompleted", "processVmTemplate", "asset", "requestAd", "validateAdMetadata", "Companion", "vungle-ads_release", "jobRunner", "Lcom/vungle/ads/internal/task/JobRunner;", "tpatSender", "Lcom/vungle/ads/internal/network/TpatSender;"})
public abstract class BaseAdLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final VungleApiClient vungleApiClient;
    @NotNull
    private final Executors sdkExecutors;
    @NotNull
    private final OMInjector omInjector;
    @NotNull
    private final Downloader downloader;
    @NotNull
    private final PathProvider pathProvider;
    @NotNull
    private final AdRequest adRequest;
    @NotNull
    private final AtomicLong downloadCount;
    @NotNull
    private final Set<String> downloadRequiredAssets;
    @Nullable
    private AdLoaderCallback adLoaderCallback;
    @NotNull
    private AtomicBoolean notifySuccess;
    @NotNull
    private AtomicBoolean notifyFailed;
    @NotNull
    private final List<AdAsset> adAssets;
    @Nullable
    private AdPayload advertisement;
    @NotNull
    private AtomicBoolean fullyDownloaded;
    @NotNull
    private AtomicBoolean requiredAssetDownloaded;
    @NotNull
    private SingleValueMetric mainVideoSizeMetric;
    @NotNull
    private SingleValueMetric templateHtmlSizeMetric;
    @NotNull
    private TimeIntervalMetric assetDownloadDurationMetric;
    @NotNull
    private TimeIntervalMetric adRequiredDownloadDurationMetric;
    @NotNull
    private TimeIntervalMetric adOptionalDownloadDurationMetric;
    @NotNull
    private TimeIntervalMetric adPreloadToReadyDurationMetric;
    @Nullable
    private LogEntry logEntry;
    private long loadStart;
    @NotNull
    private static final String TAG = "BaseAdLoader";
    @NotNull
    private static final String DOWNLOADED_FILE_NOT_FOUND = "Downloaded file not found!";

    public BaseAdLoader(@NotNull Context context, @NotNull VungleApiClient vungleApiClient, @NotNull Executors sdkExecutors, @NotNull OMInjector omInjector, @NotNull Downloader downloader, @NotNull PathProvider pathProvider, @NotNull AdRequest adRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vungleApiClient, (String)"vungleApiClient");
        Intrinsics.checkNotNullParameter((Object)sdkExecutors, (String)"sdkExecutors");
        Intrinsics.checkNotNullParameter((Object)omInjector, (String)"omInjector");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        this.context = context;
        this.vungleApiClient = vungleApiClient;
        this.sdkExecutors = sdkExecutors;
        this.omInjector = omInjector;
        this.downloader = downloader;
        this.pathProvider = pathProvider;
        this.adRequest = adRequest;
        this.downloadCount = new AtomicLong(0L);
        this.downloadRequiredAssets = new LinkedHashSet();
        this.notifySuccess = new AtomicBoolean(false);
        this.notifyFailed = new AtomicBoolean(false);
        this.adAssets = new ArrayList();
        this.fullyDownloaded = new AtomicBoolean(true);
        this.requiredAssetDownloaded = new AtomicBoolean(true);
        this.mainVideoSizeMetric = new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.ASSET_FILE_SIZE);
        this.templateHtmlSizeMetric = new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.TEMPLATE_HTML_SIZE);
        this.assetDownloadDurationMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.ASSET_DOWNLOAD_DURATION_MS);
        this.adRequiredDownloadDurationMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.AD_REQUIRED_DOWNLOAD_DURATION_MS);
        this.adOptionalDownloadDurationMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.AD_OPTIONAL_DOWNLOAD_DURATION_MS);
        this.adPreloadToReadyDurationMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.AD_PRELOAD_TO_READY_DURATION_MS);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final VungleApiClient getVungleApiClient() {
        return this.vungleApiClient;
    }

    @NotNull
    public final Executors getSdkExecutors() {
        return this.sdkExecutors;
    }

    @NotNull
    public final PathProvider getPathProvider() {
        return this.pathProvider;
    }

    @NotNull
    public final AdRequest getAdRequest() {
        return this.adRequest;
    }

    @Nullable
    public final AdPayload getAdvertisement$vungle_ads_release() {
        return this.advertisement;
    }

    public final void setAdvertisement$vungle_ads_release(@Nullable AdPayload adPayload) {
        this.advertisement = adPayload;
    }

    @Nullable
    public final LogEntry getLogEntry$vungle_ads_release() {
        return this.logEntry;
    }

    public final void setLogEntry$vungle_ads_release(@Nullable LogEntry logEntry2) {
        this.logEntry = logEntry2;
    }

    public final long getLoadStart$vungle_ads_release() {
        return this.loadStart;
    }

    public final void setLoadStart$vungle_ads_release(long l) {
        this.loadStart = l;
    }

    private final AssetDownloadListener getAssetDownloadListener() {
        return new AssetDownloadListener(this){
            private boolean partialDownloadRecorded;
            final /* synthetic */ BaseAdLoader this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStart(@NotNull DownloadRequest downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                Logger.Companion.w("BaseAdLoader", "onStart called: " + downloadRequest.getAsset().getServerPath());
                AdAsset adAsset = downloadRequest.getAsset();
                if (adAsset.isRequired()) {
                    Integer n = adAsset.getPercentage();
                    if ((n != null ? n : 0) > 0) {
                        downloadRequest.startPartialDownloadRecord();
                    }
                }
            }

            public void onProgress(@NotNull AssetDownloadListener.Progress progress, @NotNull DownloadRequest downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                AdAsset adAsset = downloadRequest.getAsset();
                Logger.Companion.d("BaseAdLoader", "Download progress: " + progress + " url: " + adAsset.getServerPath());
                if (adAsset.isRequired() && adAsset.getPercentage() != null && adAsset.getPercentage() > 0 && progress.getProgressPercent() >= adAsset.getPercentage() && !this.partialDownloadRecorded) {
                    this.partialDownloadRecorded = true;
                    downloadRequest.stopPartialDownloadRecord();
                    Logger.Companion.w("BaseAdLoader", "Download progress: hit chunk percentage=" + adAsset.getPercentage() + " for url: " + adAsset.getServerPath());
                    this.this$0.getSdkExecutors().getBackgroundExecutor().execute(() -> assetDownloadListener.1.onProgress$lambda-0(this.this$0, adAsset));
                }
            }

            public void onError(@Nullable AssetDownloadListener.DownloadError error, @NotNull DownloadRequest downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                Logger.Companion.e("BaseAdLoader", "onError called: " + error);
                this.this$0.getSdkExecutors().getBackgroundExecutor().execute(() -> assetDownloadListener.1.onError$lambda-1(downloadRequest, this.this$0, this, error));
            }

            public void onSuccess(@NotNull File file, @NotNull DownloadRequest downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                this.this$0.getSdkExecutors().getBackgroundExecutor().execute(() -> assetDownloadListener.1.onSuccess$lambda-2(file, this, downloadRequest, this.this$0));
            }

            private static final void onProgress$lambda-0(BaseAdLoader this$0, AdAsset $adAsset) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$adAsset, (String)"$adAsset");
                BaseAdLoader.access$getDownloadRequiredAssets$p(this$0).remove($adAsset.getServerPath());
                if (BaseAdLoader.access$getDownloadRequiredAssets$p(this$0).isEmpty()) {
                    if (BaseAdLoader.access$getRequiredAssetDownloaded$p(this$0).get()) {
                        BaseAdLoader.access$onRequiredDownloadCompleted(this$0);
                    } else {
                        this$0.onAdLoadFailed(new AssetRequestError("Failed to download required assets."));
                        this$0.cancel();
                        return;
                    }
                }
            }

            private static final void onError$lambda-1(DownloadRequest $downloadRequest, BaseAdLoader this$0, assetDownloadListener.1 this$1, AssetDownloadListener.DownloadError $error) {
                Intrinsics.checkNotNullParameter((Object)$downloadRequest, (String)"$downloadRequest");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                AdAsset adAsset = $downloadRequest.getAsset();
                if (adAsset.isPrivacyIcon()) {
                    File file = DefaultPrivacyIconInjector.INSTANCE.injectPrivacyIcon(this$0.getPathProvider().getVmDir());
                    if (file != null && file.exists()) {
                        this$1.onSuccess(file, $downloadRequest);
                        return;
                    }
                    new PrivacyIconFallbackError("Failed to inject default privacy icon").setLogEntry$vungle_ads_release(this$0.getLogEntry$vungle_ads_release()).logErrorNoReturnValue$vungle_ads_release();
                }
                BaseAdLoader.access$getFullyDownloaded$p(this$0).set(false);
                if (adAsset.isRequired()) {
                    BaseAdLoader.access$getRequiredAssetDownloaded$p(this$0).set(false);
                }
                String errorMsg = "Failed to download assets " + adAsset.getServerPath() + ". error: " + $error + " proxyEnabled=" + DeviceCheckUtils.INSTANCE.isProxyEnabled(this$0.getContext());
                new AssetRequestError(errorMsg).setLogEntry$vungle_ads_release(this$0.getLogEntry$vungle_ads_release()).logErrorNoReturnValue$vungle_ads_release();
                if (adAsset.isRequired()) {
                    BaseAdLoader.access$getDownloadRequiredAssets$p(this$0).remove($downloadRequest.getAsset().getServerPath());
                    if (BaseAdLoader.access$getDownloadRequiredAssets$p(this$0).isEmpty()) {
                        this$0.onAdLoadFailed(new AssetRequestError("Error: Failed to download required assets."));
                        this$0.cancel();
                        return;
                    }
                }
                if (BaseAdLoader.access$getDownloadCount$p(this$0).decrementAndGet() <= 0L) {
                    this$0.onAdLoadFailed(new AssetRequestError("Error: Failed to download assets."));
                }
            }

            private static final void onSuccess$lambda-2(File $file, assetDownloadListener.1 this$0, DownloadRequest $downloadRequest, BaseAdLoader this$1) {
                Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$downloadRequest, (String)"$downloadRequest");
                Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                if (!$file.exists()) {
                    this$0.onError(new AssetDownloadListener.DownloadError(-1, new IOException("Downloaded file not found!"), AssetDownloadListener.DownloadError.ErrorReason.Companion.getFILE_NOT_FOUND_ERROR()), $downloadRequest);
                    return;
                }
                AdAsset adAsset = $downloadRequest.getAsset();
                adAsset.setFileSize($file.length());
                adAsset.setStatus(AdAsset.Status.DOWNLOAD_SUCCESS);
                if (adAsset.isHtmlTemplate()) {
                    $downloadRequest.stopTemplateRecord();
                    BaseAdLoader.access$getTemplateHtmlSizeMetric$p(this$1).setValue($file.length());
                    AnalyticsClient.INSTANCE.logMetric$vungle_ads_release(BaseAdLoader.access$getTemplateHtmlSizeMetric$p(this$1), this$1.getLogEntry$vungle_ads_release(), adAsset.getServerPath());
                } else if (adAsset.isMainVideo()) {
                    BaseAdLoader.access$getMainVideoSizeMetric$p(this$1).setValue($file.length());
                    AnalyticsClient.INSTANCE.logMetric$vungle_ads_release(BaseAdLoader.access$getMainVideoSizeMetric$p(this$1), this$1.getLogEntry$vungle_ads_release(), adAsset.getServerPath());
                }
                AdPayload adPayload = this$1.getAdvertisement$vungle_ads_release();
                if (adPayload != null) {
                    adPayload.updateAdAssetPath(adAsset.getAdIdentifier(), $file);
                }
                if (adAsset.isHtmlTemplate() && !BaseAdLoader.access$processVmTemplate(this$1, adAsset, this$1.getAdvertisement$vungle_ads_release())) {
                    BaseAdLoader.access$getFullyDownloaded$p(this$1).set(false);
                    if (adAsset.isRequired()) {
                        BaseAdLoader.access$getRequiredAssetDownloaded$p(this$1).set(false);
                    }
                }
                if (adAsset.isRequired()) {
                    BaseAdLoader.access$getDownloadRequiredAssets$p(this$1).remove(adAsset.getServerPath());
                    if (BaseAdLoader.access$getDownloadRequiredAssets$p(this$1).isEmpty()) {
                        if (BaseAdLoader.access$getRequiredAssetDownloaded$p(this$1).get()) {
                            BaseAdLoader.access$onRequiredDownloadCompleted(this$1);
                        } else {
                            this$1.onAdLoadFailed(new AssetRequestError("Failed to download required assets."));
                            this$1.cancel();
                            return;
                        }
                    }
                }
                if (BaseAdLoader.access$getDownloadCount$p(this$1).decrementAndGet() <= 0L) {
                    if (BaseAdLoader.access$getFullyDownloaded$p(this$1).get()) {
                        BaseAdLoader.access$onDownloadCompleted(this$1, this$1.getAdRequest());
                    } else {
                        this$1.onAdLoadFailed(new AssetRequestError("Failed to download assets."));
                    }
                }
            }
        };
    }

    public final void loadAd(@NotNull AdLoaderCallback adLoaderCallback) {
        Intrinsics.checkNotNullParameter((Object)adLoaderCallback, (String)"adLoaderCallback");
        this.adLoaderCallback = adLoaderCallback;
        this.loadStart = System.currentTimeMillis();
        this.sdkExecutors.getBackgroundExecutor().execute(() -> BaseAdLoader.loadAd$lambda-0(this));
    }

    protected abstract void requestAd();

    public abstract void onAdLoadReady();

    public final void cancel() {
        this.downloader.cancelAll();
    }

    private final void downloadAssets() {
        this.assetDownloadDurationMetric.markStart();
        this.adRequiredDownloadDurationMetric.markStart();
        this.adOptionalDownloadDurationMetric.markStart();
        this.downloadCount.set(this.adAssets.size());
        for (AdAsset asset : this.adAssets) {
            DownloadRequest downloadRequest = new DownloadRequest(this.getAssetPriority(asset), asset, this.logEntry);
            if (asset.isHtmlTemplate()) {
                downloadRequest.startTemplateRecord();
            }
            if (asset.isRequired()) {
                this.downloadRequiredAssets.add(asset.getServerPath());
            }
            this.downloader.download(downloadRequest, this.getAssetDownloadListener());
        }
    }

    public final void onAdLoadFailed(@NotNull VungleError error) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            if (this.notifySuccess.get() || !this.notifyFailed.compareAndSet(false, true)) break block1;
            AdLoaderCallback adLoaderCallback = this.adLoaderCallback;
            if (adLoaderCallback != null) {
                adLoaderCallback.onFailure(error);
            }
        }
    }

    private final void onAdReady() {
        block4: {
            AdPayload adPayload = this.advertisement;
            if (adPayload == null) break block4;
            AdPayload it = adPayload;
            boolean bl = false;
            if (!this.notifyFailed.get() && this.notifySuccess.compareAndSet(false, true)) {
                if (it.usePreloading()) {
                    this.adPreloadToReadyDurationMetric.markStart();
                    String templatePath = String.valueOf(it.getIndexFilePath());
                    Logger.Companion.w(TAG, "start preloading");
                    long loadDuration = System.currentTimeMillis() - this.loadStart;
                    WebViewManager.INSTANCE.preloadWebView$vungle_ads_release(this.context, it, this.adRequest.getPlacement(), templatePath, it.getWebViewSettings(), new PreloadDelegate(this, it){
                        final /* synthetic */ BaseAdLoader this$0;
                        final /* synthetic */ AdPayload $it;
                        {
                            this.this$0 = $receiver;
                            this.$it = $it;
                        }

                        public void onAdReadyToPlay() {
                            block0: {
                                BaseAdLoader.access$getAdPreloadToReadyDurationMetric$p(this.this$0).markEnd();
                                AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, BaseAdLoader.access$getAdPreloadToReadyDurationMetric$p(this.this$0), this.this$0.getLogEntry$vungle_ads_release(), null, 4, null);
                                this.this$0.onAdLoadReady();
                                AdLoaderCallback adLoaderCallback = BaseAdLoader.access$getAdLoaderCallback$p(this.this$0);
                                if (adLoaderCallback == null) break block0;
                                adLoaderCallback.onSuccess(this.$it);
                            }
                        }

                        public void onAdFailedToPlay() {
                            block0: {
                                BaseAdLoader.access$getAdPreloadToReadyDurationMetric$p(this.this$0).markEnd();
                                AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, BaseAdLoader.access$getAdPreloadToReadyDurationMetric$p(this.this$0), this.this$0.getLogEntry$vungle_ads_release(), null, 4, null);
                                Logger.Companion.e("BaseAdLoader", "fail to load ad");
                                this.this$0.onAdLoadReady();
                                AdLoaderCallback adLoaderCallback = BaseAdLoader.access$getAdLoaderCallback$p(this.this$0);
                                if (adLoaderCallback == null) break block0;
                                adLoaderCallback.onSuccess(this.$it);
                            }
                        }
                    }, loadDuration);
                } else {
                    this.onAdLoadReady();
                    AdLoaderCallback adLoaderCallback = this.adLoaderCallback;
                    if (adLoaderCallback != null) {
                        adLoaderCallback.onSuccess(it);
                    }
                }
                ServiceLocator.Companion companion = ServiceLocator.Companion;
                Context context$iv = this.context;
                boolean $i$f$inject = false;
                Lazy jobRunner$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<JobRunner>(context$iv){
                    final /* synthetic */ Context $context;
                    {
                        this.$context = $context;
                        super(0);
                    }

                    @NotNull
                    public final JobRunner invoke() {
                        return ServiceLocator.Companion.getInstance(this.$context).getService(JobRunner.class);
                    }
                }));
                BaseAdLoader.onAdReady$lambda-2$lambda-1((Lazy<? extends JobRunner>)jobRunner$delegate).execute(ResendTpatJob.Companion.makeJobInfo());
            }
        }
    }

    private final boolean fileIsValid(File file, AdAsset adAsset) {
        return file.exists() && file.length() == adAsset.getFileSize();
    }

    private final File getDestinationDir(AdPayload advertisement) {
        return this.pathProvider.getDownloadsDirForAd(advertisement.eventId());
    }

    private final boolean processVmTemplate(AdAsset asset, AdPayload advertisement) {
        if (advertisement == null) {
            return false;
        }
        if (asset.getStatus() != AdAsset.Status.DOWNLOAD_SUCCESS) {
            return false;
        }
        if (((CharSequence)asset.getLocalPath()).length() == 0) {
            return false;
        }
        File vmTemplate = new File(asset.getLocalPath());
        if (!this.fileIsValid(vmTemplate, asset)) {
            return false;
        }
        File destinationDir = this.getDestinationDir(advertisement);
        if (destinationDir == null || !destinationDir.isDirectory()) {
            Logger.Companion.e(TAG, "Unable to access Destination Directory");
            return false;
        }
        if (advertisement.omEnabled()) {
            try {
                this.omInjector.init();
                this.omInjector.injectJsFiles$vungle_ads_release(this.pathProvider.getVmDir());
            }
            catch (Exception e2) {
                Logger.Companion.e(TAG, "Failed to inject OMSDK: " + e2.getMessage());
                new OmSdkJsError(Sdk.SDKError.Reason.OMSDK_JS_WRITE_FAILED, "Failed to inject OMSDK: " + e2.getMessage()).setLogEntry$vungle_ads_release(this.logEntry).logErrorNoReturnValue$vungle_ads_release();
            }
        }
        FileUtility.printDirectoryTree(destinationDir);
        return true;
    }

    private final void onRequiredDownloadCompleted() {
        this.adRequiredDownloadDurationMetric.markEnd();
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, this.adRequiredDownloadDurationMetric, this.logEntry, null, 4, null);
        this.onAdReady();
    }

    @WorkerThread
    private final void onDownloadCompleted(AdRequest request) {
        Logger.Companion.d(TAG, "All download completed " + request);
        AdPayload adPayload = this.advertisement;
        if (adPayload != null) {
            adPayload.setAssetFullyDownloaded();
        }
        this.onAdReady();
        this.assetDownloadDurationMetric.markEnd();
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, this.assetDownloadDurationMetric, this.logEntry, null, 4, null);
        this.adOptionalDownloadDurationMetric.markEnd();
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, this.adOptionalDownloadDurationMetric, this.logEntry, null, 4, null);
    }

    public final void handleAdMetaData$vungle_ads_release(@NotNull AdPayload advertisement, @Nullable SingleValueMetric metric) {
        Intrinsics.checkNotNullParameter((Object)advertisement, (String)"advertisement");
        this.advertisement = advertisement;
        advertisement.setLogEntry$vungle_ads_release(this.logEntry);
        LogEntry logEntry2 = this.logEntry;
        if (logEntry2 != null) {
            logEntry2.setEventId$vungle_ads_release(advertisement.eventId());
        }
        LogEntry logEntry3 = this.logEntry;
        if (logEntry3 != null) {
            logEntry3.setCreativeId$vungle_ads_release(advertisement.getCreativeId());
        }
        LogEntry logEntry4 = this.logEntry;
        if (logEntry4 != null) {
            logEntry4.setAdSource$vungle_ads_release(advertisement.getAdSource());
        }
        LogEntry logEntry5 = this.logEntry;
        if (logEntry5 != null) {
            logEntry5.setMediationName$vungle_ads_release(advertisement.getMediationName());
        }
        LogEntry logEntry6 = this.logEntry;
        if (logEntry6 != null) {
            logEntry6.setVmVersion$vungle_ads_release(advertisement.getViewMasterVersion());
        }
        LogEntry logEntry7 = this.logEntry;
        if (logEntry7 != null) {
            logEntry7.setPartialDownloadEnabled$vungle_ads_release(advertisement.isPartialDownloadEnabled());
        }
        LogEntry logEntry8 = this.logEntry;
        if (logEntry8 != null) {
            logEntry8.setAdoEnabled$vungle_ads_release(advertisement.adLoadOptimizationEnabled());
        }
        ConfigPayload configPayload = advertisement.config();
        if (configPayload != null) {
            ConfigPayload config = configPayload;
            boolean bl = false;
            ConfigManager.INSTANCE.initWithConfig$vungle_ads_release(this.context, config, false, metric);
        }
        VungleError error = this.validateAdMetadata(advertisement);
        if (error != null) {
            this.onAdLoadFailed(error.setLogEntry$vungle_ads_release(this.logEntry).logError$vungle_ads_release());
            return;
        }
        File destinationDir = this.getDestinationDir(advertisement);
        if (destinationDir == null || !destinationDir.isDirectory() || !destinationDir.exists()) {
            this.onAdLoadFailed(new AssetWriteError("Invalid directory. " + destinationDir).setLogEntry$vungle_ads_release(this.logEntry).logError$vungle_ads_release());
            return;
        }
        ServiceLocator.Companion bl = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        Lazy tpatSender$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<TpatSender>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final TpatSender invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(TpatSender.class);
            }
        }));
        Object object = advertisement.adUnit();
        if (object != null && (object = ((AdPayload.AdUnit)object).getLoadAdUrls()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String url = (String)element$iv;
                boolean bl2 = false;
                TpatRequest request = new TpatRequest.Builder(url).tpatKey("load_ad").withLogEntry(this.logEntry).build();
                TpatSender.sendTpat$default(BaseAdLoader.handleAdMetaData$lambda-4((Lazy<TpatSender>)tpatSender$delegate), request, false, 2, null);
            }
        }
        if (!((Collection)this.adAssets).isEmpty()) {
            this.adAssets.clear();
        }
        this.adAssets.addAll((Collection<AdAsset>)advertisement.getDownloadableAssets(destinationDir));
        if (this.adAssets.isEmpty()) {
            this.onAdReady();
            return;
        }
        this.downloadAssets();
    }

    public static /* synthetic */ void handleAdMetaData$vungle_ads_release$default(BaseAdLoader baseAdLoader, AdPayload adPayload, SingleValueMetric singleValueMetric, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleAdMetaData");
        }
        if ((n & 2) != 0) {
            singleValueMetric = null;
        }
        baseAdLoader.handleAdMetaData$vungle_ads_release(adPayload, singleValueMetric);
    }

    private final DownloadRequest.Priority getAssetPriority(AdAsset adAsset) {
        return adAsset.isRequired() ? DownloadRequest.Priority.CRITICAL : DownloadRequest.Priority.HIGHEST;
    }

    private final VungleError validateAdMetadata(AdPayload adPayload) {
        Object object;
        AdPayload.AdUnit adUnit = adPayload.adUnit();
        if (adUnit != null && (object = adUnit.getSleep()) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            return this.getErrorInfo(adPayload);
        }
        AdPayload adPayload2 = this.advertisement;
        if (!Intrinsics.areEqual((Object)this.adRequest.getPlacement().getReferenceId(), (Object)(adPayload2 != null ? adPayload2.placementId() : null))) {
            AdPayload adPayload3 = this.advertisement;
            String description = "Waterfall request and responses placement don't match " + (adPayload3 != null ? adPayload3.placementId() : null) + '.';
            return new PlacementMismatchError(description);
        }
        VungleError templateSettingsError = this.getTemplateError(adPayload);
        if (templateSettingsError != null) {
            return templateSettingsError;
        }
        if (adPayload.hasExpired()) {
            return new AdExpiredError("The ad markup has expired for playback.");
        }
        object = adPayload.eventId();
        if (object == null || object.length() == 0) {
            return new InvalidEventIdError("Event id is invalid.");
        }
        return null;
    }

    private final VungleError getTemplateError(AdPayload adPayload) {
        block10: {
            Object it;
            AdPayload.TemplateSettings templateSettings;
            AdPayload.AdUnit adUnit = adPayload.adUnit();
            AdPayload.TemplateSettings templateSettings2 = templateSettings = adUnit != null ? adUnit.getTemplateSettings() : null;
            if (templateSettings == null) {
                String description = "Missing template settings";
                return new AssetRequestError(description);
            }
            Map<String, AdPayload.CacheableReplacement> cacheableReplacements = templateSettings.getCacheableReplacements();
            if (adPayload.isNativeTemplateType()) {
                Map<String, AdPayload.CacheableReplacement> map = cacheableReplacements;
                if (map != null) {
                    it = map;
                    boolean bl = false;
                    AdPayload.CacheableReplacement cacheableReplacement = it.get("MAIN_IMAGE");
                    if ((cacheableReplacement != null ? cacheableReplacement.getUrl() : null) == null) {
                        return new NativeAssetError("Unable to load null main image.");
                    }
                    AdPayload.CacheableReplacement cacheableReplacement2 = (AdPayload.CacheableReplacement)it.get("VUNGLE_PRIVACY_ICON_URL");
                    if ((cacheableReplacement2 != null ? cacheableReplacement2.getUrl() : null) == null) {
                        return new NativeAssetError("Unable to load null privacy image.");
                    }
                }
            } else {
                String description;
                AdPayload.AdUnit adUnit2 = adPayload.adUnit();
                String vmUrl = adUnit2 != null ? adUnit2.getVmURL() : null;
                it = vmUrl;
                if (it == null || it.length() == 0) {
                    description = "Failed to prepare null vmURL for downloading.";
                    return new InvalidTemplateURLError(description);
                }
                if (!Utils.INSTANCE.isUrlValid(vmUrl)) {
                    description = "Failed to load vm url: " + vmUrl;
                    return new AssetRequestError(description);
                }
            }
            Map<String, AdPayload.CacheableReplacement> map = cacheableReplacements;
            if (map == null) break block10;
            Map<String, AdPayload.CacheableReplacement> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, AdPayload.CacheableReplacement>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, AdPayload.CacheableReplacement> element$iv;
                Map.Entry<String, AdPayload.CacheableReplacement> it2 = element$iv = iterator.next();
                boolean bl = false;
                String httpUrl = it2.getValue().getUrl();
                CharSequence charSequence = httpUrl;
                if (charSequence == null || charSequence.length() == 0) {
                    return new InvalidAssetUrlError("Invalid asset URL " + httpUrl);
                }
                if (Utils.INSTANCE.isUrlValid(httpUrl)) continue;
                return new AssetRequestError("Invalid asset URL " + httpUrl);
            }
        }
        return null;
    }

    private final VungleError getErrorInfo(AdPayload adPayload) {
        VungleError vungleError;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        Integer n;
        AdPayload.AdUnit adUnit = adPayload.adUnit();
        Integer errorCode = adUnit != null ? adUnit.getErrorCode() : null;
        AdPayload.AdUnit adUnit2 = adPayload.adUnit();
        Integer sleep = adUnit2 != null ? adUnit2.getSleep() : null;
        AdPayload.AdUnit adUnit3 = adPayload.adUnit();
        String info = adUnit3 != null ? adUnit3.getInfo() : null;
        String errorMsg = "Response error: " + sleep + ", Request failed with error: " + errorCode + ", " + info;
        Integer n2 = n = errorCode;
        int n3 = 10001;
        if (n2 != null && n2 == n3) {
            bl4 = true;
        } else {
            Integer n4 = n;
            n3 = 10002;
            bl4 = n4 != null && n4 == n3;
        }
        if (bl4) {
            bl3 = true;
        } else {
            Integer n5 = n;
            n3 = 20001;
            bl3 = n5 != null && n5 == n3;
        }
        if (bl3) {
            bl2 = true;
        } else {
            Integer n6 = n;
            n3 = 30001;
            bl2 = n6 != null && n6 == n3;
        }
        if (bl2) {
            bl = true;
        } else {
            Integer n7 = n;
            n3 = 30002;
            bl = n7 != null && n7 == n3;
        }
        if (bl) {
            Sdk.SDKError.Reason reason = Sdk.SDKError.Reason.forNumber(errorCode);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)reason), (String)"forNumber(errorCode)");
            vungleError = new AdPayloadError(reason, errorMsg);
        } else {
            vungleError = new AdPayloadError(Sdk.SDKError.Reason.PLACEMENT_SLEEP, errorMsg);
        }
        return vungleError;
    }

    private static final void loadAd$lambda-0(BaseAdLoader this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.requestAd();
    }

    private static final JobRunner onAdReady$lambda-2$lambda-1(Lazy<? extends JobRunner> $jobRunner$delegate) {
        Lazy<? extends JobRunner> lazy = $jobRunner$delegate;
        return (JobRunner)lazy.getValue();
    }

    private static final TpatSender handleAdMetaData$lambda-4(Lazy<TpatSender> $tpatSender$delegate) {
        Lazy<TpatSender> lazy = $tpatSender$delegate;
        return (TpatSender)lazy.getValue();
    }

    public static final /* synthetic */ Set access$getDownloadRequiredAssets$p(BaseAdLoader $this) {
        return $this.downloadRequiredAssets;
    }

    public static final /* synthetic */ AtomicBoolean access$getRequiredAssetDownloaded$p(BaseAdLoader $this) {
        return $this.requiredAssetDownloaded;
    }

    public static final /* synthetic */ void access$onRequiredDownloadCompleted(BaseAdLoader $this) {
        $this.onRequiredDownloadCompleted();
    }

    public static final /* synthetic */ AtomicBoolean access$getFullyDownloaded$p(BaseAdLoader $this) {
        return $this.fullyDownloaded;
    }

    public static final /* synthetic */ AtomicLong access$getDownloadCount$p(BaseAdLoader $this) {
        return $this.downloadCount;
    }

    public static final /* synthetic */ SingleValueMetric access$getTemplateHtmlSizeMetric$p(BaseAdLoader $this) {
        return $this.templateHtmlSizeMetric;
    }

    public static final /* synthetic */ SingleValueMetric access$getMainVideoSizeMetric$p(BaseAdLoader $this) {
        return $this.mainVideoSizeMetric;
    }

    public static final /* synthetic */ boolean access$processVmTemplate(BaseAdLoader $this, AdAsset asset, AdPayload advertisement) {
        return $this.processVmTemplate(asset, advertisement);
    }

    public static final /* synthetic */ void access$onDownloadCompleted(BaseAdLoader $this, AdRequest request) {
        $this.onDownloadCompleted(request);
    }

    public static final /* synthetic */ TimeIntervalMetric access$getAdPreloadToReadyDurationMetric$p(BaseAdLoader $this) {
        return $this.adPreloadToReadyDurationMetric;
    }

    public static final /* synthetic */ AdLoaderCallback access$getAdLoaderCallback$p(BaseAdLoader $this) {
        return $this.adLoaderCallback;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/load/BaseAdLoader$Companion;", "", "()V", "DOWNLOADED_FILE_NOT_FOUND", "", "TAG", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

