/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.content.Context;
import android.os.StatFs;
import com.vungle.ads.internal.util.Logger;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0006J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000eJ\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/vungle/ads/internal/util/PathProvider;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cleverCacheDir", "Ljava/io/File;", "getContext", "()Landroid/content/Context;", "vmDir", "vungleDir", "getAvailableBytes", "", "path", "", "getCleverCacheDir", "getDownloadsDirForAd", "adId", "getSharedPrefsDir", "getUnclosedAdFile", "name", "getVmDir", "getVungleDir", "Companion", "vungle-ads_release"})
public final class PathProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final File vungleDir;
    @NotNull
    private final File vmDir;
    @NotNull
    private final File cleverCacheDir;
    @NotNull
    private static final String VUNGLE_FOLDER = "vungle_cache";
    @NotNull
    private static final String VM_FOLDER = "adAssets";
    @NotNull
    private static final String CLEVER_CACHE_FOLDER = "clever_cache";
    private static final long UNKNOWN_SIZE = -1L;

    public PathProvider(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.vungleDir = new File(this.context.getNoBackupFilesDir(), VUNGLE_FOLDER);
        this.vmDir = new File(this.vungleDir, VM_FOLDER);
        this.cleverCacheDir = new File(this.vungleDir, CLEVER_CACHE_FOLDER);
        Object[] objectArray = new File[]{this.vungleDir, this.vmDir, this.cleverCacheDir};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.exists()) continue;
            it.mkdirs();
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final File getVungleDir() {
        if (!this.vungleDir.exists()) {
            this.vungleDir.mkdirs();
        }
        return this.vungleDir;
    }

    @NotNull
    public final File getCleverCacheDir() {
        if (!this.cleverCacheDir.exists()) {
            this.cleverCacheDir.mkdirs();
        }
        return this.cleverCacheDir;
    }

    @NotNull
    public final File getVmDir() {
        if (!this.vmDir.exists()) {
            this.vmDir.mkdirs();
        }
        return this.vmDir;
    }

    @Nullable
    public final File getDownloadsDirForAd(@Nullable String adId) {
        CharSequence charSequence = adId;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        File vmDirForAd = this.getVmDir();
        File adDir = new File(vmDirForAd, adId);
        if (!adDir.exists()) {
            adDir.mkdirs();
        }
        return adDir;
    }

    @NotNull
    public final File getSharedPrefsDir() {
        File file = this.context.getNoBackupFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.noBackupFilesDir");
        return file;
    }

    @NotNull
    public final File getUnclosedAdFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new File(this.getSharedPrefsDir(), name);
    }

    public final long getAvailableBytes(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long bytesAvailable = -1L;
        StatFs stats = null;
        try {
            stats = new StatFs(path);
            bytesAvailable = stats.getAvailableBytes();
        }
        catch (IllegalArgumentException e2) {
            Logger.Companion.w("PathProvider", "Failed to get available bytes " + e2.getMessage());
        }
        return bytesAvailable;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vungle/ads/internal/util/PathProvider$Companion;", "", "()V", "CLEVER_CACHE_FOLDER", "", "UNKNOWN_SIZE", "", "VM_FOLDER", "VUNGLE_FOLDER", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

