package com.vungle.ads.fpd

import com.vungle.ads.internal.util.RangeUtil
import kotlinx.serialization.InternalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@OptIn(InternalSerializationApi::class) @Serializable
class Revenue {
    @SerialName("iaa_revenue_usd")
    private var iaaRevenueUSD: Float? = null

    @SerialName("iap_revenue_usd")
    private var iapRevenueUSD: Float? = null

    @SerialName("total_revenue_usd")
    private var totalRevenueUSD: Float? = null

    @SerialName("is_user_a_purchaser")
    private var isUserAPurchaser: Boolean? = null

    // Setter methods
    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setTotalEarningsUsd(totalEarningsUsd: Float): Revenue {
        return this
    }

    fun setIAARevenueUSD(iaaRevenueUSD: Float): Revenue {
        if (RangeUtil.isInRange(iaaRevenueUSD, 0f)) {
            this.iaaRevenueUSD = iaaRevenueUSD
        }
        return this
    }

    fun setIAPRevenueUSD(iapRevenueUSD: Float): Revenue {
        if (RangeUtil.isInRange(iapRevenueUSD, 0f)) {
            this.iapRevenueUSD = iapRevenueUSD
        }
        return this
    }

    fun setTotalRevenueUSD(totalRevenueUSD: Float): Revenue {
        if (RangeUtil.isInRange(totalRevenueUSD, 0f)) {
            this.totalRevenueUSD = totalRevenueUSD
        }
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setEarningsByPlacement(earningsByPlacement: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setTopNAdomain(topNAdomain: List<String>?): Revenue {
        return this
    }

    fun setIsUserAPurchaser(isUserAPurchaser: Boolean): Revenue {
        this.isUserAPurchaser = isUserAPurchaser
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setIsUserASubscriber(isUserASubscriber: Boolean): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast7DaysMedianSpendUsd(last7DaysMedianSpendUsd: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast7DaysTotalSpendUsd(last7DaysTotalSpendUsd: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast30DaysTotalSpendUsd(last30DaysTotalSpendUsd: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast7DaysMeanSpendUsd(last7DaysMeanSpendUsd: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast30DaysMedianSpendUsd(last30DaysMedianSpendUsd: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast30DaysMeanSpendUsd(last30DaysMeanSpendUsd: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast7DaysUserPltvUsd(last7DaysUserPltvUsd: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast7DaysUserLtvUsd(last7DaysUserLtvUsd: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast30DaysUserPltvUsd(last30DaysUserPltvUsd: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast30DaysUserLtvUsd(last30DaysUserLtvUsd: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast7DaysPlacementFillRate(last7DaysPlacementFillRate: Float): Revenue {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLast30DaysPlacementFillRate(last30DaysPlacementFillRate: Float): Revenue {
        return this
    }
}