package com.vungle.ads.internal

internal object Constants {
    @JvmField
    val DEFAULT_ADS_ENDPOINT = "https://adx.ads.vungle.com/api/ads"
    @JvmField
    val DEFAULT_ERROR_LOGS_ENDPOINT = "https://logs.ads.vungle.com/sdk/error_logs"
    @JvmField
    val DEFAULT_METRICS_ENDPOINT = "https://logs.ads.vungle.com/sdk/metrics"

    //TPAT Events
    const val CHECKPOINT_0 = "checkpoint.0"
    const val VIDEO_LENGTH_TPAT = "video.length"
    const val DEEPLINK_CLICK = "deeplink.click"
    const val CLICK_URL = "clickUrl"
    const val AD_CLOSE = "ad.close"
    const val AD_LOAD_DURATION = "ad.loadDuration"

    // tpat keys for error logs
    const val IMPRESSION = "impression"
    const val WIN_NOTIFICATION = "win-notification"
    const val COORDINATE = "coordinate"
    const val LOAD_AD = "load_ad"
    const val CTA_URL = "cta_url"

    const val REMOTE_PLAY_KEY = "{{{remote_play}}}"
    const val DEEPLINK_SUCCESS_KEY = "{{{is_success}}}"
    const val SESSION_ID = "{{{session_id}}}"
    const val VIDEO_LENGTH_KEY = "{{{vlen}}}"

    /** Total time that user spent on watching Ad
    In topic schema 'ad_duration', long */
    const val AD_DURATION_KEY = "{{{dur}}}"

    /** Network Carrier
    In topic schema 'network_operator', string */
    const val NETWORK_OPERATOR_KEY = "{{{carrier}}}"

    /** Time taken from publisher ad request to delegate callback that ad is available.
     * Including viewed and non-viewed Ad, so sent during ad load".
     * In topic schema 'time_to_download', long */
    const val AD_LOAD_DURATION_KEY = "{{{time_dl}}}"

    /** Volume of Phone at time of ad playback
    In topic schema 'volume', double */
    const val DEVICE_VOLUME_KEY = "{{{vol}}}"

    // Cacheable assets token
    const val KEY_MAIN_VIDEO = "MAIN_VIDEO"
    const val KEY_PRIVACY_ICON_URL = "VUNGLE_PRIVACY_ICON_URL"

    // Placement type
    const val PLACEMENT_TYPE_INTERSTITIAL = "interstitial"
    const val PLACEMENT_TYPE_REWARDED = "rewarded"
    const val PLACEMENT_TYPE_BANNER = "banner"
    const val PLACEMENT_TYPE_MREC = "mrec"
    const val PLACEMENT_TYPE_NATIVE = "native"
    const val PLACEMENT_TYPE_IN_LINE = "in_line"
    const val PLACEMENT_TYPE_APP_OPEN = "appopen"

    // Template type
    const val TEMPLATE_TYPE_FULLSCREEN = "fullscreen"
    const val TEMPLATE_TYPE_BANNER = "banner"
    const val TEMPLATE_TYPE_MREC = "mrec"
    const val TEMPLATE_TYPE_NATIVE = "native"
    const val TEMPLATE_TYPE_IN_LINE = "in_line"

    // OM SDK JS file names
    const val OM_SDK_JS = "omsdk.js"
    const val OM_SESSION_JS = "omsdk-session.js"

    // Network timeout in seconds
    const val TIMEOUT = 60

    //1 - Ad view invisible on play.
    //2 - Ad view visible on play.
    //3 - Ad view invisible on play but became visible after.
    const val AD_VISIBILITY_INVISIBLE = 1L
    const val AD_VISIBILITY_VISIBLE = 2L
    const val AD_VISIBILITY_VISIBLE_LATER = 3L

    //1 - When app goest to background, CP.0 not fired
    const val CP_0_NOT_FIRED = 1L

    // LO Privacy Icon fallback
    const val LO_PRIVACY_ICON_STRING = "iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAIRlWElmTU0AKgAAAAgABQESAAMAAAABAAEAAAEaAAUAAAABAAAASgEbAAUAAAABAAAAUgEoAAMAAAABAAIAAIdpAAQAAAABAAAAWgAAAAAAAABIAAAAAQAAAEgAAAABAAOgAQADAAAAAQABAACgAgAEAAAAAQAAABSgAwAEAAAAAQAAABQAAAAAQeed/gAAAAlwSFlzAAALEwAACxMBAJqcGAAAABxpRE9UAAAAAgAAAAAAAAAKAAAAKAAAAAoAAAAKAAAB9+x9rI0AAAHDSURBVDgRfJJLSwJhFIb7Af2G/kEEQVAEFdQigjYtWhW0CVq0CdpUIFKEYZhYylgpZSEThggWJhUmlJGSBRmB2hUbbyUyONPYePnyLWaQyGY4zOGc933O+fimru6PRyBCQ4EUej9LhSk2x9FMNHnLPKSukaOGHjR/WH9KaULqxaI4yvH8ZprJ+ML+x/AZfRm1K9xB4/COW929uo1Ajhp60EALj1gSx8CQB6DoMV3E10dsx5o+k22uzWBSNuv0iibt8kyjRotvdY4eNNDCAy8YMjAWiUckyHy7wYiASTdgsbqWvOcBRyiCQI4aetU6eF/u4vcy8Dn0GlV1Uhvfog7jqrJFZ3AueE6zGVYUSZFUB2r7ix4fNPMVLTzwgiEDQVd1UZvSZo65Qy8g+eIn4fMCyXF8GcHxH9/5ezKbtyvdHmnTmsDZ1hVK02e2vCeyPIAAY1NBzBPAypX36SaW0A9u00w4ldH2b2zBUxOIiZgMWOU3YXEkdc+aOfHylsOGJ2b/FfoYyrJcUdqyJhA3CRM2OaJ8AXrSeWCdcLp8dDCES8FG2BhAaQA8/wIBwobGIdqGoyEs4449gHanXYc4qgSE9jfwCwAA//+KFItXAAABtklEQVR9UUtLAmEU9Tf0N1oEQVBID6hVUcto07Jdm2jVJqSQoDCpFC20MgkLAu2BCEm0SBf2Qu2tkaGmpSnjzDjjODl9R/iizJrhcl/nHO69n0pFvuebl+hMl2ld07xg2Bzbc0fOYilth3nZv31x7XOch2d7Vqzu+WO/vn9twzbq3Eeef2ckxODMdJrWYuFEBFrVrypIilq10QyhgDP8EAvGM6JcUgRJVG5Poonk4ysDH/TeJQk+h7iKJ5xfgslI+mq2e9kOgKZlwWgYtDuyqTwvKbLCi4JChZFXyJ9J5jhggAUH20GDDqhiWd5pHt7yVAFkQnisd7obiuayjARRGGJMj953LLjQ+BIUZbkv6L1PT7Uumejak036xYlGnV7Xa7VZRnZcq8QQo4YeTgMsOOCKsjjwJYhA+ChpA65QarrNaAHw0OQL0IcACYbJDuaOfOgBAyw44P4Qo0lZKY9fem7jWAv3gmFNPAIMMa3jHMCCQ/l1fVEuDQlySWA5vgLD7fDSMMS0Th5KBLauSG2xUCiqOY5/ouRaj16hILTX8v7NGYZp4DhunOV5HxF8JfaGGDX0/iJ/Apualt8qeDHZAAAAAElFTkSuQmCC"
    // Default Privacy Icon file name
    const val PRIVACY_ICON_FILE_NAME = "edsp-privacy.png"
}
