package com.vungle.ads.internal.signals

import com.vungle.ads.internal.model.UnclosedAd
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import java.util.UUID

@Serializable
data class SessionData(
    @SerialName("${SignalKey.SESSION_COUNT}") val sessionCount: Int
) {

    @SerialName("${SignalKey.SESSION_ID}")
    val sessionId = UUID.randomUUID().toString()

    @SerialName("${SignalKey.SESSION_CREATION_TIME}")
    var sessionCreationTime: Long = System.currentTimeMillis() / 1000L

    @SerialName("${SignalKey.AD_SIGNAL}")
    var signaledAd = mutableListOf<SignaledAd>()

    @SerialName("${SignalKey.SESSION_DURATION}")
    var sessionDuration: Long = 0

    @SerialName("${SignalKey.SESSION_DEPTH}")
    var sessionDepthCounter: Int = 0

    @SerialName("${SignalKey.UNCLOSED_AD}")
    var unclosedAd: List<UnclosedAd> = ArrayList()

    @SerialName("${SignalKey.IS_DEVICE}")
    var isDevice: Int = 0

    @SerialName("${SignalKey.IS_VPN_CONNECTED}")
    var isVPNConnected: Int = 0

    @SerialName("${SignalKey.OVERLAY_PERMISSION_GRANTED}")
    var overlayGranted: Int = 0

    @SerialName("${SignalKey.SENSOR_COUNT}")
    var sensorCount: Int = 0

    @SerialName("${SignalKey.HTTP_PROXY_ENABLED}")
    var httpProxyEnabled: Int = 0

}
