/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal;

import android.content.Context;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.BidTokenCallback;
import com.vungle.ads.SdkVersionTooLow;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.TimeIntervalMetric;
import com.vungle.ads.VungleAds;
import com.vungle.ads.internal.bidding.BidTokenEncoder;
import com.vungle.ads.internal.executor.SDKExecutors;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.util.Utils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b\u00b2\u0006\n\u0010\f\u001a\u00020\rX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u000e\u001a\u00020\u000fX\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/VungleInternal;", "", "()V", "getAvailableBidTokensAsync", "", "context", "Landroid/content/Context;", "callback", "Lcom/vungle/ads/BidTokenCallback;", "getSdkVersion", "", "vungle-ads_release", "bidTokenEncoder", "Lcom/vungle/ads/internal/bidding/BidTokenEncoder;", "sdkExecutors", "Lcom/vungle/ads/internal/executor/SDKExecutors;"})
public final class VungleInternal {
    public final void getAvailableBidTokensAsync(@NotNull Context context, @NotNull BidTokenCallback callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (Utils.INSTANCE.isOSVersionInvalid()) {
            String error = "RTB: SDK is supported only for API versions 25 and above.";
            new SdkVersionTooLow(error).logErrorNoReturnValue$vungle_ads_release();
            callback.onBidTokenError(error);
            return;
        }
        if (!VungleAds.Companion.isInitialized()) {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            PrivacyManager.INSTANCE.init(context2);
        }
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy bidTokenEncoder$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<BidTokenEncoder>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final BidTokenEncoder invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(BidTokenEncoder.class);
            }
        }));
        ServiceLocator.Companion this_$iv2 = ServiceLocator.Companion;
        boolean $i$f$inject2 = false;
        Lazy sdkExecutors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SDKExecutors>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final SDKExecutors invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(SDKExecutors.class);
            }
        }));
        VungleInternal.getAvailableBidTokensAsync$lambda-1((Lazy<SDKExecutors>)sdkExecutors$delegate).getApiExecutor().execute(() -> VungleInternal.getAvailableBidTokensAsync$lambda-2(callback, bidTokenEncoder$delegate));
    }

    @NotNull
    public final String getSdkVersion() {
        return "7.6.1";
    }

    private static final BidTokenEncoder getAvailableBidTokensAsync$lambda-0(Lazy<BidTokenEncoder> $bidTokenEncoder$delegate) {
        Lazy<BidTokenEncoder> lazy = $bidTokenEncoder$delegate;
        return (BidTokenEncoder)lazy.getValue();
    }

    private static final SDKExecutors getAvailableBidTokensAsync$lambda-1(Lazy<SDKExecutors> $sdkExecutors$delegate) {
        Lazy<SDKExecutors> lazy = $sdkExecutors$delegate;
        return (SDKExecutors)lazy.getValue();
    }

    private static final void getAvailableBidTokensAsync$lambda-2(BidTokenCallback $callback, Lazy $bidTokenEncoder$delegate) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)$bidTokenEncoder$delegate, (String)"$bidTokenEncoder$delegate");
        TimeIntervalMetric bidTokenDurationMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.BID_TOKEN_REQUEST_TO_RESPONSE_DURATION_MS);
        bidTokenDurationMetric.markStart();
        BidTokenEncoder.BiddingTokenInfo bidTokenInfo = VungleInternal.getAvailableBidTokensAsync$lambda-0((Lazy<BidTokenEncoder>)$bidTokenEncoder$delegate).encode();
        bidTokenDurationMetric.markEnd();
        if (((CharSequence)bidTokenInfo.getBidToken()).length() > 0) {
            $callback.onBidTokenCollected(bidTokenInfo.getBidToken());
        } else {
            bidTokenDurationMetric.setMetricType(Sdk.SDKMetric.SDKMetricType.BID_TOKEN_REQUEST_TO_FAIL_DURATION_MS);
            bidTokenDurationMetric.setMeta(bidTokenInfo.getErrorMessage());
            $callback.onBidTokenError(bidTokenInfo.getErrorMessage());
        }
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, bidTokenDurationMetric, null, null, 6, null);
    }
}

