/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.model;

import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AdConfig;
import com.vungle.ads.TpatError;
import com.vungle.ads.internal.model.AdAsset;
import com.vungle.ads.internal.model.AdPayload$;
import com.vungle.ads.internal.model.AdPayload$AdSizeInfo$;
import com.vungle.ads.internal.model.AdPayload$AdUnit$;
import com.vungle.ads.internal.model.AdPayload$CacheableReplacement$;
import com.vungle.ads.internal.model.AdPayload$PlacementAdUnit$;
import com.vungle.ads.internal.model.AdPayload$TemplateSettings$;
import com.vungle.ads.internal.model.AdPayload$ViewAbility$;
import com.vungle.ads.internal.model.AdPayload$ViewAbilityInfo$;
import com.vungle.ads.internal.model.AdPayload$WebViewSettings$;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.model.ConfigPayload$;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.LogEntry;
import com.vungle.ads.internal.util.Logger;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.Contextual;
import kotlinx.serialization.ContextualSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.BooleanSerializer;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.LongSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonTransformingSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 \u0086\u00012\u00020\u0001:\u0016\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001\u008b\u0001\u008c\u0001B\u0083\u0001\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0001\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0016\b\u0001\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u0012\u0016\b\u0001\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015B#\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010A\u001a\u00020\u0003J\u0006\u0010B\u001a\u00020\u0011J\b\u0010C\u001a\u0004\u0018\u00010#J\u0006\u0010D\u001a\u00020\u0003J\b\u0010E\u001a\u0004\u0018\u00010\rJ%\u0010F\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00030G2\b\u0010H\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010IJ\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0006\u0010J\u001a\u00020KJ\b\u0010L\u001a\u0004\u0018\u00010\rJ\b\u0010M\u001a\u0004\u0018\u00010\rJ\u0006\u0010N\u001a\u00020\rJ\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020>0\u00052\u0006\u0010P\u001a\u00020QJ\u001e\u0010R\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020Q\u0018\u00010G2\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010S\u001a\u0004\u0018\u00010>2\u0006\u0010T\u001a\u00020\rJ\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fJ\b\u0010V\u001a\u0004\u0018\u00010\rJ\u0015\u0010W\u001a\u00020\u00032\b\u0010X\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010YJ.\u0010Z\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00052\u0006\u0010[\u001a\u00020\r2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010]\u001a\u0004\u0018\u00010\rJ\b\u0010^\u001a\u0004\u0018\u00010\rJ\b\u0010_\u001a\u0004\u0018\u00010`J\u000e\u0010a\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0005J\u0006\u0010b\u001a\u00020\u0011J\u0006\u0010c\u001a\u00020\u0011J\u0006\u0010d\u001a\u00020\u0011J\u000e\u0010e\u001a\u00020\u00112\u0006\u0010f\u001a\u00020\rJ\u0006\u0010g\u001a\u00020\u0011J\u0006\u0010h\u001a\u00020\u0011J\u0006\u0010i\u001a\u00020\u0011J\b\u0010j\u001a\u0004\u0018\u00010\rJ\u0006\u0010k\u001a\u00020lJ\u0006\u0010m\u001a\u00020lJ&\u0010n\u001a\u00020l2\u0006\u0010o\u001a\u00020\r2\u0006\u0010p\u001a\u00020\r2\u0006\u0010q\u001a\u00020\r2\u0006\u0010r\u001a\u00020\rJ\b\u0010s\u001a\u0004\u0018\u00010\rJ\u0016\u0010t\u001a\u00020l2\u0006\u0010u\u001a\u00020\r2\u0006\u0010v\u001a\u00020QJ\u0006\u0010w\u001a\u00020\u0011J\u0012\u0010x\u001a\u00020\r2\b\u0010\\\u001a\u0004\u0018\u00010\rH\u0002J!\u0010y\u001a\u00020l2\u0006\u0010z\u001a\u00020\u00002\u0006\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020~H\u00c7\u0001J \u0010\u007f\u001a\u00020\r*\u00020\r2\u0007\u0010\u0080\u0001\u001a\u00020\r2\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010\rH\u0002R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R&\u0010\u001a\u001a\u0004\u0018\u00010\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b&\u0010\u001dR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b+\u0010\u001dR\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010,R0\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b-\u0010\u001d\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\"\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u00102\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R&\u00105\u001a\u0004\u0018\u0001068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b7\u0010\u001d\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b<\u0010\u001dR(\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020>0\u000f8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b?\u0010\u001d\u001a\u0004\b@\u0010/\u00a8\u0006\u008d\u0001"}, d2={"Lcom/vungle/ads/internal/model/AdPayload;", "", "seen1", "", "ads", "", "Lcom/vungle/ads/internal/model/AdPayload$PlacementAdUnit;", "config", "Lcom/vungle/ads/internal/model/ConfigPayload;", "expiryWindowStart", "", "mraidFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "incentivizedTextSettings", "", "assetsFullyDownloaded", "", "indexFilePath", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lcom/vungle/ads/internal/model/ConfigPayload;Ljava/lang/Long;Ljava/util/concurrent/ConcurrentHashMap;Ljava/util/Map;ZLjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/util/List;Lcom/vungle/ads/internal/model/ConfigPayload;)V", "ad", "getAd", "()Lcom/vungle/ads/internal/model/AdPayload$PlacementAdUnit;", "adConfig", "Lcom/vungle/ads/AdConfig;", "getAdConfig$annotations", "()V", "getAdConfig", "()Lcom/vungle/ads/AdConfig;", "setAdConfig", "(Lcom/vungle/ads/AdConfig;)V", "adMarkup", "Lcom/vungle/ads/internal/model/AdPayload$AdUnit;", "getAdMarkup", "()Lcom/vungle/ads/internal/model/AdPayload$AdUnit;", "getAds$annotations", "getAssetsFullyDownloaded", "()Z", "setAssetsFullyDownloaded", "(Z)V", "getConfig$annotations", "Ljava/lang/Long;", "getIncentivizedTextSettings$annotations", "getIncentivizedTextSettings", "()Ljava/util/Map;", "setIncentivizedTextSettings", "(Ljava/util/Map;)V", "<set-?>", "getIndexFilePath", "()Ljava/lang/String;", "logEntry", "Lcom/vungle/ads/internal/util/LogEntry;", "getLogEntry$vungle_ads_release$annotations", "getLogEntry$vungle_ads_release", "()Lcom/vungle/ads/internal/util/LogEntry;", "setLogEntry$vungle_ads_release", "(Lcom/vungle/ads/internal/util/LogEntry;)V", "getMraidFiles$annotations", "partialDownloadAssets", "Lcom/vungle/ads/internal/model/AdAsset;", "getPartialDownloadAssets$vungle_ads_release$annotations", "getPartialDownloadAssets$vungle_ads_release", "adHeight", "adLoadOptimizationEnabled", "adUnit", "adWidth", "advAppId", "computeAssetRequirement", "Lkotlin/Pair;", "percentage", "(Ljava/lang/Integer;)Lkotlin/Pair;", "createMRAIDArgs", "Lkotlinx/serialization/json/JsonObject;", "eventId", "getAdSource", "getCreativeId", "getDownloadableAssets", "dir", "Ljava/io/File;", "getIndexHtmlFile", "getLocalPartialDownloadAssets", "remoteUrl", "getMRAIDArgsInMap", "getMediationName", "getShowCloseDelay", "incentivized", "(Ljava/lang/Boolean;)I", "getTpatUrls", "event", "value", "secondValue", "getViewMasterVersion", "getWebViewSettings", "Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;", "getWinNotifications", "hasExpired", "heartbeatEnabled", "isClickCoordinatesTrackingEnabled", "isCriticalAsset", "failingUrl", "isNativeTemplateType", "isPartialDownloadEnabled", "omEnabled", "placementId", "recordExpiryWindowStart", "", "setAssetFullyDownloaded", "setIncentivizedText", "title", "body", "keepWatching", "close", "templateType", "updateAdAssetPath", "adIdentifier", "localFile", "usePreloading", "valueOrEmpty", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "complexReplace", "oldValue", "newValue", "$serializer", "AdSizeInfo", "AdUnit", "CacheableReplacement", "Companion", "PlacementAdUnit", "TemplateSettings", "TpatSerializer", "ViewAbility", "ViewAbilityInfo", "WebViewSettings", "vungle-ads_release"})
public final class AdPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final List<PlacementAdUnit> ads;
    @Nullable
    private final ConfigPayload config;
    @Nullable
    private Long expiryWindowStart;
    @NotNull
    private ConcurrentHashMap<String, String> mraidFiles;
    @NotNull
    private Map<String, String> incentivizedTextSettings;
    private boolean assetsFullyDownloaded;
    @Nullable
    private AdConfig adConfig;
    @Nullable
    private LogEntry logEntry;
    @Nullable
    private String indexFilePath;
    @NotNull
    private final Map<String, AdAsset> partialDownloadAssets;
    @NotNull
    private static final String TAG = "AdPayload";
    @NotNull
    public static final String FILE_SCHEME = "file://";
    @NotNull
    public static final String KEY_VM = "vmURL";
    @NotNull
    public static final String INCENTIVIZED_TITLE_TEXT = "INCENTIVIZED_TITLE_TEXT";
    @NotNull
    public static final String INCENTIVIZED_BODY_TEXT = "INCENTIVIZED_BODY_TEXT";
    @NotNull
    public static final String INCENTIVIZED_CLOSE_TEXT = "INCENTIVIZED_CLOSE_TEXT";
    @NotNull
    public static final String INCENTIVIZED_CONTINUE_TEXT = "INCENTIVIZED_CONTINUE_TEXT";
    @NotNull
    private static final String UNKNOWN = "unknown";
    @NotNull
    public static final String TPAT_CLICK_COORDINATES_URLS = "video.clickCoordinates";

    public AdPayload(@Nullable List<PlacementAdUnit> ads, @Nullable ConfigPayload config) {
        this.ads = ads;
        this.config = config;
        this.mraidFiles = new ConcurrentHashMap();
        this.incentivizedTextSettings = new HashMap();
        this.partialDownloadAssets = new LinkedHashMap();
    }

    public /* synthetic */ AdPayload(List list, ConfigPayload configPayload, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = null;
        }
        if ((n & 2) != 0) {
            configPayload = null;
        }
        this(list, configPayload);
    }

    @SerialName(value="ads")
    private static /* synthetic */ void getAds$annotations() {
    }

    @SerialName(value="config")
    private static /* synthetic */ void getConfig$annotations() {
    }

    private final PlacementAdUnit getAd() {
        PlacementAdUnit placementAdUnit;
        List<PlacementAdUnit> list = this.ads;
        if (list != null) {
            List<PlacementAdUnit> it = list;
            boolean bl = false;
            placementAdUnit = !((Collection)it).isEmpty() ? it.get(0) : (PlacementAdUnit)null;
        } else {
            placementAdUnit = null;
        }
        return placementAdUnit;
    }

    private final AdUnit getAdMarkup() {
        PlacementAdUnit placementAdUnit = this.getAd();
        return placementAdUnit != null ? placementAdUnit.getAdMarkup() : null;
    }

    @Nullable
    public final String placementId() {
        PlacementAdUnit placementAdUnit = this.getAd();
        return placementAdUnit != null ? placementAdUnit.getPlacementReferenceId() : null;
    }

    @Nullable
    public final String eventId() {
        AdUnit adUnit = this.getAdMarkup();
        return adUnit != null ? adUnit.getId() : null;
    }

    @Nullable
    public final String advAppId() {
        AdUnit adUnit = this.getAdMarkup();
        return adUnit != null ? adUnit.getAdvAppId() : null;
    }

    public final int adWidth() {
        Object object = this.getAdMarkup();
        return object != null && (object = ((AdUnit)object).getAdSizeInfo()) != null && (object = ((AdSizeInfo)object).getWidth()) != null ? (Integer)object : 0;
    }

    public final int adHeight() {
        Object object = this.getAdMarkup();
        return object != null && (object = ((AdUnit)object).getAdSizeInfo()) != null && (object = ((AdSizeInfo)object).getHeight()) != null ? (Integer)object : 0;
    }

    @Nullable
    public final AdUnit adUnit() {
        return this.getAdMarkup();
    }

    @Nullable
    public final ConfigPayload config() {
        return this.config;
    }

    public final boolean adLoadOptimizationEnabled() {
        Object object = this.getAdMarkup();
        return object != null && (object = ((AdUnit)object).getAdLoadOptimizationEnabled()) != null ? (Boolean)object : true;
    }

    public final boolean isPartialDownloadEnabled() {
        Object object = this.getAdMarkup();
        return object != null && (object = ((AdUnit)object).getPartialDownloadEnabled()) != null ? (Boolean)object : false;
    }

    @Contextual
    private static /* synthetic */ void getMraidFiles$annotations() {
    }

    @NotNull
    public final Map<String, String> getIncentivizedTextSettings() {
        return this.incentivizedTextSettings;
    }

    public final void setIncentivizedTextSettings(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.incentivizedTextSettings = map;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIncentivizedTextSettings$annotations() {
    }

    public final boolean getAssetsFullyDownloaded() {
        return this.assetsFullyDownloaded;
    }

    public final void setAssetsFullyDownloaded(boolean bl) {
        this.assetsFullyDownloaded = bl;
    }

    @Nullable
    public final AdConfig getAdConfig() {
        return this.adConfig;
    }

    public final void setAdConfig(@Nullable AdConfig adConfig) {
        this.adConfig = adConfig;
    }

    @Transient
    public static /* synthetic */ void getAdConfig$annotations() {
    }

    @Nullable
    public final LogEntry getLogEntry$vungle_ads_release() {
        return this.logEntry;
    }

    public final void setLogEntry$vungle_ads_release(@Nullable LogEntry logEntry2) {
        this.logEntry = logEntry2;
    }

    @Transient
    public static /* synthetic */ void getLogEntry$vungle_ads_release$annotations() {
    }

    @Nullable
    public final String getIndexFilePath() {
        return this.indexFilePath;
    }

    @NotNull
    public final Map<String, AdAsset> getPartialDownloadAssets$vungle_ads_release() {
        return this.partialDownloadAssets;
    }

    @Transient
    @VisibleForTesting
    public static /* synthetic */ void getPartialDownloadAssets$vungle_ads_release$annotations() {
    }

    public final boolean omEnabled() {
        Object object = this.getAdMarkup();
        return object != null && (object = ((AdUnit)object).getViewAbility()) != null && (object = ((ViewAbility)object).getOm()) != null && (object = ((ViewAbilityInfo)object).isEnabled()) != null ? (Boolean)object : false;
    }

    public final boolean isClickCoordinatesTrackingEnabled() {
        Object object = this.getAdMarkup();
        return object != null && (object = ((AdUnit)object).getClickCoordinatesEnabled()) != null ? (Boolean)object : false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCriticalAsset(@NotNull String failingUrl) {
        boolean bl;
        Map<String, CacheableReplacement> map;
        TemplateSettings templateSettings;
        AdUnit adUnit;
        Intrinsics.checkNotNullParameter((Object)failingUrl, (String)"failingUrl");
        if (!this.isNativeTemplateType()) {
            AdUnit adUnit2 = this.getAdMarkup();
            if (Intrinsics.areEqual((Object)(adUnit2 != null ? adUnit2.getVmURL() : null), (Object)failingUrl)) {
                return true;
            }
        }
        if ((adUnit = this.getAdMarkup()) != null && (templateSettings = adUnit.getTemplateSettings()) != null && (map = templateSettings.getCacheableReplacements()) != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Map<String, CacheableReplacement> map2 = map;
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)((CacheableReplacement)it.getValue()).getUrl(), (Object)failingUrl)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            bl = !destination$iv$iv.isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean heartbeatEnabled() {
        Object object = this.getAdMarkup();
        return object != null && (object = ((AdUnit)object).getTemplateHeartbeatCheck()) != null ? (Boolean)object : false;
    }

    @Nullable
    public final AdAsset getLocalPartialDownloadAssets(@NotNull String remoteUrl) {
        Intrinsics.checkNotNullParameter((Object)remoteUrl, (String)"remoteUrl");
        return this.partialDownloadAssets.get(remoteUrl);
    }

    private final Pair<String, File> getIndexHtmlFile(File dir) {
        Object object;
        Object object2;
        block9: {
            block8: {
                if (this.isNativeTemplateType()) {
                    return null;
                }
                object2 = this.getAdMarkup();
                if (object2 == null || (object2 = ((AdUnit)object2).getVmURL()) == null) break block8;
                Object it = object = object2;
                boolean bl = false;
                object2 = FileUtility.INSTANCE.isValidUrl((String)it) ? object : null;
                if (object2 != null) break block9;
            }
            return null;
        }
        Object url = object2;
        Object object3 = this;
        try {
            AdPayload $this$getIndexHtmlFile_u24lambda_u2d3 = object3;
            boolean bl = false;
            String string = new URI((String)url).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URI(url).path");
            char[] cArray = new char[]{'/'};
            CharSequence charSequence = StringsKt.trim((String)string, (char[])cArray);
            cArray = new char[]{'/'};
            List segments = StringsKt.split$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            object = Result.constructor-impl((Object)(segments.size() >= 2 ? CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)segments, (int)2), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null) : "index.html"));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = object;
        String string = (String)(Result.isFailure-impl((Object)object3) ? null : object3);
        if (string == null) {
            return null;
        }
        String indexHtmlName = string;
        File file = dir.getParentFile();
        if (file == null) {
            return null;
        }
        File parent = file;
        return new Pair(url, (Object)new File(parent, indexHtmlName));
    }

    private final Pair<Boolean, Integer> computeAssetRequirement(Integer percentage) {
        return this.isNativeTemplateType() || !this.adLoadOptimizationEnabled() ? TuplesKt.to((Object)true, null) : (!this.isPartialDownloadEnabled() ? TuplesKt.to((Object)false, null) : (percentage != null && percentage > 0 ? TuplesKt.to((Object)true, (Object)percentage) : TuplesKt.to((Object)false, null)));
    }

    @NotNull
    public final List<AdAsset> getDownloadableAssets(@NotNull File dir) {
        Map<String, CacheableReplacement> map;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        List ret = new ArrayList();
        Pair<String, File> pair = this.getIndexHtmlFile(dir);
        if (pair != null) {
            Pair<String, File> pair2 = pair;
            boolean bl = false;
            String url = (String)pair2.component1();
            File indexFile = (File)pair2.component2();
            this.indexFilePath = indexFile.getAbsolutePath();
            if (!indexFile.exists()) {
                Logger.Companion.d(TAG, "No cacheable index file found, creating new one: " + indexFile);
                String string = indexFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"indexFile.absolutePath");
                ret.add(new AdAsset(KEY_VM, url, string, true, null, 16, null));
            }
        }
        if ((map = this.getAdMarkup()) != null && (map = ((AdUnit)((Object)map)).getTemplateSettings()) != null && (map = ((TemplateSettings)((Object)map)).getCacheableReplacements()) != null) {
            Map<String, CacheableReplacement> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, CacheableReplacement>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, CacheableReplacement> element$iv;
                Map.Entry<String, CacheableReplacement> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                CacheableReplacement value = entry.getValue();
                String url = value.getUrl();
                if (url == null || !FileUtility.INSTANCE.isValidUrl(url)) continue;
                String fileName = FileUtility.INSTANCE.guessFileName(url, value.getExtension());
                String filePath = new File(dir, fileName).getAbsolutePath();
                Pair<Boolean, Integer> pair3 = this.computeAssetRequirement(value.getDownloadPercent());
                boolean isRequired = (Boolean)pair3.component1();
                Integer percentage = (Integer)pair3.component2();
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
                AdAsset asset = new AdAsset(key, url, filePath, isRequired, percentage);
                ret.add(asset);
                if (!isRequired || percentage == null) continue;
                this.partialDownloadAssets.put(url, asset);
            }
        }
        List $this$sortByDescending$iv = ret;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    AdAsset it = (AdAsset)b2;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it.isRequired());
                    it = (AdAsset)a2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.isRequired()));
                }
            });
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> getTpatUrls(@NotNull String event, @Nullable String value, @Nullable String secondValue) {
        List list;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = this.getAdMarkup();
        boolean bl = object != null && (object = ((AdUnit)object).getTpat()) != null ? !object.containsKey(event) : false;
        if (bl) {
            new TpatError(Sdk.SDKError.Reason.INVALID_TPAT_KEY, "Arbitrary tpat key: " + event).setLogEntry$vungle_ads_release(this.logEntry).logErrorNoReturnValue$vungle_ads_release();
            return null;
        }
        Object object2 = this.getAdMarkup();
        List urls = object2 != null && (object2 = ((AdUnit)object2).getTpat()) != null ? (List)object2.get(event) : null;
        Object object3 = urls;
        if (object3 == null || object3.isEmpty()) {
            new TpatError(Sdk.SDKError.Reason.EMPTY_TPAT_ERROR, "Empty tpat key: " + event).setLogEntry$vungle_ads_release(this.logEntry).logErrorNoReturnValue$vungle_ads_release();
            return null;
        }
        switch (event) {
            case "checkpoint.0": {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = urls;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.complexReplace(this.complexReplace(this.complexReplace((String)it, "{{{remote_play}}}", String.valueOf(!this.assetsFullyDownloaded)), "{{{carrier}}}", value), "{{{vol}}}", secondValue));
                }
                list = (List)destination$iv$iv;
                break;
            }
            case "video.length": {
                Iterable $this$map$iv = urls;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.complexReplace(it, "{{{vlen}}}", value));
                }
                list = (List)destination$iv$iv;
                break;
            }
            case "deeplink.click": {
                Iterable $this$map$iv = urls;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(this.complexReplace(it, "{{{is_success}}}", value));
                }
                list = (List)destination$iv$iv;
                break;
            }
            case "ad.close": {
                Iterable $this$map$iv = urls;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(this.complexReplace(this.complexReplace(it, "{{{dur}}}", value), "{{{vol}}}", secondValue));
                }
                list = (List)destination$iv$iv;
                break;
            }
            case "ad.loadDuration": {
                Iterable $this$map$iv = urls;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl6 = false;
                    collection.add(this.complexReplace(it, "{{{time_dl}}}", value));
                }
                list = (List)destination$iv$iv;
                break;
            }
            default: {
                list = urls;
            }
        }
        return list;
    }

    public static /* synthetic */ List getTpatUrls$default(AdPayload adPayload, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return adPayload.getTpatUrls(string, string2, string3);
    }

    public final void recordExpiryWindowStart() {
        this.expiryWindowStart = System.currentTimeMillis();
    }

    public final boolean hasExpired() {
        boolean bl;
        AdUnit adUnit = this.getAdMarkup();
        if (adUnit == null) {
            return false;
        }
        AdUnit markup = adUnit;
        Long start = this.expiryWindowStart;
        if (markup.getExpiryDuration() != null && start != null) {
            long elapsedSeconds = (System.currentTimeMillis() - start) / 1000L;
            Integer n = markup.getExpiryDuration();
            bl = elapsedSeconds > (n != null ? Long.valueOf(n.intValue()) : null);
        } else if (markup.getExpiry() != null) {
            Integer n = markup.getExpiry();
            bl = System.currentTimeMillis() / 1000L > (n != null ? Long.valueOf(n.intValue()) : null);
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final List<String> getWinNotifications() {
        AdUnit adUnit = this.getAdMarkup();
        return adUnit != null ? adUnit.getNotification() : null;
    }

    public final boolean isNativeTemplateType() {
        return Intrinsics.areEqual((Object)this.templateType(), (Object)"native");
    }

    @Nullable
    public final String templateType() {
        AdUnit adUnit = this.getAdMarkup();
        return adUnit != null ? adUnit.getTemplateType() : null;
    }

    public final void setIncentivizedText(@NotNull String title, @NotNull String body, @NotNull String keepWatching, @NotNull String close) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)keepWatching, (String)"keepWatching");
        Intrinsics.checkNotNullParameter((Object)close, (String)"close");
        if (((CharSequence)title).length() > 0) {
            this.incentivizedTextSettings.put(INCENTIVIZED_TITLE_TEXT, title);
        }
        if (((CharSequence)body).length() > 0) {
            this.incentivizedTextSettings.put(INCENTIVIZED_BODY_TEXT, body);
        }
        if (((CharSequence)keepWatching).length() > 0) {
            this.incentivizedTextSettings.put(INCENTIVIZED_CONTINUE_TEXT, keepWatching);
        }
        if (((CharSequence)close).length() > 0) {
            this.incentivizedTextSettings.put(INCENTIVIZED_CLOSE_TEXT, close);
        }
    }

    public final void setAssetFullyDownloaded() {
        this.assetsFullyDownloaded = true;
    }

    @NotNull
    public final Map<String, String> getMRAIDArgsInMap() {
        Map<String, CacheableReplacement> map;
        AdUnit adUnit = this.getAdMarkup();
        if ((adUnit != null ? adUnit.getTemplateSettings() : null) == null) {
            boolean bl = false;
            String string = "Advertisement does not have MRAID Arguments!";
            throw new IllegalArgumentException(string.toString());
        }
        Map resultMap = new LinkedHashMap();
        Object object = this.getAdMarkup();
        if (object != null && (object = ((AdUnit)object).getTemplateSettings()) != null && (object = ((TemplateSettings)object).getNormalReplacements()) != null) {
            Map<String, String> it = object;
            boolean bl = false;
            resultMap.putAll(it);
        }
        if ((map = this.getAdMarkup()) != null && (map = ((AdUnit)((Object)map)).getTemplateSettings()) != null && (map = ((TemplateSettings)((Object)map)).getCacheableReplacements()) != null) {
            Map<String, CacheableReplacement> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, CacheableReplacement>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                String url;
                Map.Entry<String, CacheableReplacement> element$iv;
                Map.Entry<String, CacheableReplacement> it = element$iv = iterator.next();
                boolean bl = false;
                if (it.getValue().getUrl() == null) continue;
                boolean bl2 = false;
                resultMap.put(it.getKey(), url);
            }
        }
        if (!((Map)this.mraidFiles).isEmpty()) {
            resultMap.putAll((Map)this.mraidFiles);
        }
        if (!this.incentivizedTextSettings.isEmpty()) {
            resultMap.putAll(this.incentivizedTextSettings);
        }
        return resultMap;
    }

    @NotNull
    public final JsonObject createMRAIDArgs() {
        JsonObjectBuilder builder$iv;
        Map<String, String> resultMap = this.getMRAIDArgsInMap();
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$createMRAIDArgs_u24lambda_u2d17 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        Map<String, String> $this$forEach$iv = resultMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl2 = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$createMRAIDArgs_u24lambda_u2d17, (String)it.getKey(), (String)it.getValue());
        }
        JsonObject ret = builder$iv.build();
        return ret;
    }

    public final int getShowCloseDelay(@Nullable Boolean incentivized) {
        int n;
        if (Intrinsics.areEqual((Object)incentivized, (Object)true)) {
            int n2;
            Object object = this.getAdMarkup();
            if (object != null && (object = ((AdUnit)object).getShowCloseIncentivized()) != null) {
                int it = ((Number)object).intValue();
                boolean bl = false;
                n2 = it * 1000;
            } else {
                n2 = 0;
            }
            return n2;
        }
        Object object = this.getAdMarkup();
        if (object != null && (object = ((AdUnit)object).getShowClose()) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            n = it * 1000;
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final String getCreativeId() {
        Object object = this.getAdMarkup();
        if (object == null || (object = ((AdUnit)object).getCreativeId()) == null) {
            object = UNKNOWN;
        }
        return object;
    }

    @Nullable
    public final String getAdSource() {
        AdUnit adUnit = this.getAdMarkup();
        return adUnit != null ? adUnit.getAdSource() : null;
    }

    @Nullable
    public final String getMediationName() {
        AdUnit adUnit = this.getAdMarkup();
        return adUnit != null ? adUnit.getMediationName() : null;
    }

    @Nullable
    public final String getViewMasterVersion() {
        AdUnit adUnit = this.getAdMarkup();
        return adUnit != null ? adUnit.getVmVersion() : null;
    }

    @Nullable
    public final WebViewSettings getWebViewSettings() {
        AdUnit adUnit = this.getAdMarkup();
        return adUnit != null ? adUnit.getWebViewSettings() : null;
    }

    public final boolean usePreloading() {
        AdUnit adUnit = this.getAdMarkup();
        return adUnit != null ? Intrinsics.areEqual((Object)adUnit.getUsePreloading(), (Object)true) : false;
    }

    private final String valueOrEmpty(String value) {
        String string = value;
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String complexReplace(String $this$complexReplace, String oldValue, String newValue) {
        CharSequence charSequence = $this$complexReplace;
        String string = Pattern.quote(oldValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(oldValue)");
        String string2 = string;
        string2 = new Regex(string2);
        String string3 = this.valueOrEmpty(newValue);
        return string2.replace(charSequence, string3);
    }

    public final synchronized void updateAdAssetPath(@NotNull String adIdentifier, @NotNull File localFile) {
        Intrinsics.checkNotNullParameter((Object)adIdentifier, (String)"adIdentifier");
        Intrinsics.checkNotNullParameter((Object)localFile, (String)"localFile");
        if (localFile.exists()) {
            this.mraidFiles.put(adIdentifier, FILE_SCHEME + localFile.getAbsolutePath());
        }
    }

    @JvmStatic
    public static final void write$Self(@NotNull AdPayload self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.ads != null) {
            output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)new ArrayListSerializer((KSerializer)PlacementAdUnit$$serializer.INSTANCE), self.ads);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.config != null) {
            output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)ConfigPayload$.serializer.INSTANCE, (Object)self.config);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.expiryWindowStart != null) {
            output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)LongSerializer.INSTANCE, (Object)self.expiryWindowStart);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : !Intrinsics.areEqual(self.mraidFiles, new ConcurrentHashMap())) {
            KSerializer[] kSerializerArray = new KSerializer[]{(KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE};
            output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)new ContextualSerializer(Reflection.getOrCreateKotlinClass(ConcurrentHashMap.class), null, kSerializerArray), self.mraidFiles);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual(self.incentivizedTextSettings, new HashMap())) {
            output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), self.incentivizedTextSettings);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.assetsFullyDownloaded) {
            output.encodeBooleanElement(serialDesc, 5, self.assetsFullyDownloaded);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : self.indexFilePath != null) {
            output.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.indexFilePath);
        }
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ AdPayload(int seen1, @SerialName(value="ads") List ads, @SerialName(value="config") ConfigPayload config, Long expiryWindowStart, @Contextual ConcurrentHashMap mraidFiles, @VisibleForTesting Map incentivizedTextSettings, boolean assetsFullyDownloaded, String indexFilePath, SerializationConstructorMarker serializationConstructorMarker) {
        if ((0 & seen1) != 0) {
            PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.ads = (seen1 & 1) == 0 ? null : ads;
        this.config = (seen1 & 2) == 0 ? null : config;
        this.expiryWindowStart = (seen1 & 4) == 0 ? null : expiryWindowStart;
        this.mraidFiles = (seen1 & 8) == 0 ? new ConcurrentHashMap() : mraidFiles;
        this.incentivizedTextSettings = (seen1 & 0x10) == 0 ? (Map)new HashMap() : incentivizedTextSettings;
        this.assetsFullyDownloaded = (seen1 & 0x20) == 0 ? false : assetsFullyDownloaded;
        this.adConfig = null;
        this.logEntry = null;
        this.indexFilePath = (seen1 & 0x40) == 0 ? null : indexFilePath;
        this.partialDownloadAssets = new LinkedHashMap();
    }

    public AdPayload() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$Companion;", "", "()V", "FILE_SCHEME", "", "INCENTIVIZED_BODY_TEXT", "INCENTIVIZED_CLOSE_TEXT", "INCENTIVIZED_CONTINUE_TEXT", "INCENTIVIZED_TITLE_TEXT", "KEY_VM", "TAG", "TPAT_CLICK_COORDINATES_URLS", "UNKNOWN", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/vungle/ads/internal/model/AdPayload;", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<AdPayload> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B1\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u001d\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J!\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u00c7\u0001R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$PlacementAdUnit;", "", "seen1", "", "placementReferenceId", "", "adMarkup", "Lcom/vungle/ads/internal/model/AdPayload$AdUnit;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lcom/vungle/ads/internal/model/AdPayload$AdUnit;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Lcom/vungle/ads/internal/model/AdPayload$AdUnit;)V", "getAdMarkup$annotations", "()V", "getAdMarkup", "()Lcom/vungle/ads/internal/model/AdPayload$AdUnit;", "getPlacementReferenceId$annotations", "getPlacementReferenceId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "vungle-ads_release"})
    public static final class PlacementAdUnit {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String placementReferenceId;
        @Nullable
        private final AdUnit adMarkup;

        public PlacementAdUnit(@Nullable String placementReferenceId, @Nullable AdUnit adMarkup) {
            this.placementReferenceId = placementReferenceId;
            this.adMarkup = adMarkup;
        }

        public /* synthetic */ PlacementAdUnit(String string, AdUnit adUnit, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                adUnit = null;
            }
            this(string, adUnit);
        }

        @Nullable
        public final String getPlacementReferenceId() {
            return this.placementReferenceId;
        }

        @SerialName(value="placement_reference_id")
        public static /* synthetic */ void getPlacementReferenceId$annotations() {
        }

        @Nullable
        public final AdUnit getAdMarkup() {
            return this.adMarkup;
        }

        @SerialName(value="ad_markup")
        public static /* synthetic */ void getAdMarkup$annotations() {
        }

        @Nullable
        public final String component1() {
            return this.placementReferenceId;
        }

        @Nullable
        public final AdUnit component2() {
            return this.adMarkup;
        }

        @NotNull
        public final PlacementAdUnit copy(@Nullable String placementReferenceId, @Nullable AdUnit adMarkup) {
            return new PlacementAdUnit(placementReferenceId, adMarkup);
        }

        public static /* synthetic */ PlacementAdUnit copy$default(PlacementAdUnit placementAdUnit, String string, AdUnit adUnit, int n, Object object) {
            if ((n & 1) != 0) {
                string = placementAdUnit.placementReferenceId;
            }
            if ((n & 2) != 0) {
                adUnit = placementAdUnit.adMarkup;
            }
            return placementAdUnit.copy(string, adUnit);
        }

        @NotNull
        public String toString() {
            return "PlacementAdUnit(placementReferenceId=" + this.placementReferenceId + ", adMarkup=" + this.adMarkup + ')';
        }

        public int hashCode() {
            int result = this.placementReferenceId == null ? 0 : this.placementReferenceId.hashCode();
            result = result * 31 + (this.adMarkup == null ? 0 : this.adMarkup.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlacementAdUnit)) {
                return false;
            }
            PlacementAdUnit placementAdUnit = (PlacementAdUnit)other;
            if (!Intrinsics.areEqual((Object)this.placementReferenceId, (Object)placementAdUnit.placementReferenceId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.adMarkup, (Object)placementAdUnit.adMarkup);
        }

        @JvmStatic
        public static final void write$Self(@NotNull PlacementAdUnit self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.placementReferenceId != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.placementReferenceId);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.adMarkup != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)AdUnit$$serializer.INSTANCE, (Object)self.adMarkup);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ PlacementAdUnit(int seen1, @SerialName(value="placement_reference_id") String placementReferenceId, @SerialName(value="ad_markup") AdUnit adMarkup, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen1) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)PlacementAdUnit$$serializer.INSTANCE.getDescriptor());
            }
            this.placementReferenceId = (seen1 & 1) == 0 ? null : placementReferenceId;
            this.adMarkup = (seen1 & 2) == 0 ? null : adMarkup;
        }

        public PlacementAdUnit() {
            this(null, null, 3, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$PlacementAdUnit$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/vungle/ads/internal/model/AdPayload$PlacementAdUnit;", "vungle-ads_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<PlacementAdUnit> serializer() {
                return (KSerializer)PlacementAdUnit$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\bo\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00a2\u00012\u00020\u0001:\u0004\u00a1\u0001\u00a2\u0001B\u009f\u0003\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\f\u0012\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\f\u0012\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u0012\u001c\b\u0001\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0015\u0018\u00010\u0014\u0012\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0001\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0015\u0012\u0010\b\u0001\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0015\u0012\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u0012\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u0012\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010$\u001a\u0004\u0018\u00010%\u0012\n\b\u0001\u0010&\u001a\u0004\u0018\u00010'\u0012\n\b\u0001\u0010(\u001a\u0004\u0018\u00010\f\u0012\n\b\u0001\u0010)\u001a\u0004\u0018\u00010\f\u0012\b\u0010*\u001a\u0004\u0018\u00010+\u00a2\u0006\u0002\u0010,B\u008b\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u0012\u001c\b\u0002\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0015\u0018\u00010\u0014\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0015\u0012\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0015\u0012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u0012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%\u0012\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'\u0012\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010-J\u000b\u0010v\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010w\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010x\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010y\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010GJ\u0010\u0010z\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010GJ\u001d\u0010{\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0015\u0018\u00010\u0014H\u00c6\u0003J\u000b\u0010|\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010}\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010~\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0015H\u00c6\u0003J\u0012\u0010\u0080\u0001\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0015H\u00c6\u0003J\f\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\f\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u001cH\u00c6\u0003J\f\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\f\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u001fH\u00c6\u0003J\f\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\f\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010GJ\u0011\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010GJ\f\u0010\u0089\u0001\u001a\u0004\u0018\u00010%H\u00c6\u0003J\f\u0010\u008a\u0001\u001a\u0004\u0018\u00010'H\u00c6\u0003J\u0011\u0010\u008b\u0001\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u00101J\f\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u008d\u0001\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u00101J\u0011\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010GJ\u0011\u0010\u008f\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010GJ\f\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0091\u0001\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u00101J\u0011\u0010\u0092\u0001\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u00101J\u0011\u0010\u0093\u0001\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u00101J\u0096\u0003\u0010\u0094\u0001\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u001c\b\u0002\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0015\u0018\u00010\u00142\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00152\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00152\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\fH\u00c6\u0001\u00a2\u0006\u0003\u0010\u0095\u0001J\u0015\u0010\u0096\u0001\u001a\u00020\f2\t\u0010\u0097\u0001\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\n\u0010\u0098\u0001\u001a\u00020\u0003H\u00d6\u0001J\n\u0010\u0099\u0001\u001a\u00020\u0005H\u00d6\u0001J(\u0010\u009a\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u009c\u0001\u001a\u00020\u00002\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u00c7\u0001R \u0010\r\u001a\u0004\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u00102\u0012\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010/\u001a\u0004\b4\u00105R\u001e\u0010$\u001a\u0004\u0018\u00010%8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b6\u0010/\u001a\u0004\b7\u00108R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b9\u0010/\u001a\u0004\b:\u00105R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b;\u0010/\u001a\u0004\b<\u00105R\u001e\u0010!\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b=\u0010/\u001a\u0004\b>\u00105R \u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u00102\u0012\u0004\b?\u0010/\u001a\u0004\b@\u00101R\u001e\u0010 \u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bA\u0010/\u001a\u0004\bB\u00105R\u001e\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bC\u0010/\u001a\u0004\bD\u00105R \u0010\u0012\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010H\u0012\u0004\bE\u0010/\u001a\u0004\bF\u0010GR \u0010\b\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010H\u0012\u0004\bI\u0010/\u001a\u0004\bJ\u0010GR \u0010\t\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010H\u0012\u0004\bK\u0010/\u001a\u0004\bL\u0010GR\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bM\u0010/\u001a\u0004\bN\u00105R\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bO\u0010/\u001a\u0004\bP\u00105R$\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00158\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bQ\u0010/\u001a\u0004\bR\u0010SR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bT\u0010/\u001a\u0004\bU\u00105R$\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00158\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bV\u0010/\u001a\u0004\bW\u0010SR \u0010)\u001a\u0004\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u00102\u0012\u0004\bX\u0010/\u001a\u0004\bY\u00101R \u0010\"\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010H\u0012\u0004\bZ\u0010/\u001a\u0004\b[\u0010GR \u0010#\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010H\u0012\u0004\b\\\u0010/\u001a\u0004\b]\u0010GR \u0010\u0011\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010H\u0012\u0004\b^\u0010/\u001a\u0004\b_\u0010GR \u0010\u000e\u001a\u0004\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u00102\u0012\u0004\b`\u0010/\u001a\u0004\ba\u00101R\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u001f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bb\u0010/\u001a\u0004\bc\u0010dR\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\be\u0010/\u001a\u0004\bf\u00105R0\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0015\u0018\u00010\u00148\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bg\u0010/\u001a\u0004\bh\u0010iR \u0010(\u001a\u0004\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u00102\u0012\u0004\bj\u0010/\u001a\u0004\bk\u00101R\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u001c8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bl\u0010/\u001a\u0004\bm\u0010nR\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bo\u0010/\u001a\u0004\bp\u00105R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bq\u0010/\u001a\u0004\br\u00105R\u001e\u0010&\u001a\u0004\u0018\u00010'8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bs\u0010/\u001a\u0004\bt\u0010u\u00a8\u0006\u00a3\u0001"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$AdUnit;", "", "seen1", "", "id", "", "adType", "adSource", "expiry", "expiryDuration", "deeplinkUrl", "clickCoordinatesEnabled", "", "adLoadOptimizationEnabled", "templateHeartbeatCheck", "mediationName", "info", "sleep", "errorCode", "tpat", "", "", "vmURL", "vmVersion", "adMarketId", "notification", "loadAdUrls", "viewAbility", "Lcom/vungle/ads/internal/model/AdPayload$ViewAbility;", "templateType", "templateSettings", "Lcom/vungle/ads/internal/model/AdPayload$TemplateSettings;", "creativeId", "advAppId", "showClose", "showCloseIncentivized", "adSizeInfo", "Lcom/vungle/ads/internal/model/AdPayload$AdSizeInfo;", "webViewSettings", "Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;", "usePreloading", "partialDownloadEnabled", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lcom/vungle/ads/internal/model/AdPayload$ViewAbility;Ljava/lang/String;Lcom/vungle/ads/internal/model/AdPayload$TemplateSettings;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Lcom/vungle/ads/internal/model/AdPayload$AdSizeInfo;Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;Ljava/lang/Boolean;Ljava/lang/Boolean;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lcom/vungle/ads/internal/model/AdPayload$ViewAbility;Ljava/lang/String;Lcom/vungle/ads/internal/model/AdPayload$TemplateSettings;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Lcom/vungle/ads/internal/model/AdPayload$AdSizeInfo;Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getAdLoadOptimizationEnabled$annotations", "()V", "getAdLoadOptimizationEnabled", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getAdMarketId$annotations", "getAdMarketId", "()Ljava/lang/String;", "getAdSizeInfo$annotations", "getAdSizeInfo", "()Lcom/vungle/ads/internal/model/AdPayload$AdSizeInfo;", "getAdSource$annotations", "getAdSource", "getAdType$annotations", "getAdType", "getAdvAppId$annotations", "getAdvAppId", "getClickCoordinatesEnabled$annotations", "getClickCoordinatesEnabled", "getCreativeId$annotations", "getCreativeId", "getDeeplinkUrl$annotations", "getDeeplinkUrl", "getErrorCode$annotations", "getErrorCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getExpiry$annotations", "getExpiry", "getExpiryDuration$annotations", "getExpiryDuration", "getId$annotations", "getId", "getInfo$annotations", "getInfo", "getLoadAdUrls$annotations", "getLoadAdUrls", "()Ljava/util/List;", "getMediationName$annotations", "getMediationName", "getNotification$annotations", "getNotification", "getPartialDownloadEnabled$annotations", "getPartialDownloadEnabled", "getShowClose$annotations", "getShowClose", "getShowCloseIncentivized$annotations", "getShowCloseIncentivized", "getSleep$annotations", "getSleep", "getTemplateHeartbeatCheck$annotations", "getTemplateHeartbeatCheck", "getTemplateSettings$annotations", "getTemplateSettings", "()Lcom/vungle/ads/internal/model/AdPayload$TemplateSettings;", "getTemplateType$annotations", "getTemplateType", "getTpat$annotations", "getTpat", "()Ljava/util/Map;", "getUsePreloading$annotations", "getUsePreloading", "getViewAbility$annotations", "getViewAbility", "()Lcom/vungle/ads/internal/model/AdPayload$ViewAbility;", "getVmURL$annotations", "getVmURL", "getVmVersion$annotations", "getVmVersion", "getWebViewSettings$annotations", "getWebViewSettings", "()Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component24", "component25", "component26", "component27", "component28", "component29", "component3", "component30", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lcom/vungle/ads/internal/model/AdPayload$ViewAbility;Ljava/lang/String;Lcom/vungle/ads/internal/model/AdPayload$TemplateSettings;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Lcom/vungle/ads/internal/model/AdPayload$AdSizeInfo;Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/vungle/ads/internal/model/AdPayload$AdUnit;", "equals", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "vungle-ads_release"})
    public static final class AdUnit {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String id;
        @Nullable
        private final String adType;
        @Nullable
        private final String adSource;
        @Nullable
        private final Integer expiry;
        @Nullable
        private final Integer expiryDuration;
        @Nullable
        private final String deeplinkUrl;
        @Nullable
        private final Boolean clickCoordinatesEnabled;
        @Nullable
        private final Boolean adLoadOptimizationEnabled;
        @Nullable
        private final Boolean templateHeartbeatCheck;
        @Nullable
        private final String mediationName;
        @Nullable
        private final String info;
        @Nullable
        private final Integer sleep;
        @Nullable
        private final Integer errorCode;
        @Nullable
        private final Map<String, List<String>> tpat;
        @Nullable
        private final String vmURL;
        @Nullable
        private final String vmVersion;
        @Nullable
        private final String adMarketId;
        @Nullable
        private final List<String> notification;
        @Nullable
        private final List<String> loadAdUrls;
        @Nullable
        private final ViewAbility viewAbility;
        @Nullable
        private final String templateType;
        @Nullable
        private final TemplateSettings templateSettings;
        @Nullable
        private final String creativeId;
        @Nullable
        private final String advAppId;
        @Nullable
        private final Integer showClose;
        @Nullable
        private final Integer showCloseIncentivized;
        @Nullable
        private final AdSizeInfo adSizeInfo;
        @Nullable
        private final WebViewSettings webViewSettings;
        @Nullable
        private final Boolean usePreloading;
        @Nullable
        private final Boolean partialDownloadEnabled;

        public AdUnit(@Nullable String id, @Nullable String adType, @Nullable String adSource, @Nullable Integer expiry, @Nullable Integer expiryDuration, @Nullable String deeplinkUrl, @Nullable Boolean clickCoordinatesEnabled, @Nullable Boolean adLoadOptimizationEnabled, @Nullable Boolean templateHeartbeatCheck, @Nullable String mediationName, @Nullable String info, @Nullable Integer sleep, @Nullable Integer errorCode, @Nullable Map<String, ? extends List<String>> tpat, @Nullable String vmURL, @Nullable String vmVersion, @Nullable String adMarketId, @Nullable List<String> notification, @Nullable List<String> loadAdUrls, @Nullable ViewAbility viewAbility, @Nullable String templateType, @Nullable TemplateSettings templateSettings, @Nullable String creativeId, @Nullable String advAppId, @Nullable Integer showClose, @Nullable Integer showCloseIncentivized, @Nullable AdSizeInfo adSizeInfo, @Nullable WebViewSettings webViewSettings, @Nullable Boolean usePreloading, @Nullable Boolean partialDownloadEnabled) {
            this.id = id;
            this.adType = adType;
            this.adSource = adSource;
            this.expiry = expiry;
            this.expiryDuration = expiryDuration;
            this.deeplinkUrl = deeplinkUrl;
            this.clickCoordinatesEnabled = clickCoordinatesEnabled;
            this.adLoadOptimizationEnabled = adLoadOptimizationEnabled;
            this.templateHeartbeatCheck = templateHeartbeatCheck;
            this.mediationName = mediationName;
            this.info = info;
            this.sleep = sleep;
            this.errorCode = errorCode;
            this.tpat = tpat;
            this.vmURL = vmURL;
            this.vmVersion = vmVersion;
            this.adMarketId = adMarketId;
            this.notification = notification;
            this.loadAdUrls = loadAdUrls;
            this.viewAbility = viewAbility;
            this.templateType = templateType;
            this.templateSettings = templateSettings;
            this.creativeId = creativeId;
            this.advAppId = advAppId;
            this.showClose = showClose;
            this.showCloseIncentivized = showCloseIncentivized;
            this.adSizeInfo = adSizeInfo;
            this.webViewSettings = webViewSettings;
            this.usePreloading = usePreloading;
            this.partialDownloadEnabled = partialDownloadEnabled;
        }

        public /* synthetic */ AdUnit(String string, String string2, String string3, Integer n, Integer n2, String string4, Boolean bl, Boolean bl2, Boolean bl3, String string5, String string6, Integer n3, Integer n4, Map map, String string7, String string8, String string9, List list, List list2, ViewAbility viewAbility, String string10, TemplateSettings templateSettings, String string11, String string12, Integer n5, Integer n6, AdSizeInfo adSizeInfo, WebViewSettings webViewSettings, Boolean bl4, Boolean bl5, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 1) != 0) {
                string = null;
            }
            if ((n7 & 2) != 0) {
                string2 = null;
            }
            if ((n7 & 4) != 0) {
                string3 = null;
            }
            if ((n7 & 8) != 0) {
                n = null;
            }
            if ((n7 & 0x10) != 0) {
                n2 = null;
            }
            if ((n7 & 0x20) != 0) {
                string4 = null;
            }
            if ((n7 & 0x40) != 0) {
                bl = null;
            }
            if ((n7 & 0x80) != 0) {
                bl2 = null;
            }
            if ((n7 & 0x100) != 0) {
                bl3 = null;
            }
            if ((n7 & 0x200) != 0) {
                string5 = null;
            }
            if ((n7 & 0x400) != 0) {
                string6 = null;
            }
            if ((n7 & 0x800) != 0) {
                n3 = null;
            }
            if ((n7 & 0x1000) != 0) {
                n4 = null;
            }
            if ((n7 & 0x2000) != 0) {
                map = null;
            }
            if ((n7 & 0x4000) != 0) {
                string7 = null;
            }
            if ((n7 & 0x8000) != 0) {
                string8 = null;
            }
            if ((n7 & 0x10000) != 0) {
                string9 = null;
            }
            if ((n7 & 0x20000) != 0) {
                list = null;
            }
            if ((n7 & 0x40000) != 0) {
                list2 = null;
            }
            if ((n7 & 0x80000) != 0) {
                viewAbility = null;
            }
            if ((n7 & 0x100000) != 0) {
                string10 = null;
            }
            if ((n7 & 0x200000) != 0) {
                templateSettings = null;
            }
            if ((n7 & 0x400000) != 0) {
                string11 = null;
            }
            if ((n7 & 0x800000) != 0) {
                string12 = null;
            }
            if ((n7 & 0x1000000) != 0) {
                n5 = 0;
            }
            if ((n7 & 0x2000000) != 0) {
                n6 = 0;
            }
            if ((n7 & 0x4000000) != 0) {
                adSizeInfo = null;
            }
            if ((n7 & 0x8000000) != 0) {
                webViewSettings = null;
            }
            if ((n7 & 0x10000000) != 0) {
                bl4 = false;
            }
            if ((n7 & 0x20000000) != 0) {
                bl5 = null;
            }
            this(string, string2, string3, n, n2, string4, bl, bl2, bl3, string5, string6, n3, n4, map, string7, string8, string9, list, list2, viewAbility, string10, templateSettings, string11, string12, n5, n6, adSizeInfo, webViewSettings, bl4, bl5);
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @SerialName(value="id")
        public static /* synthetic */ void getId$annotations() {
        }

        @Nullable
        public final String getAdType() {
            return this.adType;
        }

        @SerialName(value="ad_type")
        public static /* synthetic */ void getAdType$annotations() {
        }

        @Nullable
        public final String getAdSource() {
            return this.adSource;
        }

        @SerialName(value="ad_source")
        public static /* synthetic */ void getAdSource$annotations() {
        }

        @Nullable
        public final Integer getExpiry() {
            return this.expiry;
        }

        @SerialName(value="expiry")
        public static /* synthetic */ void getExpiry$annotations() {
        }

        @Nullable
        public final Integer getExpiryDuration() {
            return this.expiryDuration;
        }

        @SerialName(value="expiry_duration")
        public static /* synthetic */ void getExpiryDuration$annotations() {
        }

        @Nullable
        public final String getDeeplinkUrl() {
            return this.deeplinkUrl;
        }

        @SerialName(value="deeplink_url")
        public static /* synthetic */ void getDeeplinkUrl$annotations() {
        }

        @Nullable
        public final Boolean getClickCoordinatesEnabled() {
            return this.clickCoordinatesEnabled;
        }

        @SerialName(value="click_coordinates_enabled")
        public static /* synthetic */ void getClickCoordinatesEnabled$annotations() {
        }

        @Nullable
        public final Boolean getAdLoadOptimizationEnabled() {
            return this.adLoadOptimizationEnabled;
        }

        @SerialName(value="ad_load_optimization")
        public static /* synthetic */ void getAdLoadOptimizationEnabled$annotations() {
        }

        @Nullable
        public final Boolean getTemplateHeartbeatCheck() {
            return this.templateHeartbeatCheck;
        }

        @SerialName(value="template_heartbeat_check")
        public static /* synthetic */ void getTemplateHeartbeatCheck$annotations() {
        }

        @Nullable
        public final String getMediationName() {
            return this.mediationName;
        }

        @SerialName(value="mediation_name")
        public static /* synthetic */ void getMediationName$annotations() {
        }

        @Nullable
        public final String getInfo() {
            return this.info;
        }

        @SerialName(value="info")
        public static /* synthetic */ void getInfo$annotations() {
        }

        @Nullable
        public final Integer getSleep() {
            return this.sleep;
        }

        @SerialName(value="sleep")
        public static /* synthetic */ void getSleep$annotations() {
        }

        @Nullable
        public final Integer getErrorCode() {
            return this.errorCode;
        }

        @SerialName(value="error_code")
        public static /* synthetic */ void getErrorCode$annotations() {
        }

        @Nullable
        public final Map<String, List<String>> getTpat() {
            return this.tpat;
        }

        @Serializable(with=TpatSerializer.class)
        public static /* synthetic */ void getTpat$annotations() {
        }

        @Nullable
        public final String getVmURL() {
            return this.vmURL;
        }

        @SerialName(value="vm_url")
        public static /* synthetic */ void getVmURL$annotations() {
        }

        @Nullable
        public final String getVmVersion() {
            return this.vmVersion;
        }

        @SerialName(value="vm_version")
        public static /* synthetic */ void getVmVersion$annotations() {
        }

        @Nullable
        public final String getAdMarketId() {
            return this.adMarketId;
        }

        @SerialName(value="ad_market_id")
        public static /* synthetic */ void getAdMarketId$annotations() {
        }

        @Nullable
        public final List<String> getNotification() {
            return this.notification;
        }

        @SerialName(value="notification")
        public static /* synthetic */ void getNotification$annotations() {
        }

        @Nullable
        public final List<String> getLoadAdUrls() {
            return this.loadAdUrls;
        }

        @SerialName(value="load_ad")
        public static /* synthetic */ void getLoadAdUrls$annotations() {
        }

        @Nullable
        public final ViewAbility getViewAbility() {
            return this.viewAbility;
        }

        @SerialName(value="viewability")
        public static /* synthetic */ void getViewAbility$annotations() {
        }

        @Nullable
        public final String getTemplateType() {
            return this.templateType;
        }

        @SerialName(value="template_type")
        public static /* synthetic */ void getTemplateType$annotations() {
        }

        @Nullable
        public final TemplateSettings getTemplateSettings() {
            return this.templateSettings;
        }

        @SerialName(value="template_settings")
        public static /* synthetic */ void getTemplateSettings$annotations() {
        }

        @Nullable
        public final String getCreativeId() {
            return this.creativeId;
        }

        @SerialName(value="creative_id")
        public static /* synthetic */ void getCreativeId$annotations() {
        }

        @Nullable
        public final String getAdvAppId() {
            return this.advAppId;
        }

        @SerialName(value="app_id")
        public static /* synthetic */ void getAdvAppId$annotations() {
        }

        @Nullable
        public final Integer getShowClose() {
            return this.showClose;
        }

        @SerialName(value="show_close")
        public static /* synthetic */ void getShowClose$annotations() {
        }

        @Nullable
        public final Integer getShowCloseIncentivized() {
            return this.showCloseIncentivized;
        }

        @SerialName(value="show_close_incentivized")
        public static /* synthetic */ void getShowCloseIncentivized$annotations() {
        }

        @Nullable
        public final AdSizeInfo getAdSizeInfo() {
            return this.adSizeInfo;
        }

        @SerialName(value="ad_size")
        public static /* synthetic */ void getAdSizeInfo$annotations() {
        }

        @Nullable
        public final WebViewSettings getWebViewSettings() {
            return this.webViewSettings;
        }

        @SerialName(value="webview_settings")
        public static /* synthetic */ void getWebViewSettings$annotations() {
        }

        @Nullable
        public final Boolean getUsePreloading() {
            return this.usePreloading;
        }

        @SerialName(value="use_preloading")
        public static /* synthetic */ void getUsePreloading$annotations() {
        }

        @Nullable
        public final Boolean getPartialDownloadEnabled() {
            return this.partialDownloadEnabled;
        }

        @SerialName(value="ad_partial_download_enabled")
        public static /* synthetic */ void getPartialDownloadEnabled$annotations() {
        }

        @Nullable
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.adType;
        }

        @Nullable
        public final String component3() {
            return this.adSource;
        }

        @Nullable
        public final Integer component4() {
            return this.expiry;
        }

        @Nullable
        public final Integer component5() {
            return this.expiryDuration;
        }

        @Nullable
        public final String component6() {
            return this.deeplinkUrl;
        }

        @Nullable
        public final Boolean component7() {
            return this.clickCoordinatesEnabled;
        }

        @Nullable
        public final Boolean component8() {
            return this.adLoadOptimizationEnabled;
        }

        @Nullable
        public final Boolean component9() {
            return this.templateHeartbeatCheck;
        }

        @Nullable
        public final String component10() {
            return this.mediationName;
        }

        @Nullable
        public final String component11() {
            return this.info;
        }

        @Nullable
        public final Integer component12() {
            return this.sleep;
        }

        @Nullable
        public final Integer component13() {
            return this.errorCode;
        }

        @Nullable
        public final Map<String, List<String>> component14() {
            return this.tpat;
        }

        @Nullable
        public final String component15() {
            return this.vmURL;
        }

        @Nullable
        public final String component16() {
            return this.vmVersion;
        }

        @Nullable
        public final String component17() {
            return this.adMarketId;
        }

        @Nullable
        public final List<String> component18() {
            return this.notification;
        }

        @Nullable
        public final List<String> component19() {
            return this.loadAdUrls;
        }

        @Nullable
        public final ViewAbility component20() {
            return this.viewAbility;
        }

        @Nullable
        public final String component21() {
            return this.templateType;
        }

        @Nullable
        public final TemplateSettings component22() {
            return this.templateSettings;
        }

        @Nullable
        public final String component23() {
            return this.creativeId;
        }

        @Nullable
        public final String component24() {
            return this.advAppId;
        }

        @Nullable
        public final Integer component25() {
            return this.showClose;
        }

        @Nullable
        public final Integer component26() {
            return this.showCloseIncentivized;
        }

        @Nullable
        public final AdSizeInfo component27() {
            return this.adSizeInfo;
        }

        @Nullable
        public final WebViewSettings component28() {
            return this.webViewSettings;
        }

        @Nullable
        public final Boolean component29() {
            return this.usePreloading;
        }

        @Nullable
        public final Boolean component30() {
            return this.partialDownloadEnabled;
        }

        @NotNull
        public final AdUnit copy(@Nullable String id, @Nullable String adType, @Nullable String adSource, @Nullable Integer expiry, @Nullable Integer expiryDuration, @Nullable String deeplinkUrl, @Nullable Boolean clickCoordinatesEnabled, @Nullable Boolean adLoadOptimizationEnabled, @Nullable Boolean templateHeartbeatCheck, @Nullable String mediationName, @Nullable String info, @Nullable Integer sleep, @Nullable Integer errorCode, @Nullable Map<String, ? extends List<String>> tpat, @Nullable String vmURL, @Nullable String vmVersion, @Nullable String adMarketId, @Nullable List<String> notification, @Nullable List<String> loadAdUrls, @Nullable ViewAbility viewAbility, @Nullable String templateType, @Nullable TemplateSettings templateSettings, @Nullable String creativeId, @Nullable String advAppId, @Nullable Integer showClose, @Nullable Integer showCloseIncentivized, @Nullable AdSizeInfo adSizeInfo, @Nullable WebViewSettings webViewSettings, @Nullable Boolean usePreloading, @Nullable Boolean partialDownloadEnabled) {
            return new AdUnit(id, adType, adSource, expiry, expiryDuration, deeplinkUrl, clickCoordinatesEnabled, adLoadOptimizationEnabled, templateHeartbeatCheck, mediationName, info, sleep, errorCode, tpat, vmURL, vmVersion, adMarketId, notification, loadAdUrls, viewAbility, templateType, templateSettings, creativeId, advAppId, showClose, showCloseIncentivized, adSizeInfo, webViewSettings, usePreloading, partialDownloadEnabled);
        }

        public static /* synthetic */ AdUnit copy$default(AdUnit adUnit, String string, String string2, String string3, Integer n, Integer n2, String string4, Boolean bl, Boolean bl2, Boolean bl3, String string5, String string6, Integer n3, Integer n4, Map map, String string7, String string8, String string9, List list, List list2, ViewAbility viewAbility, String string10, TemplateSettings templateSettings, String string11, String string12, Integer n5, Integer n6, AdSizeInfo adSizeInfo, WebViewSettings webViewSettings, Boolean bl4, Boolean bl5, int n7, Object object) {
            if ((n7 & 1) != 0) {
                string = adUnit.id;
            }
            if ((n7 & 2) != 0) {
                string2 = adUnit.adType;
            }
            if ((n7 & 4) != 0) {
                string3 = adUnit.adSource;
            }
            if ((n7 & 8) != 0) {
                n = adUnit.expiry;
            }
            if ((n7 & 0x10) != 0) {
                n2 = adUnit.expiryDuration;
            }
            if ((n7 & 0x20) != 0) {
                string4 = adUnit.deeplinkUrl;
            }
            if ((n7 & 0x40) != 0) {
                bl = adUnit.clickCoordinatesEnabled;
            }
            if ((n7 & 0x80) != 0) {
                bl2 = adUnit.adLoadOptimizationEnabled;
            }
            if ((n7 & 0x100) != 0) {
                bl3 = adUnit.templateHeartbeatCheck;
            }
            if ((n7 & 0x200) != 0) {
                string5 = adUnit.mediationName;
            }
            if ((n7 & 0x400) != 0) {
                string6 = adUnit.info;
            }
            if ((n7 & 0x800) != 0) {
                n3 = adUnit.sleep;
            }
            if ((n7 & 0x1000) != 0) {
                n4 = adUnit.errorCode;
            }
            if ((n7 & 0x2000) != 0) {
                map = adUnit.tpat;
            }
            if ((n7 & 0x4000) != 0) {
                string7 = adUnit.vmURL;
            }
            if ((n7 & 0x8000) != 0) {
                string8 = adUnit.vmVersion;
            }
            if ((n7 & 0x10000) != 0) {
                string9 = adUnit.adMarketId;
            }
            if ((n7 & 0x20000) != 0) {
                list = adUnit.notification;
            }
            if ((n7 & 0x40000) != 0) {
                list2 = adUnit.loadAdUrls;
            }
            if ((n7 & 0x80000) != 0) {
                viewAbility = adUnit.viewAbility;
            }
            if ((n7 & 0x100000) != 0) {
                string10 = adUnit.templateType;
            }
            if ((n7 & 0x200000) != 0) {
                templateSettings = adUnit.templateSettings;
            }
            if ((n7 & 0x400000) != 0) {
                string11 = adUnit.creativeId;
            }
            if ((n7 & 0x800000) != 0) {
                string12 = adUnit.advAppId;
            }
            if ((n7 & 0x1000000) != 0) {
                n5 = adUnit.showClose;
            }
            if ((n7 & 0x2000000) != 0) {
                n6 = adUnit.showCloseIncentivized;
            }
            if ((n7 & 0x4000000) != 0) {
                adSizeInfo = adUnit.adSizeInfo;
            }
            if ((n7 & 0x8000000) != 0) {
                webViewSettings = adUnit.webViewSettings;
            }
            if ((n7 & 0x10000000) != 0) {
                bl4 = adUnit.usePreloading;
            }
            if ((n7 & 0x20000000) != 0) {
                bl5 = adUnit.partialDownloadEnabled;
            }
            return adUnit.copy(string, string2, string3, n, n2, string4, bl, bl2, bl3, string5, string6, n3, n4, map, string7, string8, string9, list, list2, viewAbility, string10, templateSettings, string11, string12, n5, n6, adSizeInfo, webViewSettings, bl4, bl5);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("AdUnit(id=").append(this.id).append(", adType=").append(this.adType).append(", adSource=").append(this.adSource).append(", expiry=").append(this.expiry).append(", expiryDuration=").append(this.expiryDuration).append(", deeplinkUrl=").append(this.deeplinkUrl).append(", clickCoordinatesEnabled=").append(this.clickCoordinatesEnabled).append(", adLoadOptimizationEnabled=").append(this.adLoadOptimizationEnabled).append(", templateHeartbeatCheck=").append(this.templateHeartbeatCheck).append(", mediationName=").append(this.mediationName).append(", info=").append(this.info).append(", sleep=");
            stringBuilder.append(this.sleep).append(", errorCode=").append(this.errorCode).append(", tpat=").append(this.tpat).append(", vmURL=").append(this.vmURL).append(", vmVersion=").append(this.vmVersion).append(", adMarketId=").append(this.adMarketId).append(", notification=").append(this.notification).append(", loadAdUrls=").append(this.loadAdUrls).append(", viewAbility=").append(this.viewAbility).append(", templateType=").append(this.templateType).append(", templateSettings=").append(this.templateSettings).append(", creativeId=").append(this.creativeId);
            stringBuilder.append(", advAppId=").append(this.advAppId).append(", showClose=").append(this.showClose).append(", showCloseIncentivized=").append(this.showCloseIncentivized).append(", adSizeInfo=").append(this.adSizeInfo).append(", webViewSettings=").append(this.webViewSettings).append(", usePreloading=").append(this.usePreloading).append(", partialDownloadEnabled=").append(this.partialDownloadEnabled).append(')');
            return stringBuilder.toString();
        }

        public int hashCode() {
            int result = this.id == null ? 0 : this.id.hashCode();
            result = result * 31 + (this.adType == null ? 0 : this.adType.hashCode());
            result = result * 31 + (this.adSource == null ? 0 : this.adSource.hashCode());
            result = result * 31 + (this.expiry == null ? 0 : ((Object)this.expiry).hashCode());
            result = result * 31 + (this.expiryDuration == null ? 0 : ((Object)this.expiryDuration).hashCode());
            result = result * 31 + (this.deeplinkUrl == null ? 0 : this.deeplinkUrl.hashCode());
            result = result * 31 + (this.clickCoordinatesEnabled == null ? 0 : ((Object)this.clickCoordinatesEnabled).hashCode());
            result = result * 31 + (this.adLoadOptimizationEnabled == null ? 0 : ((Object)this.adLoadOptimizationEnabled).hashCode());
            result = result * 31 + (this.templateHeartbeatCheck == null ? 0 : ((Object)this.templateHeartbeatCheck).hashCode());
            result = result * 31 + (this.mediationName == null ? 0 : this.mediationName.hashCode());
            result = result * 31 + (this.info == null ? 0 : this.info.hashCode());
            result = result * 31 + (this.sleep == null ? 0 : ((Object)this.sleep).hashCode());
            result = result * 31 + (this.errorCode == null ? 0 : ((Object)this.errorCode).hashCode());
            result = result * 31 + (this.tpat == null ? 0 : ((Object)this.tpat).hashCode());
            result = result * 31 + (this.vmURL == null ? 0 : this.vmURL.hashCode());
            result = result * 31 + (this.vmVersion == null ? 0 : this.vmVersion.hashCode());
            result = result * 31 + (this.adMarketId == null ? 0 : this.adMarketId.hashCode());
            result = result * 31 + (this.notification == null ? 0 : ((Object)this.notification).hashCode());
            result = result * 31 + (this.loadAdUrls == null ? 0 : ((Object)this.loadAdUrls).hashCode());
            result = result * 31 + (this.viewAbility == null ? 0 : this.viewAbility.hashCode());
            result = result * 31 + (this.templateType == null ? 0 : this.templateType.hashCode());
            result = result * 31 + (this.templateSettings == null ? 0 : this.templateSettings.hashCode());
            result = result * 31 + (this.creativeId == null ? 0 : this.creativeId.hashCode());
            result = result * 31 + (this.advAppId == null ? 0 : this.advAppId.hashCode());
            result = result * 31 + (this.showClose == null ? 0 : ((Object)this.showClose).hashCode());
            result = result * 31 + (this.showCloseIncentivized == null ? 0 : ((Object)this.showCloseIncentivized).hashCode());
            result = result * 31 + (this.adSizeInfo == null ? 0 : this.adSizeInfo.hashCode());
            result = result * 31 + (this.webViewSettings == null ? 0 : this.webViewSettings.hashCode());
            result = result * 31 + (this.usePreloading == null ? 0 : ((Object)this.usePreloading).hashCode());
            result = result * 31 + (this.partialDownloadEnabled == null ? 0 : ((Object)this.partialDownloadEnabled).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdUnit)) {
                return false;
            }
            AdUnit adUnit = (AdUnit)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)adUnit.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.adType, (Object)adUnit.adType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.adSource, (Object)adUnit.adSource)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expiry, (Object)adUnit.expiry)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expiryDuration, (Object)adUnit.expiryDuration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.deeplinkUrl, (Object)adUnit.deeplinkUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clickCoordinatesEnabled, (Object)adUnit.clickCoordinatesEnabled)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.adLoadOptimizationEnabled, (Object)adUnit.adLoadOptimizationEnabled)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.templateHeartbeatCheck, (Object)adUnit.templateHeartbeatCheck)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mediationName, (Object)adUnit.mediationName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.info, (Object)adUnit.info)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sleep, (Object)adUnit.sleep)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.errorCode, (Object)adUnit.errorCode)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tpat, adUnit.tpat)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.vmURL, (Object)adUnit.vmURL)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.vmVersion, (Object)adUnit.vmVersion)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.adMarketId, (Object)adUnit.adMarketId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.notification, adUnit.notification)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.loadAdUrls, adUnit.loadAdUrls)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.viewAbility, (Object)adUnit.viewAbility)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.templateType, (Object)adUnit.templateType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.templateSettings, (Object)adUnit.templateSettings)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.creativeId, (Object)adUnit.creativeId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.advAppId, (Object)adUnit.advAppId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.showClose, (Object)adUnit.showClose)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.showCloseIncentivized, (Object)adUnit.showCloseIncentivized)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.adSizeInfo, (Object)adUnit.adSizeInfo)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.webViewSettings, (Object)adUnit.webViewSettings)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.usePreloading, (Object)adUnit.usePreloading)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.partialDownloadEnabled, (Object)adUnit.partialDownloadEnabled);
        }

        @JvmStatic
        public static final void write$Self(@NotNull AdUnit self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.id != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.id);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.adType != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.adType);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.adSource != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.adSource);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.expiry != null) {
                output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.expiry);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.expiryDuration != null) {
                output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.expiryDuration);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.deeplinkUrl != null) {
                output.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.deeplinkUrl);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : self.clickCoordinatesEnabled != null) {
                output.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.clickCoordinatesEnabled);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : self.adLoadOptimizationEnabled != null) {
                output.encodeNullableSerializableElement(serialDesc, 7, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.adLoadOptimizationEnabled);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 8) ? true : self.templateHeartbeatCheck != null) {
                output.encodeNullableSerializableElement(serialDesc, 8, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.templateHeartbeatCheck);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 9) ? true : self.mediationName != null) {
                output.encodeNullableSerializableElement(serialDesc, 9, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.mediationName);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 10) ? true : self.info != null) {
                output.encodeNullableSerializableElement(serialDesc, 10, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.info);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 11) ? true : self.sleep != null) {
                output.encodeNullableSerializableElement(serialDesc, 11, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.sleep);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 12) ? true : self.errorCode != null) {
                output.encodeNullableSerializableElement(serialDesc, 12, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.errorCode);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 13) ? true : self.tpat != null) {
                output.encodeNullableSerializableElement(serialDesc, 13, (SerializationStrategy)TpatSerializer.INSTANCE, self.tpat);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 14) ? true : self.vmURL != null) {
                output.encodeNullableSerializableElement(serialDesc, 14, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.vmURL);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 15) ? true : self.vmVersion != null) {
                output.encodeNullableSerializableElement(serialDesc, 15, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.vmVersion);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 16) ? true : self.adMarketId != null) {
                output.encodeNullableSerializableElement(serialDesc, 16, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.adMarketId);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 17) ? true : self.notification != null) {
                output.encodeNullableSerializableElement(serialDesc, 17, (SerializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), self.notification);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 18) ? true : self.loadAdUrls != null) {
                output.encodeNullableSerializableElement(serialDesc, 18, (SerializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), self.loadAdUrls);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 19) ? true : self.viewAbility != null) {
                output.encodeNullableSerializableElement(serialDesc, 19, (SerializationStrategy)ViewAbility$$serializer.INSTANCE, (Object)self.viewAbility);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 20) ? true : self.templateType != null) {
                output.encodeNullableSerializableElement(serialDesc, 20, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.templateType);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 21) ? true : self.templateSettings != null) {
                output.encodeNullableSerializableElement(serialDesc, 21, (SerializationStrategy)TemplateSettings$$serializer.INSTANCE, (Object)self.templateSettings);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 22) ? true : self.creativeId != null) {
                output.encodeNullableSerializableElement(serialDesc, 22, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.creativeId);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 23) ? true : self.advAppId != null) {
                output.encodeNullableSerializableElement(serialDesc, 23, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.advAppId);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 24)) {
                bl2 = true;
            } else {
                Integer n = self.showClose;
                bl2 = n == null || n != 0;
            }
            if (bl2) {
                output.encodeNullableSerializableElement(serialDesc, 24, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.showClose);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 25)) {
                bl = true;
            } else {
                Integer n = self.showCloseIncentivized;
                bl = n == null || n != 0;
            }
            if (bl) {
                output.encodeNullableSerializableElement(serialDesc, 25, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.showCloseIncentivized);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 26) ? true : self.adSizeInfo != null) {
                output.encodeNullableSerializableElement(serialDesc, 26, (SerializationStrategy)AdSizeInfo$$serializer.INSTANCE, (Object)self.adSizeInfo);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 27) ? true : self.webViewSettings != null) {
                output.encodeNullableSerializableElement(serialDesc, 27, (SerializationStrategy)WebViewSettings$$serializer.INSTANCE, (Object)self.webViewSettings);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 28) ? true : !Intrinsics.areEqual((Object)self.usePreloading, (Object)false)) {
                output.encodeNullableSerializableElement(serialDesc, 28, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.usePreloading);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 29) ? true : self.partialDownloadEnabled != null) {
                output.encodeNullableSerializableElement(serialDesc, 29, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.partialDownloadEnabled);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ AdUnit(int seen1, @SerialName(value="id") String id, @SerialName(value="ad_type") String adType, @SerialName(value="ad_source") String adSource, @SerialName(value="expiry") Integer expiry, @SerialName(value="expiry_duration") Integer expiryDuration, @SerialName(value="deeplink_url") String deeplinkUrl, @SerialName(value="click_coordinates_enabled") Boolean clickCoordinatesEnabled, @SerialName(value="ad_load_optimization") Boolean adLoadOptimizationEnabled, @SerialName(value="template_heartbeat_check") Boolean templateHeartbeatCheck, @SerialName(value="mediation_name") String mediationName, @SerialName(value="info") String info, @SerialName(value="sleep") Integer sleep, @SerialName(value="error_code") Integer errorCode, @Serializable(with=TpatSerializer.class) Map tpat, @SerialName(value="vm_url") String vmURL, @SerialName(value="vm_version") String vmVersion, @SerialName(value="ad_market_id") String adMarketId, @SerialName(value="notification") List notification, @SerialName(value="load_ad") List loadAdUrls, @SerialName(value="viewability") ViewAbility viewAbility, @SerialName(value="template_type") String templateType, @SerialName(value="template_settings") TemplateSettings templateSettings, @SerialName(value="creative_id") String creativeId, @SerialName(value="app_id") String advAppId, @SerialName(value="show_close") Integer showClose, @SerialName(value="show_close_incentivized") Integer showCloseIncentivized, @SerialName(value="ad_size") AdSizeInfo adSizeInfo, @SerialName(value="webview_settings") WebViewSettings webViewSettings, @SerialName(value="use_preloading") Boolean usePreloading, @SerialName(value="ad_partial_download_enabled") Boolean partialDownloadEnabled, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen1) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)AdUnit$$serializer.INSTANCE.getDescriptor());
            }
            this.id = (seen1 & 1) == 0 ? null : id;
            this.adType = (seen1 & 2) == 0 ? null : adType;
            this.adSource = (seen1 & 4) == 0 ? null : adSource;
            this.expiry = (seen1 & 8) == 0 ? null : expiry;
            this.expiryDuration = (seen1 & 0x10) == 0 ? null : expiryDuration;
            this.deeplinkUrl = (seen1 & 0x20) == 0 ? null : deeplinkUrl;
            this.clickCoordinatesEnabled = (seen1 & 0x40) == 0 ? null : clickCoordinatesEnabled;
            this.adLoadOptimizationEnabled = (seen1 & 0x80) == 0 ? null : adLoadOptimizationEnabled;
            this.templateHeartbeatCheck = (seen1 & 0x100) == 0 ? null : templateHeartbeatCheck;
            this.mediationName = (seen1 & 0x200) == 0 ? null : mediationName;
            this.info = (seen1 & 0x400) == 0 ? null : info;
            this.sleep = (seen1 & 0x800) == 0 ? null : sleep;
            this.errorCode = (seen1 & 0x1000) == 0 ? null : errorCode;
            this.tpat = (seen1 & 0x2000) == 0 ? null : tpat;
            this.vmURL = (seen1 & 0x4000) == 0 ? null : vmURL;
            this.vmVersion = (seen1 & 0x8000) == 0 ? null : vmVersion;
            this.adMarketId = (seen1 & 0x10000) == 0 ? null : adMarketId;
            this.notification = (seen1 & 0x20000) == 0 ? null : notification;
            this.loadAdUrls = (seen1 & 0x40000) == 0 ? null : loadAdUrls;
            this.viewAbility = (seen1 & 0x80000) == 0 ? null : viewAbility;
            this.templateType = (seen1 & 0x100000) == 0 ? null : templateType;
            this.templateSettings = (seen1 & 0x200000) == 0 ? null : templateSettings;
            this.creativeId = (seen1 & 0x400000) == 0 ? null : creativeId;
            this.advAppId = (seen1 & 0x800000) == 0 ? null : advAppId;
            this.showClose = (seen1 & 0x1000000) == 0 ? Integer.valueOf(0) : showClose;
            this.showCloseIncentivized = (seen1 & 0x2000000) == 0 ? Integer.valueOf(0) : showCloseIncentivized;
            this.adSizeInfo = (seen1 & 0x4000000) == 0 ? null : adSizeInfo;
            this.webViewSettings = (seen1 & 0x8000000) == 0 ? null : webViewSettings;
            this.usePreloading = (seen1 & 0x10000000) == 0 ? Boolean.valueOf(false) : usePreloading;
            this.partialDownloadEnabled = (seen1 & 0x20000000) == 0 ? null : partialDownloadEnabled;
        }

        public AdUnit() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFFFF, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$AdUnit$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/vungle/ads/internal/model/AdPayload$AdUnit;", "vungle-ads_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<AdUnit> serializer() {
                return (KSerializer)AdUnit$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00040\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0014\u00a8\u0006\t"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$TpatSerializer;", "Lkotlinx/serialization/json/JsonTransformingSerializer;", "", "", "", "()V", "transformDeserialize", "Lkotlinx/serialization/json/JsonElement;", "element", "vungle-ads_release"})
    public static final class TpatSerializer
    extends JsonTransformingSerializer<Map<String, ? extends List<? extends String>>> {
        @NotNull
        public static final TpatSerializer INSTANCE = new TpatSerializer();

        private TpatSerializer() {
            super(BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)BuiltinSerializersKt.ListSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE))));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected JsonElement transformDeserialize(@NotNull JsonElement element) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Map $this$filterNot$iv = (Map)JsonElementKt.getJsonObject((JsonElement)element);
            boolean $i$f$filterNot = false;
            Map map = $this$filterNot$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterNotTo = false;
            Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                String k = (String)entry.getKey();
                if (Intrinsics.areEqual((Object)k, (Object)"moat")) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map map2 = destination$iv$iv;
            return (JsonElement)new JsonObject(map2);
        }
    }

    @Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#BI\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0001\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0016\b\u0001\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB5\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0017\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005H\u00c6\u0003J9\u0010\u0015\u001a\u00020\u00002\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u00c7\u0001R*\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R*\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$TemplateSettings;", "", "seen1", "", "normalReplacements", "", "", "cacheableReplacements", "Lcom/vungle/ads/internal/model/AdPayload$CacheableReplacement;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/Map;Ljava/util/Map;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/util/Map;Ljava/util/Map;)V", "getCacheableReplacements$annotations", "()V", "getCacheableReplacements", "()Ljava/util/Map;", "getNormalReplacements$annotations", "getNormalReplacements", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "vungle-ads_release"})
    public static final class TemplateSettings {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Map<String, String> normalReplacements;
        @Nullable
        private final Map<String, CacheableReplacement> cacheableReplacements;

        public TemplateSettings(@Nullable Map<String, String> normalReplacements, @Nullable Map<String, CacheableReplacement> cacheableReplacements) {
            this.normalReplacements = normalReplacements;
            this.cacheableReplacements = cacheableReplacements;
        }

        public /* synthetic */ TemplateSettings(Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = null;
            }
            if ((n & 2) != 0) {
                map2 = null;
            }
            this(map, map2);
        }

        @Nullable
        public final Map<String, String> getNormalReplacements() {
            return this.normalReplacements;
        }

        @SerialName(value="normal_replacements")
        public static /* synthetic */ void getNormalReplacements$annotations() {
        }

        @Nullable
        public final Map<String, CacheableReplacement> getCacheableReplacements() {
            return this.cacheableReplacements;
        }

        @SerialName(value="cacheable_replacements")
        public static /* synthetic */ void getCacheableReplacements$annotations() {
        }

        @Nullable
        public final Map<String, String> component1() {
            return this.normalReplacements;
        }

        @Nullable
        public final Map<String, CacheableReplacement> component2() {
            return this.cacheableReplacements;
        }

        @NotNull
        public final TemplateSettings copy(@Nullable Map<String, String> normalReplacements, @Nullable Map<String, CacheableReplacement> cacheableReplacements) {
            return new TemplateSettings(normalReplacements, cacheableReplacements);
        }

        public static /* synthetic */ TemplateSettings copy$default(TemplateSettings templateSettings, Map map, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map = templateSettings.normalReplacements;
            }
            if ((n & 2) != 0) {
                map2 = templateSettings.cacheableReplacements;
            }
            return templateSettings.copy(map, map2);
        }

        @NotNull
        public String toString() {
            return "TemplateSettings(normalReplacements=" + this.normalReplacements + ", cacheableReplacements=" + this.cacheableReplacements + ')';
        }

        public int hashCode() {
            int result = this.normalReplacements == null ? 0 : ((Object)this.normalReplacements).hashCode();
            result = result * 31 + (this.cacheableReplacements == null ? 0 : ((Object)this.cacheableReplacements).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TemplateSettings)) {
                return false;
            }
            TemplateSettings templateSettings = (TemplateSettings)other;
            if (!Intrinsics.areEqual(this.normalReplacements, templateSettings.normalReplacements)) {
                return false;
            }
            return Intrinsics.areEqual(this.cacheableReplacements, templateSettings.cacheableReplacements);
        }

        @JvmStatic
        public static final void write$Self(@NotNull TemplateSettings self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.normalReplacements != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), self.normalReplacements);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.cacheableReplacements != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)CacheableReplacement$$serializer.INSTANCE), self.cacheableReplacements);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ TemplateSettings(int seen1, @SerialName(value="normal_replacements") Map normalReplacements, @SerialName(value="cacheable_replacements") Map cacheableReplacements, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen1) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)TemplateSettings$$serializer.INSTANCE.getDescriptor());
            }
            this.normalReplacements = (seen1 & 1) == 0 ? null : normalReplacements;
            this.cacheableReplacements = (seen1 & 2) == 0 ? null : cacheableReplacements;
        }

        public TemplateSettings() {
            this(null, null, 3, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$TemplateSettings$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/vungle/ads/internal/model/AdPayload$TemplateSettings;", "vungle-ads_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<TemplateSettings> serializer() {
                return (KSerializer)TemplateSettings$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0002%&B9\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB)\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ2\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J!\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u00c7\u0001R \u0010\u0007\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u0010\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006'"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$CacheableReplacement;", "", "seen1", "", "url", "", "extension", "downloadPercent", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "getDownloadPercent$annotations", "()V", "getDownloadPercent", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getExtension", "()Ljava/lang/String;", "getUrl", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lcom/vungle/ads/internal/model/AdPayload$CacheableReplacement;", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "vungle-ads_release"})
    public static final class CacheableReplacement {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String url;
        @Nullable
        private final String extension;
        @Nullable
        private final Integer downloadPercent;

        public CacheableReplacement(@Nullable String url, @Nullable String extension, @Nullable Integer downloadPercent) {
            this.url = url;
            this.extension = extension;
            this.downloadPercent = downloadPercent;
        }

        public /* synthetic */ CacheableReplacement(String string, String string2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            if ((n2 & 4) != 0) {
                n = null;
            }
            this(string, string2, n);
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final String getExtension() {
            return this.extension;
        }

        @Nullable
        public final Integer getDownloadPercent() {
            return this.downloadPercent;
        }

        @SerialName(value="download_percent")
        public static /* synthetic */ void getDownloadPercent$annotations() {
        }

        @Nullable
        public final String component1() {
            return this.url;
        }

        @Nullable
        public final String component2() {
            return this.extension;
        }

        @Nullable
        public final Integer component3() {
            return this.downloadPercent;
        }

        @NotNull
        public final CacheableReplacement copy(@Nullable String url, @Nullable String extension, @Nullable Integer downloadPercent) {
            return new CacheableReplacement(url, extension, downloadPercent);
        }

        public static /* synthetic */ CacheableReplacement copy$default(CacheableReplacement cacheableReplacement, String string, String string2, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = cacheableReplacement.url;
            }
            if ((n2 & 2) != 0) {
                string2 = cacheableReplacement.extension;
            }
            if ((n2 & 4) != 0) {
                n = cacheableReplacement.downloadPercent;
            }
            return cacheableReplacement.copy(string, string2, n);
        }

        @NotNull
        public String toString() {
            return "CacheableReplacement(url=" + this.url + ", extension=" + this.extension + ", downloadPercent=" + this.downloadPercent + ')';
        }

        public int hashCode() {
            int result = this.url == null ? 0 : this.url.hashCode();
            result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
            result = result * 31 + (this.downloadPercent == null ? 0 : ((Object)this.downloadPercent).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheableReplacement)) {
                return false;
            }
            CacheableReplacement cacheableReplacement = (CacheableReplacement)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)cacheableReplacement.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.extension, (Object)cacheableReplacement.extension)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.downloadPercent, (Object)cacheableReplacement.downloadPercent);
        }

        @JvmStatic
        public static final void write$Self(@NotNull CacheableReplacement self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.url != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.url);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.extension != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.extension);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.downloadPercent != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.downloadPercent);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ CacheableReplacement(int seen1, String url, String extension, @SerialName(value="download_percent") Integer downloadPercent, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen1) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)CacheableReplacement$$serializer.INSTANCE.getDescriptor());
            }
            this.url = (seen1 & 1) == 0 ? null : url;
            this.extension = (seen1 & 2) == 0 ? null : extension;
            this.downloadPercent = (seen1 & 4) == 0 ? null : downloadPercent;
        }

        public CacheableReplacement() {
            this(null, null, null, 7, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$CacheableReplacement$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/vungle/ads/internal/model/AdPayload$CacheableReplacement;", "vungle-ads_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<CacheableReplacement> serializer() {
                return (KSerializer)CacheableReplacement$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u0011\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0015\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u00c7\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$ViewAbility;", "", "seen1", "", "om", "Lcom/vungle/ads/internal/model/AdPayload$ViewAbilityInfo;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/vungle/ads/internal/model/AdPayload$ViewAbilityInfo;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lcom/vungle/ads/internal/model/AdPayload$ViewAbilityInfo;)V", "getOm", "()Lcom/vungle/ads/internal/model/AdPayload$ViewAbilityInfo;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "vungle-ads_release"})
    public static final class ViewAbility {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final ViewAbilityInfo om;

        public ViewAbility(@Nullable ViewAbilityInfo om) {
            this.om = om;
        }

        public /* synthetic */ ViewAbility(ViewAbilityInfo viewAbilityInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                viewAbilityInfo = null;
            }
            this(viewAbilityInfo);
        }

        @Nullable
        public final ViewAbilityInfo getOm() {
            return this.om;
        }

        @Nullable
        public final ViewAbilityInfo component1() {
            return this.om;
        }

        @NotNull
        public final ViewAbility copy(@Nullable ViewAbilityInfo om) {
            return new ViewAbility(om);
        }

        public static /* synthetic */ ViewAbility copy$default(ViewAbility viewAbility, ViewAbilityInfo viewAbilityInfo, int n, Object object) {
            if ((n & 1) != 0) {
                viewAbilityInfo = viewAbility.om;
            }
            return viewAbility.copy(viewAbilityInfo);
        }

        @NotNull
        public String toString() {
            return "ViewAbility(om=" + this.om + ')';
        }

        public int hashCode() {
            return this.om == null ? 0 : this.om.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViewAbility)) {
                return false;
            }
            ViewAbility viewAbility = (ViewAbility)other;
            return Intrinsics.areEqual((Object)this.om, (Object)viewAbility.om);
        }

        @JvmStatic
        public static final void write$Self(@NotNull ViewAbility self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.om != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)ViewAbilityInfo$$serializer.INSTANCE, (Object)self.om);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ ViewAbility(int seen1, ViewAbilityInfo om, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen1) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)ViewAbility$$serializer.INSTANCE.getDescriptor());
            }
            this.om = (seen1 & 1) == 0 ? null : om;
        }

        public ViewAbility() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$ViewAbility$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/vungle/ads/internal/model/AdPayload$ViewAbility;", "vungle-ads_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ViewAbility> serializer() {
                return (KSerializer)ViewAbility$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B1\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u001d\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J&\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001J!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u00c7\u0001R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u0012\u0012\u0004\b\u0010\u0010\r\u001a\u0004\b\u0004\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$ViewAbilityInfo;", "", "seen1", "", "isEnabled", "", "extraVast", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/Boolean;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/Boolean;Ljava/lang/String;)V", "getExtraVast$annotations", "()V", "getExtraVast", "()Ljava/lang/String;", "isEnabled$annotations", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "component1", "component2", "copy", "(Ljava/lang/Boolean;Ljava/lang/String;)Lcom/vungle/ads/internal/model/AdPayload$ViewAbilityInfo;", "equals", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "vungle-ads_release"})
    public static final class ViewAbilityInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Boolean isEnabled;
        @Nullable
        private final String extraVast;

        public ViewAbilityInfo(@Nullable Boolean isEnabled, @Nullable String extraVast) {
            this.isEnabled = isEnabled;
            this.extraVast = extraVast;
        }

        public /* synthetic */ ViewAbilityInfo(Boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = null;
            }
            if ((n & 2) != 0) {
                string = null;
            }
            this(bl, string);
        }

        @Nullable
        public final Boolean isEnabled() {
            return this.isEnabled;
        }

        @SerialName(value="is_enabled")
        public static /* synthetic */ void isEnabled$annotations() {
        }

        @Nullable
        public final String getExtraVast() {
            return this.extraVast;
        }

        @SerialName(value="extra_vast")
        public static /* synthetic */ void getExtraVast$annotations() {
        }

        @Nullable
        public final Boolean component1() {
            return this.isEnabled;
        }

        @Nullable
        public final String component2() {
            return this.extraVast;
        }

        @NotNull
        public final ViewAbilityInfo copy(@Nullable Boolean isEnabled, @Nullable String extraVast) {
            return new ViewAbilityInfo(isEnabled, extraVast);
        }

        public static /* synthetic */ ViewAbilityInfo copy$default(ViewAbilityInfo viewAbilityInfo, Boolean bl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = viewAbilityInfo.isEnabled;
            }
            if ((n & 2) != 0) {
                string = viewAbilityInfo.extraVast;
            }
            return viewAbilityInfo.copy(bl, string);
        }

        @NotNull
        public String toString() {
            return "ViewAbilityInfo(isEnabled=" + this.isEnabled + ", extraVast=" + this.extraVast + ')';
        }

        public int hashCode() {
            int result = this.isEnabled == null ? 0 : ((Object)this.isEnabled).hashCode();
            result = result * 31 + (this.extraVast == null ? 0 : this.extraVast.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViewAbilityInfo)) {
                return false;
            }
            ViewAbilityInfo viewAbilityInfo = (ViewAbilityInfo)other;
            if (!Intrinsics.areEqual((Object)this.isEnabled, (Object)viewAbilityInfo.isEnabled)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.extraVast, (Object)viewAbilityInfo.extraVast);
        }

        @JvmStatic
        public static final void write$Self(@NotNull ViewAbilityInfo self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.isEnabled != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.isEnabled);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.extraVast != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.extraVast);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ ViewAbilityInfo(int seen1, @SerialName(value="is_enabled") Boolean isEnabled, @SerialName(value="extra_vast") String extraVast, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen1) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)ViewAbilityInfo$$serializer.INSTANCE.getDescriptor());
            }
            this.isEnabled = (seen1 & 1) == 0 ? null : isEnabled;
            this.extraVast = (seen1 & 2) == 0 ? null : extraVast;
        }

        public ViewAbilityInfo() {
            this(null, null, 3, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$ViewAbilityInfo$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/vungle/ads/internal/model/AdPayload$ViewAbilityInfo;", "vungle-ads_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ViewAbilityInfo> serializer() {
                return (KSerializer)ViewAbilityInfo$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B1\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ&\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u00c7\u0001R \u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u000e\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR \u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u000e\u0012\u0004\b\u000f\u0010\u000b\u001a\u0004\b\u0010\u0010\r\u00a8\u0006$"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$AdSizeInfo;", "", "seen1", "", "width", "height", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/Integer;Ljava/lang/Integer;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "getHeight$annotations", "()V", "getHeight", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getWidth$annotations", "getWidth", "component1", "component2", "copy", "(Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/vungle/ads/internal/model/AdPayload$AdSizeInfo;", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "vungle-ads_release"})
    public static final class AdSizeInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Integer width;
        @Nullable
        private final Integer height;

        public AdSizeInfo(@Nullable Integer width, @Nullable Integer height) {
            this.width = width;
            this.height = height;
        }

        public /* synthetic */ AdSizeInfo(Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        @Nullable
        public final Integer getWidth() {
            return this.width;
        }

        @SerialName(value="w")
        public static /* synthetic */ void getWidth$annotations() {
        }

        @Nullable
        public final Integer getHeight() {
            return this.height;
        }

        @SerialName(value="h")
        public static /* synthetic */ void getHeight$annotations() {
        }

        @Nullable
        public final Integer component1() {
            return this.width;
        }

        @Nullable
        public final Integer component2() {
            return this.height;
        }

        @NotNull
        public final AdSizeInfo copy(@Nullable Integer width, @Nullable Integer height) {
            return new AdSizeInfo(width, height);
        }

        public static /* synthetic */ AdSizeInfo copy$default(AdSizeInfo adSizeInfo, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = adSizeInfo.width;
            }
            if ((n3 & 2) != 0) {
                n2 = adSizeInfo.height;
            }
            return adSizeInfo.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "AdSizeInfo(width=" + this.width + ", height=" + this.height + ')';
        }

        public int hashCode() {
            int result = this.width == null ? 0 : ((Object)this.width).hashCode();
            result = result * 31 + (this.height == null ? 0 : ((Object)this.height).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdSizeInfo)) {
                return false;
            }
            AdSizeInfo adSizeInfo = (AdSizeInfo)other;
            if (!Intrinsics.areEqual((Object)this.width, (Object)adSizeInfo.width)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.height, (Object)adSizeInfo.height);
        }

        @JvmStatic
        public static final void write$Self(@NotNull AdSizeInfo self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            if (output.shouldEncodeElementDefault(serialDesc, 0)) {
                bl2 = true;
            } else {
                Integer n = self.width;
                bl2 = n == null || n != 0;
            }
            if (bl2) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.width);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1)) {
                bl = true;
            } else {
                Integer n = self.height;
                bl = n == null || n != 0;
            }
            if (bl) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.height);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ AdSizeInfo(int seen1, @SerialName(value="w") Integer width, @SerialName(value="h") Integer height, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen1) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)AdSizeInfo$$serializer.INSTANCE.getDescriptor());
            }
            this.width = (seen1 & 1) == 0 ? Integer.valueOf(0) : width;
            this.height = (seen1 & 2) == 0 ? Integer.valueOf(0) : height;
        }

        public AdSizeInfo() {
            this(null, null, 3, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$AdSizeInfo$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/vungle/ads/internal/model/AdPayload$AdSizeInfo;", "vungle-ads_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<AdSizeInfo> serializer() {
                return (KSerializer)AdSizeInfo$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B1\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB\u001d\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u00c7\u0001R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u000f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR \u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u000f\u0012\u0004\b\u0010\u0010\f\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;", "", "seen1", "", "allowFileAccessFromFileUrls", "", "allowUniversalAccessFromFileUrls", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/Boolean;Ljava/lang/Boolean;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getAllowFileAccessFromFileUrls$annotations", "()V", "getAllowFileAccessFromFileUrls", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getAllowUniversalAccessFromFileUrls$annotations", "getAllowUniversalAccessFromFileUrls", "component1", "component2", "copy", "(Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;", "equals", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "vungle-ads_release"})
    public static final class WebViewSettings {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Boolean allowFileAccessFromFileUrls;
        @Nullable
        private final Boolean allowUniversalAccessFromFileUrls;

        public WebViewSettings(@Nullable Boolean allowFileAccessFromFileUrls, @Nullable Boolean allowUniversalAccessFromFileUrls) {
            this.allowFileAccessFromFileUrls = allowFileAccessFromFileUrls;
            this.allowUniversalAccessFromFileUrls = allowUniversalAccessFromFileUrls;
        }

        public /* synthetic */ WebViewSettings(Boolean bl, Boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = null;
            }
            if ((n & 2) != 0) {
                bl2 = null;
            }
            this(bl, bl2);
        }

        @Nullable
        public final Boolean getAllowFileAccessFromFileUrls() {
            return this.allowFileAccessFromFileUrls;
        }

        @SerialName(value="allow_file_access_from_file_urls")
        public static /* synthetic */ void getAllowFileAccessFromFileUrls$annotations() {
        }

        @Nullable
        public final Boolean getAllowUniversalAccessFromFileUrls() {
            return this.allowUniversalAccessFromFileUrls;
        }

        @SerialName(value="allow_universal_access_from_file_urls")
        public static /* synthetic */ void getAllowUniversalAccessFromFileUrls$annotations() {
        }

        @Nullable
        public final Boolean component1() {
            return this.allowFileAccessFromFileUrls;
        }

        @Nullable
        public final Boolean component2() {
            return this.allowUniversalAccessFromFileUrls;
        }

        @NotNull
        public final WebViewSettings copy(@Nullable Boolean allowFileAccessFromFileUrls, @Nullable Boolean allowUniversalAccessFromFileUrls) {
            return new WebViewSettings(allowFileAccessFromFileUrls, allowUniversalAccessFromFileUrls);
        }

        public static /* synthetic */ WebViewSettings copy$default(WebViewSettings webViewSettings, Boolean bl, Boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = webViewSettings.allowFileAccessFromFileUrls;
            }
            if ((n & 2) != 0) {
                bl2 = webViewSettings.allowUniversalAccessFromFileUrls;
            }
            return webViewSettings.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "WebViewSettings(allowFileAccessFromFileUrls=" + this.allowFileAccessFromFileUrls + ", allowUniversalAccessFromFileUrls=" + this.allowUniversalAccessFromFileUrls + ')';
        }

        public int hashCode() {
            int result = this.allowFileAccessFromFileUrls == null ? 0 : ((Object)this.allowFileAccessFromFileUrls).hashCode();
            result = result * 31 + (this.allowUniversalAccessFromFileUrls == null ? 0 : ((Object)this.allowUniversalAccessFromFileUrls).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WebViewSettings)) {
                return false;
            }
            WebViewSettings webViewSettings = (WebViewSettings)other;
            if (!Intrinsics.areEqual((Object)this.allowFileAccessFromFileUrls, (Object)webViewSettings.allowFileAccessFromFileUrls)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.allowUniversalAccessFromFileUrls, (Object)webViewSettings.allowUniversalAccessFromFileUrls);
        }

        @JvmStatic
        public static final void write$Self(@NotNull WebViewSettings self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.allowFileAccessFromFileUrls != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.allowFileAccessFromFileUrls);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.allowUniversalAccessFromFileUrls != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.allowUniversalAccessFromFileUrls);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ WebViewSettings(int seen1, @SerialName(value="allow_file_access_from_file_urls") Boolean allowFileAccessFromFileUrls, @SerialName(value="allow_universal_access_from_file_urls") Boolean allowUniversalAccessFromFileUrls, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen1) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)WebViewSettings$$serializer.INSTANCE.getDescriptor());
            }
            this.allowFileAccessFromFileUrls = (seen1 & 1) == 0 ? null : allowFileAccessFromFileUrls;
            this.allowUniversalAccessFromFileUrls = (seen1 & 2) == 0 ? null : allowUniversalAccessFromFileUrls;
        }

        public WebViewSettings() {
            this(null, null, 3, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;", "vungle-ads_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<WebViewSettings> serializer() {
                return (KSerializer)WebViewSettings$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

