/*
 * Decompiled with CFR 0.152.
 */
package com.wacai.open.sdk;

import com.wacai.open.sdk.Version;
import com.wacai.open.sdk.errorcode.ErrorCode;
import com.wacai.open.sdk.exception.WacaiOpenApiResponseException;
import com.wacai.open.sdk.json.JsonProcessor;
import com.wacai.open.sdk.json.JsonTool;
import com.wacai.open.sdk.json.TypeReference;
import com.wacai.open.sdk.request.WacaiOpenApiRequest;
import com.wacai.open.sdk.response.WacaiErrorResponse;
import com.wacai.open.sdk.response.WacaiOpenApiResponseCallback;
import com.wacai.open.sdk.util.SignUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WacaiOpenApiClient {
    private static final Logger log = LoggerFactory.getLogger(WacaiOpenApiClient.class);
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType OBJ_STREAM = MediaType.parse((String)"application/octet-stream");
    private static final List<String> SIGN_HEADERS = Arrays.asList("x-wac-version", "x-wac-timestamp", "x-wac-access-token", "x-wac-app-key");
    private final String appKey;
    private final String appSecret;
    private OkHttpClient client;
    private final AtomicBoolean initFlag = new AtomicBoolean(false);
    private String gatewayEntryUrl = "https://open.wacai.com/gw/api_entry";
    @Deprecated
    private String gatewayAuthUrl = "https://open.wacai.com/gw/auth";
    private JsonProcessor processor;

    public WacaiOpenApiClient(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public static WacaiOpenApiClient init(String appKey, String appSecret) {
        WacaiOpenApiClient wacaiOpenApiClient = new WacaiOpenApiClient(appKey, appSecret);
        wacaiOpenApiClient.init();
        return wacaiOpenApiClient;
    }

    public void init() {
        if (!this.initFlag.compareAndSet(false, true)) {
            throw new IllegalStateException("init state");
        }
        if (this.gatewayEntryUrl == null || this.gatewayEntryUrl.trim().length() <= 0) {
            throw new IllegalArgumentException("invalid gatewayEntryUrl " + this.gatewayEntryUrl);
        }
        if (this.gatewayAuthUrl == null || this.gatewayAuthUrl.trim().length() <= 0) {
            throw new IllegalArgumentException("invalid gatewayAuthUrl " + this.gatewayAuthUrl);
        }
        if (this.client == null) {
            this.client = new OkHttpClient();
        }
        JsonTool.initJsonProcess((JsonProcessor)this.processor);
    }

    public <T> T invoke(WacaiOpenApiRequest wacaiOpenApiRequest, TypeReference<T> typeReference) {
        return this.doInvoke(wacaiOpenApiRequest, typeReference.getType());
    }

    public <T> T invoke(WacaiOpenApiRequest wacaiOpenApiRequest, Class<T> clazz) {
        return this.doInvoke(wacaiOpenApiRequest, clazz);
    }

    private boolean isNeedDecode(Response response) {
        return response.header("x_wac_decode_flag") == null;
    }

    private String parseTraceId(Response response) {
        return response.header("custom");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doInvoke(WacaiOpenApiRequest wacaiOpenApiRequest, Type type) {
        Request request = this.assemblyRequest(wacaiOpenApiRequest);
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody body = response.body();
            if (body == null) {
                log.error("response body is null");
                throw new WacaiOpenApiResponseException(ErrorCode.CLIENT_SYSTEM_ERROR);
            }
            if (response.code() == 200) {
                if (this.isNeedDecode(response)) {
                    String responseBodyString = body.string();
                    T t = this.deserialization(responseBodyString, type);
                    return t;
                }
                byte[] responseBodyString = body.bytes();
                return (T)responseBodyString;
            }
            if (response.code() != 400) {
                String responseBodyString = body.string();
                log.error("sdk error request log, traceId:{}, api:{},httpCode:{},httpBodyMsg:{} ", new Object[]{this.parseTraceId(response), wacaiOpenApiRequest.getApiName(), response.code(), responseBodyString});
                throw new WacaiOpenApiResponseException(ErrorCode.CLIENT_SYSTEM_ERROR);
            }
            String responseBodyString = body.string();
            try {
                WacaiErrorResponse wacaiErrorResponse = (WacaiErrorResponse)JsonTool.deserialization((String)responseBodyString, WacaiErrorResponse.class);
                throw new WacaiOpenApiResponseException(wacaiErrorResponse);
            }
            catch (Exception e) {
                log.error("failed to deserialization {}", (Object)responseBodyString, (Object)e);
                throw new WacaiOpenApiResponseException(ErrorCode.CLIENT_SYSTEM_ERROR);
            }
        }
        catch (IOException e) {
            log.error("failed to execute {}", (Object)request, (Object)e);
            throw new WacaiOpenApiResponseException(ErrorCode.CLIENT_SYSTEM_ERROR, (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new WacaiOpenApiResponseException(ErrorCode.ERROR_RET_TYPE, (Throwable)e);
        }
    }

    private <T> T deserialization(String json, Type type) {
        if (String.class.equals((Object)type)) {
            return (T)json;
        }
        return (T)JsonTool.deserialization((String)json, (Type)type);
    }

    private byte[] assemblyRequestBody(WacaiOpenApiRequest wacaiOpenApiRequest) {
        Map<String, Object> bizParam = wacaiOpenApiRequest.getBizParam();
        return JsonTool.serialization(bizParam);
    }

    public <T> void invoke(WacaiOpenApiRequest wacaiOpenApiRequest, TypeReference<T> typeReference, WacaiOpenApiResponseCallback<T> callback) {
        this.doInvoke(wacaiOpenApiRequest, typeReference.getType(), callback);
    }

    public <T> void invoke(WacaiOpenApiRequest wacaiOpenApiRequest, Class<T> clazz, WacaiOpenApiResponseCallback<T> callback) {
        this.doInvoke(wacaiOpenApiRequest, clazz, callback);
    }

    private <T> void doInvoke(final WacaiOpenApiRequest wacaiOpenApiRequest, final Type type, final WacaiOpenApiResponseCallback<T> callback) {
        Request request = this.assemblyRequest(wacaiOpenApiRequest);
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onFailure(new WacaiOpenApiResponseException(ErrorCode.CLIENT_SYSTEM_ERROR, (Throwable)e));
            }

            public void onResponse(Call call, Response response) throws IOException {
                ResponseBody body = response.body();
                if (body == null) {
                    callback.onFailure(new WacaiOpenApiResponseException(ErrorCode.CLIENT_SYSTEM_ERROR));
                    return;
                }
                if (response.code() == 200) {
                    if (WacaiOpenApiClient.this.isNeedDecode(response)) {
                        String responseBodyString = body.string();
                        Object data = WacaiOpenApiClient.this.deserialization(responseBodyString, type);
                        callback.onSuccess(data);
                        return;
                    }
                    try {
                        byte[] bytes = body.bytes();
                        callback.onSuccess(bytes);
                    }
                    catch (IOException e) {
                        log.error("read response body error", (Throwable)e);
                        callback.onFailure(new WacaiOpenApiResponseException(ErrorCode.CLIENT_SYSTEM_ERROR));
                    }
                    catch (ClassCastException e) {
                        callback.onFailure(new WacaiOpenApiResponseException(ErrorCode.ERROR_RET_TYPE));
                    }
                    return;
                }
                if (response.code() == 400) {
                    WacaiErrorResponse wacaiErrorResponse;
                    String responseBodyString = body.string();
                    try {
                        wacaiErrorResponse = (WacaiErrorResponse)JsonTool.deserialization((String)responseBodyString, WacaiErrorResponse.class);
                    }
                    catch (Exception e) {
                        log.error("failed to deserialization {}", (Object)responseBodyString, (Object)e);
                        callback.onFailure(new WacaiOpenApiResponseException(ErrorCode.CLIENT_SYSTEM_ERROR));
                        return;
                    }
                    callback.onFailure(new WacaiOpenApiResponseException(wacaiErrorResponse));
                    return;
                }
                log.error("traceId {},api {},request {}, response code is {}", new Object[]{WacaiOpenApiClient.this.parseTraceId(response), wacaiOpenApiRequest.getApiName(), wacaiOpenApiRequest, response.code()});
                callback.onFailure(new WacaiOpenApiResponseException(ErrorCode.CLIENT_SYSTEM_ERROR));
            }
        });
    }

    private Request assemblyRequest(WacaiOpenApiRequest wacaiOpenApiRequest) {
        if (!this.initFlag.get()) {
            throw new IllegalStateException("Not initial client, please call init method before doInvoke");
        }
        byte[] bodyBytes = this.assemblyRequestBody(wacaiOpenApiRequest);
        byte[] byteBuffer = wacaiOpenApiRequest.getByteBuffer();
        MediaType mediaType = JSON_MEDIA_TYPE;
        if (byteBuffer != null && byteBuffer.length > 0) {
            bodyBytes = byteBuffer;
            mediaType = OBJ_STREAM;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("x-wac-version", String.valueOf(Version.getProtocolVersion()));
        headerMap.put("x-wac-timestamp", String.valueOf(System.currentTimeMillis()));
        headerMap.put("x-wac-sdk-version", Version.getSdkVersion());
        headerMap.put("x-wac-app-key", this.appKey);
        String signature = this.generateSignature(wacaiOpenApiRequest.getApiName(), wacaiOpenApiRequest.getApiVersion(), headerMap, bodyBytes);
        headerMap.put("x-wac-signature", signature);
        String url = this.gatewayEntryUrl + "/" + wacaiOpenApiRequest.getApiName() + "/" + wacaiOpenApiRequest.getApiVersion();
        return new Request.Builder().url(url).headers(Headers.of(headerMap)).post(RequestBody.create((MediaType)mediaType, (byte[])bodyBytes)).build();
    }

    private String generateSignature(String apiName, String apiVersion, Map<String, String> headerMap, byte[] bodyBytes) {
        String headerString = this.generateHeadersPlainText(headerMap);
        String bodyMd5 = Base64.encodeBase64String((byte[])DigestUtils.md5((byte[])bodyBytes));
        String signPlainText = apiName + "|" + apiVersion + "|" + headerString + "|" + bodyMd5;
        return SignUtil.generateSign((String)signPlainText, (String)this.appSecret);
    }

    private String generateHeadersPlainText(Map<String, String> headerMap) {
        TreeMap<String, String> headersForSign = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            if (!SIGN_HEADERS.contains(entry.getKey())) continue;
            headersForSign.put(entry.getKey(), entry.getValue());
        }
        StringBuilder headerStringBuilder = new StringBuilder();
        for (Map.Entry entry : headersForSign.entrySet()) {
            headerStringBuilder.append('&').append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        return headerStringBuilder.substring(1);
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public void setGatewayEntryUrl(String gatewayEntryUrl) {
        this.gatewayEntryUrl = gatewayEntryUrl;
    }

    @Deprecated
    public void setGatewayAuthUrl(String gatewayAuthUrl) {
        this.gatewayAuthUrl = gatewayAuthUrl;
    }

    public void setProcessor(JsonProcessor processor) {
        this.processor = processor;
    }
}

