/*
 * Decompiled with CFR 0.152.
 */
package com.wacai.open.sdk.filter;

import com.wacai.open.sdk.filter.WacaiHttpServletRequest;
import com.wacai.open.sdk.util.RequestSignUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WacaiOpenSignCheckerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WacaiOpenSignCheckerFilter.class);
    private static final byte[] sign_not_match_error = "{\"code\": \"10008\", \"error\": \"sign\u503c\u4e0d\u5339\u914d\"}".getBytes(Charset.forName("UTF-8"));
    private boolean enableSignCheck = true;
    private String appSecret;

    public void init(FilterConfig filterConfig) throws ServletException {
        String appSecret;
        String enableSignCheck = filterConfig.getInitParameter("enableSignCheck");
        if (enableSignCheck != null) {
            this.enableSignCheck = Boolean.valueOf(enableSignCheck);
        }
        if ((appSecret = filterConfig.getInitParameter("appSecret")) == null || appSecret.trim().length() <= 0) {
            throw new ServletException("invalid app secret " + appSecret);
        }
        this.appSecret = appSecret;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.enableSignCheck) {
            chain.doFilter(request, response);
            return;
        }
        Object httpServletRequest = (HttpServletRequest)request;
        boolean isSignMatch = RequestSignUtil.checkInboundRequestSign(httpServletRequest = new WacaiHttpServletRequest((HttpServletRequest)httpServletRequest), this.appSecret);
        if (!isSignMatch) {
            log.error("sign is not match, request path is {}", (Object)httpServletRequest.getPathInfo());
            this.sendErrorResponse((HttpServletResponse)response);
            return;
        }
        chain.doFilter((ServletRequest)httpServletRequest, response);
    }

    private void sendErrorResponse(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(401);
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.getOutputStream().write(sign_not_match_error);
        httpServletResponse.flushBuffer();
    }

    public void destroy() {
    }
}

