/*
 * Decompiled with CFR 0.152.
 */
package com.wacai.open.sdk.util;

import com.wacai.open.sdk.util.SignUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSignUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestSignUtil.class);

    public static boolean checkInboundRequestSign(String method, String bodyMd5, Map<String, String> headers, Map<String, String> params, String appSecret) {
        String expectedSign;
        char delimit = '|';
        List<String> keys = Arrays.asList(headers.get("x-wac-signature-headers").split(","));
        String headerString = RequestSignUtil.generateHeadersPlainText(headers, keys);
        String paramString = RequestSignUtil.generateParamsPlainText(params);
        String signPlainText = method + delimit + bodyMd5 + delimit + headerString + delimit + paramString;
        String signature = SignUtil.generateSign((String)signPlainText, (String)appSecret);
        boolean equals = Objects.equals(signature, expectedSign = headers.get("x-wac-signature"));
        if (!equals) {
            log.warn("sign not match, expected sign is {}, generated sign is {}, sign plaintext is {}", new Object[]{expectedSign, signature, signPlainText});
        }
        return equals;
    }

    private static String generateHeadersPlainText(Map<String, String> headerMap, List<String> keys) {
        TreeMap<String, String> headersForSign = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            if (!keys.contains(entry.getKey())) continue;
            headersForSign.put(entry.getKey(), entry.getValue());
        }
        if (headersForSign.isEmpty()) {
            return "";
        }
        StringBuilder headerStringBuilder = new StringBuilder();
        for (Map.Entry entry : headersForSign.entrySet()) {
            headerStringBuilder.append('&').append(((String)entry.getKey()).toLowerCase()).append("=").append(entry.getValue() == null ? "" : (String)entry.getValue());
        }
        return headerStringBuilder.substring(1);
    }

    private static String generateParamsPlainText(Map<String, String> paramsMap) {
        if (paramsMap == null || paramsMap.isEmpty()) {
            return "";
        }
        TreeMap<String, String> headersForSign = new TreeMap<String, String>(paramsMap);
        StringBuilder headerStringBuilder = new StringBuilder();
        for (Map.Entry entry : headersForSign.entrySet()) {
            headerStringBuilder.append('&').append(((String)entry.getKey()).toLowerCase()).append("=").append(entry.getValue() == null ? "" : (String)entry.getValue());
        }
        return headerStringBuilder.substring(1);
    }

    public static boolean checkInboundRequestSign(HttpServletRequest httpServletRequest, String appSecret) throws IOException {
        String method = httpServletRequest.getMethod().trim().toUpperCase();
        String bodyMd5 = "";
        if ("POST".equals(method) && !httpServletRequest.getHeader("content-type").contains("application/x-www-form-urlencoded") && !httpServletRequest.getHeader("content-type").contains("multipart/form-data")) {
            ServletInputStream inputStream = httpServletRequest.getInputStream();
            bodyMd5 = Base64.encodeBase64String((byte[])DigestUtils.md5((InputStream)inputStream));
        }
        Map<String, String> headers = RequestSignUtil.resolveHeaders(httpServletRequest);
        Map<String, String> params = RequestSignUtil.resolveParams(httpServletRequest);
        return RequestSignUtil.checkInboundRequestSign(method, bodyMd5, headers, params, appSecret);
    }

    private static Map<String, String> resolveHeaders(HttpServletRequest httpServletRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = httpServletRequest.getHeader(headerName);
            headers.put(headerName.trim().toLowerCase(), headerValue);
        }
        return headers;
    }

    private static Map<String, String> resolveParams(HttpServletRequest httpServletRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        Map parameterMap = httpServletRequest.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] values = (String[])entry.getValue();
            String value = "";
            if (values.length == 1) {
                value = values[0];
            } else if (values.length > 1) {
                StringBuilder valueStringBuilder = new StringBuilder();
                for (String v : values) {
                    valueStringBuilder.append(",").append(v);
                }
                value = valueStringBuilder.substring(1);
            }
            params.put((String)entry.getKey(), value);
        }
        return params;
    }
}

