package com.wadpam.open.i18n.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import net.sf.mardao.core.CursorPage;
import net.sf.mardao.core.Filter;
import net.sf.mardao.core.dao.DaoImpl;
import net.sf.mardao.core.dao.TypeDaoImpl;
import net.sf.mardao.core.geo.DLocation;
import com.wadpam.open.i18n.domain.Di18nTranslation;

/**
 * The Di18nTranslation domain-object specific finders and methods go in this POJO.
 * 
 * Generated on 2013-03-28T09:18:31.896+0700.
 * @author mardao DAO generator (net.sf.mardao.plugin.ProcessDomainMojo)
 */
public class GeneratedDi18nTranslationDaoImpl extends TypeDaoImpl<Di18nTranslation, java.lang.String> 
	implements GeneratedDi18nTranslationDao {


    /** to list the property names for ManyToOne relations */
    @Override
    protected List<String> getBasicColumnNames() {
        return BASIC_NAMES;
    }

    /** to list the property names for ManyToOne relations */
    @Override
    protected List<String> getManyToOneColumnNames() {
        return MANY_TO_ONE_NAMES;
    }

    private final Map<String, DaoImpl> MANY_TO_ONE_DAOS = new TreeMap<String, DaoImpl>();

    /** Default constructor */
   public GeneratedDi18nTranslationDaoImpl() {
      super(Di18nTranslation.class, java.lang.String.class);
   }

   // ------ BEGIN DaoImpl overrides -----------------------------
   
   public String getPrimaryKeyColumnName() {
   		return COLUMN_NAME_LOCALE;
   }
   
   public List<String> getColumnNames() {
        return COLUMN_NAMES;
   }

   @Override
   protected DaoImpl getManyToOneDao(String columnName) {
       return MANY_TO_ONE_DAOS.get(columnName);
   }

    @Override
    protected Object getDomainProperty(Di18nTranslation domain, String name) {
        Object value;
        // simple key?
        if (COLUMN_NAME_LOCALE.equals(name)) {
            value = domain.getLocale();
        }
        // parent key?
        else if (COLUMN_NAME_PARENT.equals(name)) {
            value = domain.getParent();
        }
        // fields
        else if (COLUMN_NAME_CREATEDBY.equals(name)) {
            value = domain.getCreatedBy();
        }
        else if (COLUMN_NAME_CREATEDDATE.equals(name)) {
            value = domain.getCreatedDate();
        }
        else if (COLUMN_NAME_LOCALIZEDIMAGE.equals(name)) {
            value = domain.getLocalizedImage();
        }
        else if (COLUMN_NAME_LOCALIZEDSTRING.equals(name)) {
            value = domain.getLocalizedString();
        }
        else if (COLUMN_NAME_LOCALIZEDURL.equals(name)) {
            value = domain.getLocalizedUrl();
        }
        else if (COLUMN_NAME_UPDATEDBY.equals(name)) {
            value = domain.getUpdatedBy();
        }
        else if (COLUMN_NAME_UPDATEDDATE.equals(name)) {
            value = domain.getUpdatedDate();
        }
        // one-to-ones
        // many-to-ones
        // many-to-manys
        else {
            value = super.getDomainProperty(domain, name);
        }

        return value;
    }

    /**
     * Returns the class of the domain property for specified column
     * @param name
     * @return the class of the domain property
     */
    public Class getColumnClass(String name) {
        Class clazz;
        // simple key?
        if (COLUMN_NAME_LOCALE.equals(name)) {
            clazz = java.lang.String.class;
        }
        // parent key?
        else if (COLUMN_NAME_PARENT.equals(name)) {
            clazz = java.lang.Object.class;
        }
        // fields
        else if (COLUMN_NAME_CREATEDBY.equals(name)) {
            clazz = java.lang.String.class;
        }
        else if (COLUMN_NAME_CREATEDDATE.equals(name)) {
            clazz = java.util.Date.class;
        }
        else if (COLUMN_NAME_LOCALIZEDIMAGE.equals(name)) {
            clazz = java.lang.String.class;
        }
        else if (COLUMN_NAME_LOCALIZEDSTRING.equals(name)) {
            clazz = java.lang.String.class;
        }
        else if (COLUMN_NAME_LOCALIZEDURL.equals(name)) {
            clazz = java.lang.String.class;
        }
        else if (COLUMN_NAME_UPDATEDBY.equals(name)) {
            clazz = java.lang.String.class;
        }
        else if (COLUMN_NAME_UPDATEDDATE.equals(name)) {
            clazz = java.util.Date.class;
        }
        // one-to-ones
        // many-to-ones
        // many-to-manys
        else {
            throw new IllegalArgumentException("No such column " + name);
        }

        return clazz;
    }
      
    @Override
    protected void setDomainProperty(final Di18nTranslation domain, final String name, final Object value) {
        // simple key?
        if (COLUMN_NAME_LOCALE.equals(name)) {
            domain.setLocale((java.lang.String) value);
        }
        // parent key?
        else if (COLUMN_NAME_PARENT.equals(name)) {
            domain.setParent((java.lang.Object) value);
        }
        // fields
        else if (COLUMN_NAME_CREATEDBY.equals(name)) {
            domain.setCreatedBy((java.lang.String) value);
        }
        else if (COLUMN_NAME_CREATEDDATE.equals(name)) {
            domain.setCreatedDate((java.util.Date) value);
        }
        else if (COLUMN_NAME_LOCALIZEDIMAGE.equals(name)) {
            domain.setLocalizedImage((java.lang.String) value);
        }
        else if (COLUMN_NAME_LOCALIZEDSTRING.equals(name)) {
            domain.setLocalizedString((java.lang.String) value);
        }
        else if (COLUMN_NAME_LOCALIZEDURL.equals(name)) {
            domain.setLocalizedUrl((java.lang.String) value);
        }
        else if (COLUMN_NAME_UPDATEDBY.equals(name)) {
            domain.setUpdatedBy((java.lang.String) value);
        }
        else if (COLUMN_NAME_UPDATEDDATE.equals(name)) {
            domain.setUpdatedDate((java.util.Date) value);
        }
        // one-to-ones
        // many-to-ones
        // many-to-manys
        else {
            super.setDomainProperty(domain, name, value);
        }
    }

    @Override
    protected void setDomainStringProperty(final Di18nTranslation domain, final String name, final Map<String, String> properties) {
        final String value = properties.get(name);
        Class clazz = getColumnClass(name);
        // many-to-ones
        setDomainProperty(domain, name, parseProperty(value, clazz));
    }

    /**
     * Overrides to substitute Entity properties with foreign keys
     */
    @Override
    protected void setCoreProperty(Object core, String name, Object value) {
        if (null == core || null == name) {
            return;
        }
        else if (null == value) {
            // do nothing in particular, will call super at end
        }
        super.setCoreProperty(core, name, value);
    }

    /** Default implementation returns null, overrides for parent parent */
    public String getParentKeyColumnName() {
        return COLUMN_NAME_PARENT;
    }

   // ------ END DaoImpl overrides -----------------------------

        public Object getParentKey(Di18nTranslation domain) {
            return domain.getParent();
        }

        public void setParentKey(Di18nTranslation domain, Object parent) {
            domain.setParent((Serializable) parent);
        }

	// ----------------------- parent finders -------------------------------

	/**
	 * query-by method for parent field parent
	 * @param parent the specified attribute
	 * @return an Iterable of Di18nTranslations for the specified parent
	 */
	public final Iterable<Di18nTranslation> queryByParent(Object parent) {
            return queryIterable(false, 0, -1, parent, null, null, false, null, false);
	}
	
	/**
	 * query-key-by method for parent field parent
	 * @param parent the parent
	 * @return an Iterable of keys to the Di18nTranslations with the specified parent
	 */
	public final Iterable<java.lang.String> queryKeysByParent(Object parent) {
            return queryIterableKeys(0, -1, parent, null, null, false, null, false);
	}

	/**
	 * query-page-by method for parent field parent
	 * @param parent the specified parent
         * @param pageSize the number of domain entities in the page
         * @param cursorString non-null if get next page
	 * @return a Page of Di18nTranslations for the specified parent
	 */
	public final CursorPage<Di18nTranslation, java.lang.String> queryPageByParent(java.lang.Object parent,
            int pageSize, Serializable cursorString) {
            return queryPage(false, pageSize, parent, null, null, false, null, false, cursorString);
        }


        /**
         * @return the simple key for specified Di18nTranslation domain object
         */
        public String getSimpleKey(Di18nTranslation domain) {
            if (null == domain) {
                return null;
            }
            return domain.getLocale();
        }

        /**
         * @return the simple key for specified Di18nTranslation domain object
         */
        public void setSimpleKey(Di18nTranslation domain, String locale) {
            domain.setLocale(locale);
        }

        public String getCreatedByColumnName() {
            return COLUMN_NAME_CREATEDBY;
        }

        public String getCreatedBy(Di18nTranslation domain) {
            if (null == domain) {
                return null;
            }
            return domain.getCreatedBy();
        }

        public void _setCreatedBy(Di18nTranslation domain, String creator) {
            domain.setCreatedBy(creator);
        }

        public String getUpdatedByColumnName() {
            return COLUMN_NAME_UPDATEDBY;
        }

        public String getUpdatedBy(Di18nTranslation domain) {
            if (null == domain) {
                return null;
            }
            return domain.getUpdatedBy();
        }

        public void _setUpdatedBy(Di18nTranslation domain, String updator) {
            domain.setUpdatedBy(updator);
        }

        public String getCreatedDateColumnName() {
            return COLUMN_NAME_CREATEDDATE;
        }

        public Date getCreatedDate(Di18nTranslation domain) {
            if (null == domain) {
                return null;
            }
            return domain.getCreatedDate();
        }

        public void _setCreatedDate(Di18nTranslation domain, Date date) {
            domain.setCreatedDate(date);
        }

        public String getUpdatedDateColumnName() {
            return COLUMN_NAME_UPDATEDDATE;
        }

        public Date getUpdatedDate(Di18nTranslation domain) {
            if (null == domain) {
                return null;
            }
            return domain.getUpdatedDate();
        }

        public void _setUpdatedDate(Di18nTranslation domain, Date date) {
            domain.setUpdatedDate(date);
        }

	// ----------------------- field finders -------------------------------
	/**
         * {@inheritDoc}
	 */
	public final Iterable<Di18nTranslation> queryByCreatedBy(java.lang.String createdBy) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_CREATEDBY, createdBy);
            return queryIterable(false, 0, -1, null, null, null, false, null, false, filter);
	}
	
	/**
	 * query-key-by method for attribute field createdBy
	 * @param createdBy the specified attribute
	 * @return an Iterable of keys to the Di18nTranslations with the specified attribute
	 */
	public final Iterable<java.lang.String> queryKeysByCreatedBy(java.lang.String createdBy) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_CREATEDBY, createdBy);
            return queryIterableKeys(0, -1, null, null, null, false, null, false, filter);
	}

	/**
	 * query-page-by method for field createdBy
	 * @param createdBy the specified attribute
         * @param pageSize the number of domain entities in the page
         * @param cursorString non-null if get next page
	 * @return a Page of Di18nTranslations for the specified createdBy
	 */
	public final CursorPage<Di18nTranslation, java.lang.String> queryPageByCreatedBy(java.lang.String createdBy,
            int pageSize, Serializable cursorString) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_CREATEDBY, createdBy);
            return queryPage(false, pageSize, null, null, null, false, null, false, cursorString, filter);
        }

	 
	/**
         * {@inheritDoc}
	 */
	public final Iterable<Di18nTranslation> queryByCreatedDate(java.util.Date createdDate) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_CREATEDDATE, createdDate);
            return queryIterable(false, 0, -1, null, null, null, false, null, false, filter);
	}
	
	/**
	 * query-key-by method for attribute field createdDate
	 * @param createdDate the specified attribute
	 * @return an Iterable of keys to the Di18nTranslations with the specified attribute
	 */
	public final Iterable<java.lang.String> queryKeysByCreatedDate(java.util.Date createdDate) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_CREATEDDATE, createdDate);
            return queryIterableKeys(0, -1, null, null, null, false, null, false, filter);
	}

	/**
	 * query-page-by method for field createdDate
	 * @param createdDate the specified attribute
         * @param pageSize the number of domain entities in the page
         * @param cursorString non-null if get next page
	 * @return a Page of Di18nTranslations for the specified createdDate
	 */
	public final CursorPage<Di18nTranslation, java.lang.String> queryPageByCreatedDate(java.util.Date createdDate,
            int pageSize, Serializable cursorString) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_CREATEDDATE, createdDate);
            return queryPage(false, pageSize, null, null, null, false, null, false, cursorString, filter);
        }

	 
	/**
         * {@inheritDoc}
	 */
	public final Iterable<Di18nTranslation> queryByLocalizedImage(java.lang.String localizedImage) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_LOCALIZEDIMAGE, localizedImage);
            return queryIterable(false, 0, -1, null, null, null, false, null, false, filter);
	}
	
	/**
	 * query-key-by method for attribute field localizedImage
	 * @param localizedImage the specified attribute
	 * @return an Iterable of keys to the Di18nTranslations with the specified attribute
	 */
	public final Iterable<java.lang.String> queryKeysByLocalizedImage(java.lang.String localizedImage) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_LOCALIZEDIMAGE, localizedImage);
            return queryIterableKeys(0, -1, null, null, null, false, null, false, filter);
	}

	/**
	 * query-page-by method for field localizedImage
	 * @param localizedImage the specified attribute
         * @param pageSize the number of domain entities in the page
         * @param cursorString non-null if get next page
	 * @return a Page of Di18nTranslations for the specified localizedImage
	 */
	public final CursorPage<Di18nTranslation, java.lang.String> queryPageByLocalizedImage(java.lang.String localizedImage,
            int pageSize, Serializable cursorString) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_LOCALIZEDIMAGE, localizedImage);
            return queryPage(false, pageSize, null, null, null, false, null, false, cursorString, filter);
        }

	 
	/**
         * {@inheritDoc}
	 */
	public final Iterable<Di18nTranslation> queryByLocalizedString(java.lang.String localizedString) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_LOCALIZEDSTRING, localizedString);
            return queryIterable(false, 0, -1, null, null, null, false, null, false, filter);
	}
	
	/**
	 * query-key-by method for attribute field localizedString
	 * @param localizedString the specified attribute
	 * @return an Iterable of keys to the Di18nTranslations with the specified attribute
	 */
	public final Iterable<java.lang.String> queryKeysByLocalizedString(java.lang.String localizedString) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_LOCALIZEDSTRING, localizedString);
            return queryIterableKeys(0, -1, null, null, null, false, null, false, filter);
	}

	/**
	 * query-page-by method for field localizedString
	 * @param localizedString the specified attribute
         * @param pageSize the number of domain entities in the page
         * @param cursorString non-null if get next page
	 * @return a Page of Di18nTranslations for the specified localizedString
	 */
	public final CursorPage<Di18nTranslation, java.lang.String> queryPageByLocalizedString(java.lang.String localizedString,
            int pageSize, Serializable cursorString) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_LOCALIZEDSTRING, localizedString);
            return queryPage(false, pageSize, null, null, null, false, null, false, cursorString, filter);
        }

	 
	/**
         * {@inheritDoc}
	 */
	public final Iterable<Di18nTranslation> queryByLocalizedUrl(java.lang.String localizedUrl) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_LOCALIZEDURL, localizedUrl);
            return queryIterable(false, 0, -1, null, null, null, false, null, false, filter);
	}
	
	/**
	 * query-key-by method for attribute field localizedUrl
	 * @param localizedUrl the specified attribute
	 * @return an Iterable of keys to the Di18nTranslations with the specified attribute
	 */
	public final Iterable<java.lang.String> queryKeysByLocalizedUrl(java.lang.String localizedUrl) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_LOCALIZEDURL, localizedUrl);
            return queryIterableKeys(0, -1, null, null, null, false, null, false, filter);
	}

	/**
	 * query-page-by method for field localizedUrl
	 * @param localizedUrl the specified attribute
         * @param pageSize the number of domain entities in the page
         * @param cursorString non-null if get next page
	 * @return a Page of Di18nTranslations for the specified localizedUrl
	 */
	public final CursorPage<Di18nTranslation, java.lang.String> queryPageByLocalizedUrl(java.lang.String localizedUrl,
            int pageSize, Serializable cursorString) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_LOCALIZEDURL, localizedUrl);
            return queryPage(false, pageSize, null, null, null, false, null, false, cursorString, filter);
        }

	 
	/**
         * {@inheritDoc}
	 */
	public final Iterable<Di18nTranslation> queryByUpdatedBy(java.lang.String updatedBy) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_UPDATEDBY, updatedBy);
            return queryIterable(false, 0, -1, null, null, null, false, null, false, filter);
	}
	
	/**
	 * query-key-by method for attribute field updatedBy
	 * @param updatedBy the specified attribute
	 * @return an Iterable of keys to the Di18nTranslations with the specified attribute
	 */
	public final Iterable<java.lang.String> queryKeysByUpdatedBy(java.lang.String updatedBy) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_UPDATEDBY, updatedBy);
            return queryIterableKeys(0, -1, null, null, null, false, null, false, filter);
	}

	/**
	 * query-page-by method for field updatedBy
	 * @param updatedBy the specified attribute
         * @param pageSize the number of domain entities in the page
         * @param cursorString non-null if get next page
	 * @return a Page of Di18nTranslations for the specified updatedBy
	 */
	public final CursorPage<Di18nTranslation, java.lang.String> queryPageByUpdatedBy(java.lang.String updatedBy,
            int pageSize, Serializable cursorString) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_UPDATEDBY, updatedBy);
            return queryPage(false, pageSize, null, null, null, false, null, false, cursorString, filter);
        }

	 
	/**
         * {@inheritDoc}
	 */
	public final Iterable<Di18nTranslation> queryByUpdatedDate(java.util.Date updatedDate) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_UPDATEDDATE, updatedDate);
            return queryIterable(false, 0, -1, null, null, null, false, null, false, filter);
	}
	
	/**
	 * query-key-by method for attribute field updatedDate
	 * @param updatedDate the specified attribute
	 * @return an Iterable of keys to the Di18nTranslations with the specified attribute
	 */
	public final Iterable<java.lang.String> queryKeysByUpdatedDate(java.util.Date updatedDate) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_UPDATEDDATE, updatedDate);
            return queryIterableKeys(0, -1, null, null, null, false, null, false, filter);
	}

	/**
	 * query-page-by method for field updatedDate
	 * @param updatedDate the specified attribute
         * @param pageSize the number of domain entities in the page
         * @param cursorString non-null if get next page
	 * @return a Page of Di18nTranslations for the specified updatedDate
	 */
	public final CursorPage<Di18nTranslation, java.lang.String> queryPageByUpdatedDate(java.util.Date updatedDate,
            int pageSize, Serializable cursorString) {
            final Filter filter = createEqualsFilter(COLUMN_NAME_UPDATEDDATE, updatedDate);
            return queryPage(false, pageSize, null, null, null, false, null, false, cursorString, filter);
        }

	 
	// ----------------------- one-to-one finders -------------------------

	// ----------------------- many-to-one finders -------------------------

	// ----------------------- many-to-many finders -------------------------

	// ----------------------- uniqueFields finders -------------------------

	// ----------------------- populate / persist method -------------------------

	/**
	 * Persist an entity given all attributes
	 */
	public Di18nTranslation persist(Object parent,  	
		java.lang.String locale, 
		java.lang.String localizedImage, 
		java.lang.String localizedString, 
		java.lang.String localizedUrl) {

            Di18nTranslation domain = null;
            // if primaryKey specified, use it
            if (null != locale) {
                    domain = findByPrimaryKey(parent, locale);
            }
		
            // create new?
            if (null == domain) {
                    domain = new Di18nTranslation();
                    // set parent
                    domain.setParent((java.lang.Object) parent);
                    // generate Id?
                    if (null != locale) {
                            domain.setLocale(locale);
                    }
                    // fields
                    domain.setLocalizedImage(localizedImage);
                    domain.setLocalizedString(localizedString);
                    domain.setLocalizedUrl(localizedUrl);
                    // one-to-ones
                    // many-to-ones
			
                    persist(domain);
            }
            return domain;
	}



}
