/*
 * Decompiled with CFR 0.152.
 */
package com.wadpam.open.i18n.service;

import com.google.appengine.api.datastore.Key;
import com.wadpam.open.exceptions.NotFoundException;
import com.wadpam.open.i18n.dao.Di18nTranslationDao;
import com.wadpam.open.i18n.domain.Di18nTranslation;
import com.wadpam.open.transaction.Idempotent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class TranslationService {
    private static final Logger LOG = LoggerFactory.getLogger(TranslationService.class);
    public static final int ERR_TRANSLATION_SERVICE = 2000;
    private static final int ERR_NOT_FOUND = 2001;
    private Di18nTranslationDao i18nDao;

    @Transactional
    @Idempotent
    public Di18nTranslation addTranslation(Key parentKey, String locale, String localizedString, String localizedImageUrl, String localizedLinkUrl) {
        LOG.debug("Add new translation:{} for local:{}", (Object)localizedString, (Object)locale);
        Di18nTranslation di18n = new Di18nTranslation();
        di18n.setParent(parentKey);
        di18n.setLocale(locale);
        di18n.setLocalizedString(localizedString);
        di18n.setLocalizedImage(localizedImageUrl);
        di18n.setLocalizedUrl(localizedLinkUrl);
        this.i18nDao.persist((Object)di18n);
        return di18n;
    }

    public Di18nTranslation getTranslation(Key key) {
        LOG.debug("Get translation with id:{}", (Object)key);
        return (Di18nTranslation)((Object)this.i18nDao.findByPrimaryKey(key));
    }

    public Di18nTranslation getTranslation(Key parentKey, String locale) {
        LOG.debug("Get translation for locale:{} and parent:{}", (Object)locale, (Object)parentKey);
        return (Di18nTranslation)((Object)this.i18nDao.findByPrimaryKey(parentKey, (Serializable)((Object)locale)));
    }

    public Iterable<Di18nTranslation> getTranslations(Key parentKey) {
        LOG.debug("Get translations for parent:{}", (Object)parentKey);
        return this.i18nDao.queryAll(parentKey);
    }

    public Map<Key, Iterable<Di18nTranslation>> getTranslations(Collection<Key> parentKeys) {
        LOG.debug("Get translations for parents:{}", parentKeys);
        HashMap<Key, Iterable<Di18nTranslation>> resultMap = new HashMap<Key, Iterable<Di18nTranslation>>();
        for (Key parentKey : parentKeys) {
            Iterable<Di18nTranslation> di18nIterable = this.getTranslations(parentKey);
            if (null == di18nIterable) continue;
            resultMap.put(parentKey, di18nIterable);
        }
        return resultMap;
    }

    public Map<Key, Di18nTranslation> getTranslations(Collection<Key> parentKeys, String locale) {
        LOG.debug("Get translations for parents:{}", parentKeys);
        HashMap<Key, Di18nTranslation> resultMap = new HashMap<Key, Di18nTranslation>();
        for (Key parentKey : parentKeys) {
            Di18nTranslation di18nIterable = this.getTranslation(parentKey, locale);
            if (null == di18nIterable) continue;
            resultMap.put(parentKey, di18nIterable);
        }
        return resultMap;
    }

    @Transactional
    @Idempotent
    public Di18nTranslation deleteTranslation(Key key) {
        LOG.debug("Delete translation with id:{}", (Object)key);
        Di18nTranslation di18nTranslation = (Di18nTranslation)((Object)this.i18nDao.findByPrimaryKey(key));
        if (null == di18nTranslation) {
            throw new NotFoundException(2001, String.format("Localisation with key:%s not found during delete", key));
        }
        this.i18nDao.delete((Object)di18nTranslation);
        return di18nTranslation;
    }

    @Transactional
    @Idempotent
    public Di18nTranslation deleteTranslation(Key parentKey, String locale) {
        LOG.debug("Delete translation for locale:{} and parent:{}", (Object)locale, (Object)parentKey);
        Di18nTranslation di18nTranslation = this.getTranslation(parentKey, locale);
        if (null == di18nTranslation) {
            throw new NotFoundException(2001, String.format("Locale:%s for parent:%s not found during delete", parentKey, locale));
        }
        this.i18nDao.delete((Object)di18nTranslation);
        return di18nTranslation;
    }

    @Transactional
    @Idempotent
    public int deleteTranslationForParent(Key parentKey) {
        LOG.debug("Delete all translations for parent:{}", (Object)parentKey);
        Iterable<String> di18nIterable = this.i18nDao.queryKeysByParent(parentKey);
        if (null == di18nIterable) {
            throw new NotFoundException(2001, String.format("Parent:%s not found during delete", parentKey));
        }
        return this.i18nDao.delete(parentKey, di18nIterable);
    }

    public void setI18nDao(Di18nTranslationDao i18nDao) {
        this.i18nDao = i18nDao;
    }

    public Di18nTranslationDao getI18nDao() {
        return this.i18nDao;
    }
}

