/*
 * Decompiled with CFR 0.152.
 */
package com.wadpam.open.i18n.web;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.wadpam.docrest.domain.RestCode;
import com.wadpam.docrest.domain.RestReturn;
import com.wadpam.open.exceptions.NotFoundException;
import com.wadpam.open.exceptions.ServerErrorException;
import com.wadpam.open.i18n.domain.Di18nTranslation;
import com.wadpam.open.i18n.json.Ji18nTranslation;
import com.wadpam.open.i18n.service.TranslationService;
import com.wadpam.open.i18n.web.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"{domain}/i18n"})
@RestReturn(value=Ji18nTranslation.class)
public class I18nController {
    private static final Logger LOG = LoggerFactory.getLogger(I18nController.class);
    private static final int ERR_NOT_FOUND = 2100;
    private static final int ERR_BAD_REQUEST = 2102;
    private static final int ERR_SERVER_ERROR = 2103;
    private static final Converter CONVERTER = new Converter();
    private TranslationService translationService;

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @RestReturn(value=Ji18nTranslation.class, entity=Ji18nTranslation.class, code={@RestCode(code=302, message="OK", description="Redirect to newly created translation")})
    public RedirectView addTranslation(HttpServletRequest request, UriComponentsBuilder uriBuilder, @PathVariable String domain, @RequestParam(required=true) String parent, @RequestParam(required=true) String locale, @RequestParam(required=false) String string, @RequestParam(required=false) String imageUrl, @RequestParam(required=false) String linkUrl) {
        Key parentKey = KeyFactory.stringToKey((String)parent);
        Di18nTranslation body = this.translationService.addTranslation(parentKey, locale, string, imageUrl, linkUrl);
        if (null == body) {
            throw new ServerErrorException(2103, String.format("Failed to create new translation for locale:%s", locale));
        }
        Ji18nTranslation ji18nTranslation = CONVERTER.convert(body);
        return new RedirectView(uriBuilder.path("/{domain}/i18n/{id}").buildAndExpand(new Object[]{domain, ji18nTranslation.getId()}).toUriString());
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @RestReturn(value=Ji18nTranslation.class, entity=Ji18nTranslation.class, code={@RestCode(code=200, message="OK", description="Translation found"), @RestCode(code=404, message="NOK", description="Translations not found")})
    public ResponseEntity<Ji18nTranslation> getTranslation(HttpServletRequest request, @PathVariable String id) {
        try {
            Key key = KeyFactory.stringToKey((String)id);
            Di18nTranslation body = this.translationService.getTranslation(key);
            if (null == body) {
                throw new NotFoundException(2100, String.format("translation not found for id:%s", id));
            }
            return new ResponseEntity((Object)CONVERTER.convert(body), HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            throw new ServerErrorException(2100, String.format("translation not found for id:%s", id));
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"parent", "locale"})
    @RestReturn(value=Ji18nTranslation.class, entity=Ji18nTranslation.class, code={@RestCode(code=200, message="OK", description="Translation found"), @RestCode(code=404, message="NOK", description="Translations not found")})
    public ResponseEntity<Ji18nTranslation> getTranslation(HttpServletRequest request, @RequestParam(required=true) String parent, @RequestParam(required=true) String locale) {
        Key parentKey = KeyFactory.stringToKey((String)parent);
        Di18nTranslation body = this.translationService.getTranslation(parentKey, locale);
        if (null == body) {
            throw new NotFoundException(2100, String.format("Locale:%s for parent:%s not found", parentKey, locale));
        }
        return new ResponseEntity((Object)CONVERTER.convert(body), HttpStatus.OK);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"parent"})
    @RestReturn(value=Ji18nTranslation.class, entity=Ji18nTranslation.class, code={@RestCode(code=200, message="OK", description="Translation found")})
    public ResponseEntity<Collection<Ji18nTranslation>> getTranslationsForParent(HttpServletRequest request, @RequestParam(required=true) String parent) {
        try {
            Key parentKey = KeyFactory.stringToKey((String)parent);
            Iterable<Di18nTranslation> di18nTranslations = this.translationService.getTranslations(parentKey);
            return new ResponseEntity((Object)CONVERTER.convert(di18nTranslations), HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            throw new ServerErrorException(2103, e.getMessage());
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"parents"})
    @RestReturn(value=Map.class, entity=Map.class, code={@RestCode(code=200, message="OK", description="Translation found")})
    public ResponseEntity<Map<String, Collection<Ji18nTranslation>>> getTranslationsForParents(HttpServletRequest request, @RequestParam(required=true) String[] parents) {
        try {
            ArrayList<Key> parentKeys = new ArrayList<Key>(parents.length);
            for (String parentId : parents) {
                parentKeys.add(KeyFactory.stringToKey((String)parentId));
            }
            Map<Key, Iterable<Di18nTranslation>> di18nTranslations = this.translationService.getTranslations(parentKeys);
            HashMap<String, Collection> result = new HashMap<String, Collection>();
            for (Map.Entry<Key, Iterable<Di18nTranslation>> entry : di18nTranslations.entrySet()) {
                result.put(KeyFactory.keyToString((Key)entry.getKey()), CONVERTER.convert(entry.getValue()));
            }
            return new ResponseEntity(result, HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            throw new ServerErrorException(2103, e.getMessage());
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"parents", "locale"})
    @RestReturn(value=Di18nTranslation.class, entity=Di18nTranslation.class, code={@RestCode(code=200, message="OK", description="Translation found")})
    public ResponseEntity<Map<String, Ji18nTranslation>> getTranslationsForLocaleForParents(HttpServletRequest request, @RequestParam(required=true) String[] parents, @RequestParam(required=true) String locale) {
        try {
            ArrayList<Key> parentKeys = new ArrayList<Key>(parents.length);
            for (String parentId : parents) {
                parentKeys.add(KeyFactory.stringToKey((String)parentId));
            }
            Map<Key, Di18nTranslation> di18nTranslations = this.translationService.getTranslations(parentKeys, locale);
            HashMap<String, Ji18nTranslation> result = new HashMap<String, Ji18nTranslation>();
            for (Map.Entry<Key, Di18nTranslation> entry : di18nTranslations.entrySet()) {
                result.put(KeyFactory.keyToString((Key)entry.getKey()), CONVERTER.convert(entry.getValue()));
            }
            return new ResponseEntity(result, HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            throw new ServerErrorException(2103, e.getMessage());
        }
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @RestReturn(value=Ji18nTranslation.class, entity=Ji18nTranslation.class, code={@RestCode(code=200, message="OK", description="Translation deleted"), @RestCode(code=404, message="NOK", description="Translation not found")})
    public ResponseEntity<Ji18nTranslation> deleteTranslation(HttpServletRequest request, @PathVariable String id) {
        try {
            Key key = KeyFactory.stringToKey((String)id);
            Di18nTranslation body = this.translationService.deleteTranslation(key);
            return new ResponseEntity((Object)CONVERTER.convert(body), HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            throw new ServerErrorException(2103, e.getMessage());
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE}, params={"locale"})
    @RestReturn(value=Ji18nTranslation.class, entity=Ji18nTranslation.class, code={@RestCode(code=200, message="OK", description="Translation deleted"), @RestCode(code=404, message="NOK", description="Translation not found")})
    public ResponseEntity<Ji18nTranslation> deleteTranslation(HttpServletRequest request, @RequestParam(required=true) String parent, @RequestParam(required=true) String locale) {
        try {
            Key parentKey = KeyFactory.stringToKey((String)parent);
            Di18nTranslation body = this.translationService.deleteTranslation(parentKey, locale);
        }
        catch (IllegalArgumentException e) {
            throw new ServerErrorException(2103, e.getMessage());
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE}, params={"parent"})
    @RestReturn(value=Ji18nTranslation.class, entity=Ji18nTranslation.class, code={@RestCode(code=200, message="OK", description="Translation deleted"), @RestCode(code=404, message="NOK", description="Translations not found")})
    public ResponseEntity<Collection<Ji18nTranslation>> deleteTranslationsForParent(HttpServletRequest request, @RequestParam(required=true) String parent) {
        try {
            Key parentKey = KeyFactory.stringToKey((String)parent);
            int result = this.translationService.deleteTranslationForParent(parentKey);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            throw new ServerErrorException(2103, e.getMessage());
        }
    }

    public void setTranslationService(TranslationService translationService) {
        this.translationService = translationService;
        CONVERTER.setTranslationDao(translationService.getI18nDao());
    }
}

