/*
 * Decompiled with CFR 0.152.
 */
package com.wadpam.open.security;

import com.wadpam.open.security.SecurityInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RolesInterceptor
extends HandlerInterceptorAdapter {
    static final Logger LOG = LoggerFactory.getLogger(RolesInterceptor.class);
    private final ArrayList<Map.Entry<Pattern, Set<String>>> RULED_METHODS = new ArrayList();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Object principal = request.getAttribute("com.wadpam.open.security.principal");
        if (null != principal) {
            String requestUri;
            Collection grantedRoles = (Collection)request.getAttribute("com.wadpam.open.security.roles");
            String method = SecurityInterceptor.getEffectiveMethod(request);
            boolean authorized = RolesInterceptor.isAuthorized(this.RULED_METHODS, method, requestUri = request.getRequestURI(), grantedRoles);
            if (authorized) {
                return true;
            }
        }
        response.sendError(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase());
        return false;
    }

    protected static boolean isAuthorized(ArrayList<Map.Entry<Pattern, Set<String>>> RULED_METHODS, String method, String requestUri, Collection<String> grantedRoles) {
        String methodPath = String.format("%s:%s", method, requestUri);
        LOG.debug("method:requestUri = {}, Granted Roles: {}", (Object)methodPath, grantedRoles);
        for (Map.Entry<Pattern, Set<String>> entry : RULED_METHODS) {
            Matcher matcher = entry.getKey().matcher(methodPath);
            boolean matches = matcher.find();
            LOG.debug("-   {} for {}", (Object)matches, (Object)entry.getKey());
            if (!matches) continue;
            Set<String> authorizedRoles = entry.getValue();
            LOG.debug("-   Authorized Roles: {}", authorizedRoles);
            boolean disjoint = Collections.disjoint(grantedRoles, authorizedRoles);
            if (disjoint) break;
            return true;
        }
        return false;
    }

    public void setRuledMethods(Collection<Map.Entry<String, Collection<String>>> ruledMethods) {
        SecurityInterceptor.setListedMethods(ruledMethods, this.RULED_METHODS);
    }
}

