/*
 * Decompiled with CFR 0.152.
 */
package com.wadpam.open.security;

import com.wadpam.open.exceptions.AuthenticationFailedException;
import com.wadpam.open.security.SecurityDetailsService;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SecurityInterceptor
extends HandlerInterceptorAdapter {
    protected static final Logger LOG = LoggerFactory.getLogger(SecurityInterceptor.class);
    protected static final int ERR_SECURITY_BASE = 77000;
    protected static final int ERR_CREDENTIALS_NOT_FOUND = 77001;
    protected static final int ERR_AUTHENTICATION_FAILED = 77002;
    public static final String AUTH_TYPE_BASIC = "Basic ";
    public static final String AUTH_TYPE_COOKIE = "Cookie ";
    public static final String AUTH_TYPE_OAUTH = "OAuth ";
    public static final String AUTH_PARAM_BASIC = "jBasic";
    public static final String AUTH_PARAM_COOKIE = "jCookie";
    public static final String AUTH_PARAM_OAUTH = "access_token";
    public static final String ATTR_NAME_USERNAME = "com.wadpam.open.security.username";
    public static final String ATTR_NAME_PRINCIPAL = "com.wadpam.open.security.principal";
    public static final String ATTR_NAME_ROLES = "com.wadpam.open.security.roles";
    public static final String ATTR_NAME_CONTAINER_ADMIN_NAME = "com.wadpam.open.security.ContainerAdminName";
    public static final String ATTR_NAME_CONTAINER_ADMIN_PRINCIPAL = "com.wadpam.open.security.ContainerAdminPrincipal";
    public static final String USERNAME_ANONYMOUS = "[ANONYMOUS]";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String PATH_AH = "/_ah/";
    public static final TreeSet<String> ROLES_ANONYMOUS = new TreeSet();
    private String authenticationMechanism = "Basic ";
    private String realmName = "open-server SecurityInterceptor";
    private SecurityDetailsService securityDetailsService;
    private final ArrayList<Map.Entry<Pattern, Set<String>>> WHITELISTED_METHODS = new ArrayList();

    protected String doAuthenticate(HttpServletRequest request, HttpServletResponse response, String uri, String authValue, String clientUsername, Object details) {
        String clientPass = this.getClientPassword(request, response, uri, authValue);
        String realmPass = this.getRealmPassword(details);
        boolean matches = realmPass.equals(clientPass);
        return matches ? this.getRealmUsername(clientUsername, details) : null;
    }

    protected String getAuthenticationParamName() {
        if (AUTH_TYPE_BASIC.equals(this.authenticationMechanism)) {
            return AUTH_PARAM_BASIC;
        }
        if (AUTH_TYPE_COOKIE.equals(this.authenticationMechanism)) {
            return AUTH_PARAM_COOKIE;
        }
        if (AUTH_TYPE_OAUTH.equals(this.authenticationMechanism)) {
            return AUTH_PARAM_OAUTH;
        }
        return null;
    }

    protected String getAuthenticationValue(HttpServletRequest request, HttpServletResponse response, String uri) {
        String value = null;
        String paramName = this.getAuthenticationParamName();
        value = request.getParameter(paramName);
        if (null == value) {
            Cookie[] cookies;
            String authorization = request.getHeader(HEADER_AUTHORIZATION);
            if (null != authorization && authorization.startsWith(this.authenticationMechanism)) {
                value = authorization.substring(this.authenticationMechanism.length());
            }
            if (null == value && null != (cookies = request.getCookies())) {
                for (Cookie cookie : cookies) {
                    if (!paramName.equals(cookie.getName())) continue;
                    value = cookie.getValue();
                }
            }
        }
        return value;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException, ServletException {
        String principalName;
        String uri = request.getRequestURI();
        String method = SecurityInterceptor.getEffectiveMethod(request);
        String authValue = this.getAuthenticationValue(request, response, uri);
        LOG.debug("authValue for {} is {}", (Object)this.getAuthenticationParamName(), (Object)authValue);
        if (null != authValue && AUTH_TYPE_BASIC.equals(this.authenticationMechanism)) {
            byte[] buf = Base64.decodeBase64((String)authValue);
            authValue = new String(buf);
        }
        if (null == (principalName = this.isAuthenticated(request, response, handler, uri, method, authValue)) && null != response && AUTH_TYPE_BASIC.equals(this.authenticationMechanism)) {
            response.setStatus(401);
            response.setHeader("WWW-Authenticate", String.format("Basic realm=\"%s\"", this.realmName));
        }
        return null != principalName;
    }

    public String isAuthenticated(HttpServletRequest request, HttpServletResponse response, Object handler, String uri, String method, String authValue) {
        LOG.debug("---- Authenticating using {} for {} {} ----", new Object[]{this.getAuthenticationMechanism(), method, uri});
        boolean skipPath = this.skipEnvironmentPaths(request, response, uri);
        LOG.debug("skipPath {}", (Object)skipPath);
        boolean whitelisted = this.isWhitelistedMethod(uri, method);
        LOG.debug("whitelisted {}", (Object)whitelisted);
        if (null == authValue) {
            return this.populateAnonymousUser(request, skipPath, whitelisted);
        }
        String username = this.getClientUsername(request, response, uri, authValue);
        LOG.debug("username {}", (Object)username);
        Object details = null;
        try {
            details = this.securityDetailsService.loadUserDetailsByUsername(request, response, uri, authValue, username);
        }
        catch (AuthenticationFailedException noSuchUser) {
            // empty catch block
        }
        LOG.debug("details {}", details);
        if (null == details) {
            return this.populateAnonymousUser(request, skipPath, whitelisted);
        }
        String principalName = this.doAuthenticate(request, response, uri, authValue, username, details);
        LOG.debug("principalName {}", (Object)principalName);
        if (null != principalName) {
            if (null != request) {
                request.setAttribute(ATTR_NAME_USERNAME, (Object)principalName);
                request.setAttribute(ATTR_NAME_PRINCIPAL, details);
                Collection<String> roles = this.securityDetailsService.getRolesFromUserDetails(details);
                TreeSet<String> combinedRoles = new TreeSet<String>(roles);
                Collection previousRoles = (Collection)request.getAttribute(ATTR_NAME_ROLES);
                if (null != previousRoles) {
                    combinedRoles.addAll(previousRoles);
                }
                if (null != request.getAttribute(ATTR_NAME_CONTAINER_ADMIN_NAME)) {
                    combinedRoles.add("ROLE_CONTAINER_ADMIN");
                }
                request.setAttribute(ATTR_NAME_ROLES, combinedRoles);
            }
            return principalName;
        }
        return this.populateAnonymousUser(request, skipPath, whitelisted);
    }

    protected String getClientUsername(HttpServletRequest request, HttpServletResponse response, String uri, String authValue) {
        String username = authValue;
        int endIndex = authValue.indexOf(58);
        if (-1 < endIndex && AUTH_TYPE_BASIC.equals(this.authenticationMechanism)) {
            username = authValue.substring(0, endIndex);
        }
        return username;
    }

    protected String getClientPassword(HttpServletRequest request, HttpServletResponse response, String uri, String authValue) {
        String password = authValue;
        int beginIndex = authValue.indexOf(58);
        if (-1 < beginIndex && AUTH_TYPE_BASIC.equals(this.authenticationMechanism)) {
            password = authValue.substring(beginIndex + 1);
        }
        return password;
    }

    protected String getRealmPassword(Object details) {
        if (null == details) {
            return null;
        }
        return details.toString();
    }

    protected String getRealmUsername(String clientUsername, Object details) {
        return clientUsername;
    }

    protected boolean skipEnvironmentPaths(HttpServletRequest request, HttpServletResponse response, String uri) {
        return null != uri && uri.startsWith(PATH_AH);
    }

    public String getAuthenticationMechanism() {
        return this.authenticationMechanism;
    }

    public void setAuthenticationMechanism(String authenticationMechanism) {
        this.authenticationMechanism = authenticationMechanism;
    }

    protected boolean isWhitelistedMethod(String requestURI, String method) {
        for (Map.Entry<Pattern, Set<String>> entry : this.WHITELISTED_METHODS) {
            Matcher matcher = entry.getKey().matcher(requestURI);
            if (!matcher.find()) continue;
            boolean returnValue = entry.getValue().contains(method);
            LOG.debug("{} whitelisted URI {} {}", new Object[]{returnValue, method, entry.getKey()});
            return returnValue;
        }
        return false;
    }

    public void setWhitelistedMethods(Collection<Map.Entry<String, Collection<String>>> whitelistedMethods) {
        SecurityInterceptor.setListedMethods(whitelistedMethods, this.WHITELISTED_METHODS);
    }

    public static void setListedMethods(Collection<Map.Entry<String, Collection<String>>> methods, List<Map.Entry<Pattern, Set<String>>> listedMethods) {
        listedMethods.clear();
        for (Map.Entry<String, Collection<String>> entry : methods) {
            AbstractMap.SimpleImmutableEntry<Pattern, TreeSet<String>> sie = new AbstractMap.SimpleImmutableEntry<Pattern, TreeSet<String>>(Pattern.compile(entry.getKey()), new TreeSet<String>(entry.getValue()));
            listedMethods.add(sie);
        }
    }

    public void setSecurityDetailsService(SecurityDetailsService securityDetailsService) {
        this.securityDetailsService = securityDetailsService;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    private String populateAnonymousUser(HttpServletRequest request, boolean skipPath, boolean whitelisted) {
        if (null != request && null != request.getAttribute(ATTR_NAME_CONTAINER_ADMIN_NAME)) {
            String adminName = (String)request.getAttribute(ATTR_NAME_CONTAINER_ADMIN_NAME);
            request.setAttribute(ATTR_NAME_USERNAME, (Object)adminName);
            request.setAttribute(ATTR_NAME_PRINCIPAL, request.getAttribute(ATTR_NAME_CONTAINER_ADMIN_PRINCIPAL));
            TreeSet<String> combinedRoles = new TreeSet<String>();
            Collection previousRoles = (Collection)request.getAttribute(ATTR_NAME_ROLES);
            if (null != previousRoles) {
                combinedRoles.addAll(previousRoles);
            }
            combinedRoles.add("ROLE_CONTAINER_ADMIN");
            request.setAttribute(ATTR_NAME_ROLES, combinedRoles);
            return adminName;
        }
        if (!skipPath || null != request) {
            // empty if block
        }
        if (whitelisted && null != request) {
            request.setAttribute(ATTR_NAME_USERNAME, (Object)USERNAME_ANONYMOUS);
            request.setAttribute(ATTR_NAME_PRINCIPAL, (Object)USERNAME_ANONYMOUS);
            TreeSet<String> combinedRoles = new TreeSet<String>();
            Collection previousRoles = (Collection)request.getAttribute(ATTR_NAME_ROLES);
            if (null != previousRoles) {
                combinedRoles.addAll(previousRoles);
            }
            combinedRoles.add("ROLE_ANONYMOUS");
            request.setAttribute(ATTR_NAME_ROLES, combinedRoles);
        }
        return skipPath || whitelisted ? USERNAME_ANONYMOUS : null;
    }

    protected static String getEffectiveMethod(HttpServletRequest request) {
        String method = request.getMethod();
        String _method = request.getParameter("_method");
        if ("GET".equals(method) && null != _method) {
            return _method.toUpperCase();
        }
        return method;
    }

    static {
        ROLES_ANONYMOUS.add("ROLE_ANONYMOUS");
    }
}

