/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import com.wallee.android.sdk.credentials.InvalidCredentialsException;
import com.wallee.android.sdk.util.Check;
import java.io.Serializable;

public final class Credentials
implements Serializable,
Parcelable {
    public static final long THRESHOLD = 120000L;
    private final String credentials;
    private final long transactionId;
    private final long spaceId;
    private final long timestamp;
    public static final Parcelable.Creator<Credentials> CREATOR = new Parcelable.Creator<Credentials>(){

        public Credentials createFromParcel(Parcel in) {
            return new Credentials(in);
        }

        public Credentials[] newArray(int size) {
            return new Credentials[size];
        }
    };

    public Credentials(String credentials) throws InvalidCredentialsException {
        Check.requireNonEmpty(credentials, "The credentials are required to create a new credentials object.");
        String[] props = credentials.trim().split("-");
        if (props.length < 3 || props[0].equals("") || props[1].equals("") || props[2].equals("")) {
            throw new InvalidCredentialsException("Wrong credentials format.");
        }
        this.spaceId = Long.parseLong(props[0]);
        this.transactionId = Long.parseLong(props[1]);
        if (this.spaceId < 0L || this.transactionId < 0L) {
            throw new InvalidCredentialsException("IDs can not be negative.");
        }
        this.timestamp = Long.parseLong(props[2]);
        if (this.timestamp < 0L) {
            throw new InvalidCredentialsException("Timestamps can not be negative.");
        }
        this.credentials = credentials.trim();
    }

    public String toString() {
        return this.credentials;
    }

    private Credentials(Parcel in) {
        this.credentials = in.readString();
        this.transactionId = in.readLong();
        this.spaceId = in.readLong();
        this.timestamp = in.readLong();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.credentials);
        dest.writeLong(this.transactionId);
        dest.writeLong(this.spaceId);
        dest.writeLong(this.timestamp);
    }

    public int describeContents() {
        return 0;
    }

    public boolean isValid() {
        long now = System.currentTimeMillis();
        return now + 120000L < this.timestamp;
    }

    public void checkCredentials(Credentials other) throws IllegalStateException {
        if (this.getTransactionId() != other.getTransactionId()) {
            throw new IllegalStateException("The provided credentials do not have the same transaction transactionId.");
        }
        if (this.getSpaceId() != other.getSpaceId()) {
            throw new IllegalStateException("The provided credentials do not have the same space transactionId.");
        }
    }

    public String getCredentials() {
        return this.credentials;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public long getSpaceId() {
        return this.spaceId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

