/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.credentials;

import com.wallee.android.sdk.credentials.Credentials;
import com.wallee.android.sdk.credentials.CredentialsFetcher;
import com.wallee.android.sdk.credentials.CredentialsStore;
import com.wallee.android.sdk.util.AsynchronousCallback;
import com.wallee.android.sdk.util.Check;

public final class CredentialsProvider {
    private final CredentialsStore store;
    private final CredentialsFetcher fetcher;
    private final Object lock = new Object();
    private volatile Credentials credentials = null;

    public CredentialsProvider(CredentialsStore store, CredentialsFetcher fetcher) {
        this.store = Check.requireNonNull(store, "The store is required.");
        this.fetcher = Check.requireNonNull(fetcher, "The fetcher is required.");
    }

    public void getCredentials(final AsynchronousCallback<Credentials> executor) {
        if (this.credentials == null) {
            this.credentials = this.store.getCredentials();
        }
        if (this.credentials == null || !this.credentials.isValid()) {
            this.fetcher.fetchCredentials(new AsynchronousCallback<Credentials>(){

                @Override
                public void process(Credentials parameter) {
                    Check.requireNonNull(parameter, "The fetcher " + CredentialsProvider.this.fetcher.getClass() + " provides an invalid credential object. It is null.");
                    if (!parameter.isValid()) {
                        throw new IllegalStateException("The fetcher " + CredentialsProvider.this.fetcher.getClass() + " provides an invalid credential object. It is already expired.");
                    }
                    CredentialsProvider.this.checkAndSet(parameter);
                    executor.process(CredentialsProvider.this.credentials);
                }
            });
        } else {
            executor.process(this.credentials);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndSet(Credentials parameter) {
        Object object = this.lock;
        synchronized (object) {
            if (this.credentials != null) {
                this.credentials.checkCredentials(parameter);
            }
            if (this.credentials == null || parameter.getTimestamp() > this.credentials.getTimestamp()) {
                this.credentials = parameter;
                this.store.updateCredentials(this.credentials);
            }
        }
    }
}

