/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.flow;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.android.volley.VolleyError;
import com.wallee.android.sdk.flow.CoordinatorCallback;
import com.wallee.android.sdk.flow.FlowAction;
import com.wallee.android.sdk.flow.FlowState;
import com.wallee.android.sdk.flow.FlowStateHandler;
import com.wallee.android.sdk.flow.config.FlowConfiguration;
import com.wallee.android.sdk.request.RequestCallback;
import com.wallee.android.sdk.request.model.transaction.Transaction;
import com.wallee.android.sdk.util.Check;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

final class AwaitingFinalStateHandler
implements FlowStateHandler {
    private static final String TAG = AwaitingFinalStateHandler.class.getSimpleName();
    private final FlowConfiguration configuration;
    private final Transaction transaction;
    private final CoordinatorCallback coordinatorCallback;
    private final Timer timer = new Timer();
    private final AtomicInteger counter = new AtomicInteger();
    private static final int INTERVAL = 2000;

    AwaitingFinalStateHandler(CoordinatorCallback coordinatorCallback, FlowConfiguration configuration, Transaction transaction) {
        this.configuration = Check.requireNonNull(configuration, "The configuration is required.");
        this.transaction = Check.requireNonNull(transaction, "The transaction is required.");
        this.coordinatorCallback = Check.requireNonNull(coordinatorCallback, "The coordinatorCallback is required.");
    }

    @Override
    public void initialize() {
        this.coordinatorCallback.ready();
        this.timer.schedule((TimerTask)new TransactionFetcherTask(this), 2000L);
    }

    @Override
    public View createView(ViewGroup container) {
        return this.configuration.getAwaitingFinalStateViewFactory().build(container, this.transaction);
    }

    @Override
    public boolean dryTriggerAction(FlowAction action, View currentView) {
        return false;
    }

    @Override
    public boolean triggerAction(FlowAction action, View currentView) {
        return false;
    }

    private static class TransactionFetcherTask
    extends TimerTask {
        private final AwaitingFinalStateHandler stateHandler;

        private TransactionFetcherTask(AwaitingFinalStateHandler stateHandler) {
            this.stateHandler = stateHandler;
            Log.i((String)TAG, (String)"Waiting for final result of the transaction.");
        }

        @Override
        public void run() {
            this.stateHandler.configuration.getWebServiceApiClient().readTransaction(new RequestCallback<Transaction>(){

                @Override
                public void onSuccess(Transaction object) {
                    if (object.isAwaitingFinalState()) {
                        TransactionFetcherTask.this.reschedule();
                    } else if (object.isFailed()) {
                        TransactionFetcherTask.this.stateHandler.coordinatorCallback.changeStateTo(FlowState.FAILURE, object);
                        Log.i((String)TAG, (String)"Finally received a final transaction state: The state is failed.");
                    } else if (object.isSuccessful()) {
                        TransactionFetcherTask.this.stateHandler.coordinatorCallback.changeStateTo(FlowState.SUCCESS, object);
                        Log.i((String)TAG, (String)"Finally received a final transaction state: The state is successful.");
                    }
                }

                public void onErrorResponse(VolleyError error) {
                    TransactionFetcherTask.this.reschedule();
                }
            });
        }

        private void reschedule() {
            int value = this.stateHandler.counter.incrementAndGet();
            long delay = (long)(2000.0 * Math.pow(2.0, value));
            this.stateHandler.timer.schedule((TimerTask)new TransactionFetcherTask(this.stateHandler), delay);
        }
    }
}

