/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.flow;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.wallee.android.sdk.R;
import com.wallee.android.sdk.flow.CoordinatorCallback;
import com.wallee.android.sdk.flow.FlowAction;
import com.wallee.android.sdk.flow.FlowState;
import com.wallee.android.sdk.flow.FlowStateHandler;
import com.wallee.android.sdk.flow.config.FlowConfiguration;
import com.wallee.android.sdk.util.Check;
import com.wallee.android.sdk.view.PersistableView;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowCoordinator {
    private static final String TAG = FlowCoordinator.class.getSimpleName();
    private static final String STATE_BUNDLE_KEY = FlowCoordinator.class.getCanonicalName() + "_state";
    private final FlowConfiguration configuration;
    private volatile View currentView;
    private final AtomicReference<ViewGroup> container = new AtomicReference();
    private final AtomicReference<FlowState> state = new AtomicReference();
    private View waitingView = null;
    private final Handler uiThreadHandler;
    private volatile StateChangeHandler stateChangeHandler;
    private final Object viewChangeLock = new Object();
    private volatile Parcelable stateArgument;

    public FlowCoordinator(FlowConfiguration configuration) {
        this.configuration = Check.requireNonNull(configuration, "The configuration is required.");
        this.state.set(FlowState.TOKEN_LOADING);
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
    }

    public boolean dryTriggerAction(FlowAction action) {
        StateChangeHandler handler = this.stateChangeHandler;
        View currentView = this.currentView;
        if (handler != null && currentView != null) {
            return handler.handler.dryTriggerAction(action, currentView);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerAction(FlowAction action) {
        if (this.stateChangeHandler != null) {
            Object object = this.viewChangeLock;
            synchronized (object) {
                if (this.stateChangeHandler != null) {
                    return this.stateChangeHandler.handler.triggerAction(action, this.currentView);
                }
            }
        }
        return false;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup parent, Bundle savedInstanceState) {
        ViewGroup container = (ViewGroup)inflater.inflate(R.layout.wallee_container, parent, false);
        if (this.container.compareAndSet(null, container)) {
            this.waitingView = inflater.inflate(R.layout.wallee_waiting_view, container, false);
            FlowStateHolder stateHolder = null;
            if (savedInstanceState != null && (stateHolder = (FlowStateHolder)savedInstanceState.getParcelable(STATE_BUNDLE_KEY)) == null) {
                Log.w((String)TAG, (String)"The state could not be properly restored.");
            }
            if (stateHolder == null) {
                stateHolder = new FlowStateHolder(FlowState.TOKEN_LOADING, null);
            }
            this.state.set(stateHolder.getState());
            this.stateChangeHandler = new StateChangeHandler(this, stateHolder.getState(), stateHolder.getStateArgument(), savedInstanceState);
            if (this.currentView instanceof PersistableView && savedInstanceState != null) {
                ((PersistableView)this.currentView).restoreViewState(savedInstanceState);
            }
        }
        return (View)this.container.get();
    }

    private void changeToView(final View view) {
        if (this.container.get() != null) {
            this.uiThreadHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (FlowCoordinator.this.container.get() != null) {
                        Object object = FlowCoordinator.this.viewChangeLock;
                        synchronized (object) {
                            if (FlowCoordinator.this.currentView != view) {
                                ((ViewGroup)FlowCoordinator.this.container.get()).removeAllViews();
                                ((ViewGroup)FlowCoordinator.this.container.get()).addView(view);
                                FlowCoordinator.this.currentView = view;
                            }
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSaveInstanceState(Bundle outState) {
        Object object = this.viewChangeLock;
        synchronized (object) {
            View view = this.currentView;
            outState.putParcelable(STATE_BUNDLE_KEY, (Parcelable)new FlowStateHolder(this.state.get(), this.stateArgument));
            StateChangeHandler handler = this.stateChangeHandler;
            if (handler != null) {
                handler.onSaveInstanceState(outState);
            }
            Log.i((String)TAG, (String)("The coordinator state has been saved: " + (Object)((Object)this.state.get())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object = this.viewChangeLock;
        synchronized (object) {
            this.container.set(null);
            this.currentView = null;
            this.state.set(null);
            this.stateChangeHandler = null;
            this.waitingView = null;
        }
    }

    static final class FlowStateHolder
    implements Parcelable {
        private final FlowState state;
        private final Parcelable stateArgument;
        public static final Parcelable.Creator<FlowStateHolder> CREATOR = new Parcelable.Creator<FlowStateHolder>(){

            public FlowStateHolder createFromParcel(Parcel in) {
                return new FlowStateHolder(in);
            }

            public FlowStateHolder[] newArray(int size) {
                return new FlowStateHolder[size];
            }
        };

        FlowStateHolder(FlowState state, Parcelable stateArgument) {
            this.state = state;
            this.stateArgument = stateArgument;
        }

        private FlowStateHolder(Parcel in) {
            this.state = (FlowState)((Object)in.readSerializable());
            this.stateArgument = in.readParcelable(Parcelable.class.getClassLoader());
        }

        public FlowState getState() {
            return this.state;
        }

        public Parcelable getStateArgument() {
            return this.stateArgument;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeSerializable((Serializable)((Object)this.state));
            dest.writeParcelable(this.stateArgument, flags);
        }
    }

    private static class StateChangeHandler
    implements CoordinatorCallback {
        private final FlowCoordinator coordinator;
        private final FlowState currentState;
        private volatile boolean stateChangeable = true;
        private final Parcelable stateArgument;
        private final FlowStateHandler handler;
        private final Object stateChangeLock = new Object();
        private final AtomicReference<View> handlerView = new AtomicReference();
        private final Bundle savedInstanceState;

        private StateChangeHandler(FlowCoordinator coordinator, FlowState targetState, Parcelable stateArgument, Bundle savedInstanceState) {
            this.savedInstanceState = savedInstanceState;
            this.coordinator = coordinator;
            this.currentState = targetState;
            this.stateArgument = stateArgument;
            this.coordinator.stateArgument = stateArgument;
            this.coordinator.changeToView(coordinator.waitingView);
            this.handler = targetState.createStateHandler(this, coordinator.configuration, this.stateArgument);
            this.handler.initialize();
            Log.d((String)TAG, (String)("StateChangeHandler initialized with: " + this.toString()));
        }

        private void onSaveInstanceState(Bundle outState) {
            View view = this.handlerView.get();
            if (view instanceof PersistableView) {
                ((PersistableView)view).saveViewState(outState);
            }
        }

        @Override
        public void waiting() {
            this.coordinator.uiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (StateChangeHandler.this.stateChangeable) {
                        StateChangeHandler.this.coordinator.changeToView(StateChangeHandler.this.coordinator.waitingView);
                    }
                }
            });
        }

        @Override
        public void ready() {
            this.coordinator.uiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (StateChangeHandler.this.stateChangeable) {
                        ViewGroup parent;
                        if (StateChangeHandler.this.handlerView.get() == null && (parent = (ViewGroup)StateChangeHandler.this.coordinator.container.get()) != null) {
                            View view = StateChangeHandler.this.handler.createView(parent);
                            if (view == null) {
                                throw new IllegalStateException("The state handler for the state " + (Object)((Object)StateChangeHandler.this.currentState) + " has set an null handlerView.");
                            }
                            if (StateChangeHandler.this.handlerView.compareAndSet(null, view) && StateChangeHandler.this.savedInstanceState != null && view instanceof PersistableView) {
                                ((PersistableView)view).restoreViewState(StateChangeHandler.this.savedInstanceState);
                            }
                        }
                        StateChangeHandler.this.coordinator.changeToView((View)StateChangeHandler.this.handlerView.get());
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void changeStateTo(FlowState targetState, Parcelable stateArgument) {
            if (this.handler == null) {
                throw new IllegalStateException("A state change can be initialized once the state handler has been invoked through the initialize method.");
            }
            if (this.stateChangeable) {
                Object object = this.stateChangeLock;
                synchronized (object) {
                    if (this.stateChangeable) {
                        if (!this.coordinator.state.compareAndSet(this.currentState, targetState)) throw new IllegalStateException("We expect that the state " + (Object)((Object)this.currentState) + " is set but the state " + this.coordinator.state.get() + " was set. We expect that the state is only changed by this method and as such somehow the state was changed from the outside.");
                        this.stateChangeable = false;
                        this.coordinator.stateChangeHandler = new StateChangeHandler(this.coordinator, targetState, stateArgument, null);
                    } else {
                        Log.i((String)TAG, (String)("The state change to " + (Object)((Object)targetState) + " was provided when the state control was already delegated to another uiThreadHandler."));
                    }
                    return;
                }
            } else {
                Log.i((String)TAG, (String)("The state change to " + (Object)((Object)targetState) + " was provided when the state control was already delegated to another uiThreadHandler."));
            }
        }

        public String toString() {
            return "StateChangeHandler{coordinator=" + this.coordinator + ", currentState=" + (Object)((Object)this.currentState) + ", stateChangeable=" + this.stateChangeable + ", stateArgument=" + this.stateArgument + ", handler=" + this.handler + ", stateChangeLock=" + this.stateChangeLock + ", handlerView=" + this.handlerView + '}';
        }
    }
}

