/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.flow;

import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.wallee.android.sdk.flow.CoordinatorCallback;
import com.wallee.android.sdk.flow.FlowAction;
import com.wallee.android.sdk.flow.FlowState;
import com.wallee.android.sdk.flow.FlowStateHandler;
import com.wallee.android.sdk.flow.config.FlowConfiguration;
import com.wallee.android.sdk.flow.listener.OnPaymentMethodSelectionViewReady;
import com.wallee.android.sdk.flow.model.LoadedPaymentMethods;
import com.wallee.android.sdk.flow.model.SelectedPaymentMethodConfiguration;
import com.wallee.android.sdk.request.model.method.PaymentMethodConfiguration;
import com.wallee.android.sdk.view.selection.method.PaymentMethodListViewFactory;
import java.util.List;

final class PaymentMethodSelectionStateHandler
implements FlowStateHandler,
PaymentMethodListViewFactory.PaymentMethodListViewListener {
    private static final String TAG = PaymentMethodSelectionStateHandler.class.getSimpleName();
    private final CoordinatorCallback stateSetter;
    private final FlowConfiguration configuration;
    private final LoadedPaymentMethods loadedPaymentMethods;

    PaymentMethodSelectionStateHandler(CoordinatorCallback stateSetter, FlowConfiguration configuration, Parcelable stateArgument) {
        this.stateSetter = stateSetter;
        this.configuration = configuration;
        if (!(stateArgument instanceof LoadedPaymentMethods)) {
            throw new IllegalArgumentException("The provided state argument has to be of the type: " + LoadedPaymentMethods.class);
        }
        this.loadedPaymentMethods = (LoadedPaymentMethods)stateArgument;
    }

    @Override
    public void initialize() {
        List<OnPaymentMethodSelectionViewReady> listeners = this.configuration.getListenersByType(OnPaymentMethodSelectionViewReady.class);
        for (OnPaymentMethodSelectionViewReady listener : listeners) {
            listener.onPaymentMethodSelectionViewReady();
        }
        this.stateSetter.ready();
    }

    @Override
    public View createView(ViewGroup container) {
        return this.configuration.getPaymentMethodListViewFactory().build(container, this, this.loadedPaymentMethods.getPaymentMethods(), this.loadedPaymentMethods.getIcons());
    }

    @Override
    public boolean dryTriggerAction(FlowAction action, View currentView) {
        return action == FlowAction.GO_BACK;
    }

    @Override
    public boolean triggerAction(FlowAction action, View currentView) {
        if (this.dryTriggerAction(action, currentView)) {
            this.stateSetter.changeStateTo(FlowState.TOKEN_LOADING, null);
            return true;
        }
        return false;
    }

    @Override
    public void onPaymentMethodClicked(PaymentMethodConfiguration method) {
        Log.d((String)TAG, (String)("The payment method configuration with the ID " + method.getId() + " has been selected."));
        SelectedPaymentMethodConfiguration selectedConfiguration = new SelectedPaymentMethodConfiguration(method.getId());
        this.stateSetter.changeStateTo(FlowState.PAYMENT_FORM, selectedConfiguration);
    }
}

