/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.flow;

import android.view.View;
import android.view.ViewGroup;
import com.android.volley.VolleyError;
import com.wallee.android.sdk.flow.CoordinatorCallback;
import com.wallee.android.sdk.flow.ErrorHandler;
import com.wallee.android.sdk.flow.FlowAction;
import com.wallee.android.sdk.flow.FlowState;
import com.wallee.android.sdk.flow.FlowStateHandler;
import com.wallee.android.sdk.flow.config.FlowConfiguration;
import com.wallee.android.sdk.flow.listener.OnBeforeLoadingTokenListener;
import com.wallee.android.sdk.flow.model.LoadedTokens;
import com.wallee.android.sdk.request.RequestCallback;
import com.wallee.android.sdk.request.model.method.PaymentMethodConfiguration;
import com.wallee.android.sdk.request.model.method.PaymentMethodIcon;
import com.wallee.android.sdk.request.model.token.TokenVersion;
import com.wallee.android.sdk.util.AsynchronousCallback;
import com.wallee.android.sdk.util.Check;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

final class TokenLoadingStateHandler
implements FlowStateHandler {
    private static final String TAG = TokenLoadingStateHandler.class.getSimpleName();
    private final CoordinatorCallback coordinatorCallback;
    private final FlowConfiguration configuration;

    @Override
    public boolean triggerAction(FlowAction action, View currentView) {
        return false;
    }

    @Override
    public boolean dryTriggerAction(FlowAction action, View currentView) {
        return false;
    }

    TokenLoadingStateHandler(CoordinatorCallback coordinatorCallback, FlowConfiguration configuration) {
        this.coordinatorCallback = Check.requireNonNull(coordinatorCallback, "The coordinatorCallback is required.");
        this.configuration = Check.requireNonNull(configuration, "The configuration is required.");
    }

    @Override
    public void initialize() {
        for (OnBeforeLoadingTokenListener listener : this.configuration.getListenersByType(OnBeforeLoadingTokenListener.class)) {
            listener.onBeforeLoadingToken();
        }
        this.configuration.getWebServiceApiClient().fetchTokenVersions(new RequestCallback<List<TokenVersion>>(){

            @Override
            public void onSuccess(final List<TokenVersion> tokenVersionList) {
                if (tokenVersionList.size() == 0) {
                    TokenLoadingStateHandler.this.coordinatorCallback.changeStateTo(FlowState.PAYMENT_METHOD_LOADING, null);
                } else {
                    HashSet<PaymentMethodConfiguration> paymentMethodConfigurations = new HashSet<PaymentMethodConfiguration>();
                    for (TokenVersion version : tokenVersionList) {
                        paymentMethodConfigurations.add(version.getPaymentConnectorConfiguration().getPaymentMethodConfiguration());
                    }
                    TokenLoadingStateHandler.this.configuration.getIconCache().fetchIcons(paymentMethodConfigurations, new AsynchronousCallback<Map<PaymentMethodConfiguration, PaymentMethodIcon>>(){

                        @Override
                        public void process(Map<PaymentMethodConfiguration, PaymentMethodIcon> parameter) {
                            LoadedTokens loadedTokens = new LoadedTokens(tokenVersionList, parameter);
                            TokenLoadingStateHandler.this.coordinatorCallback.changeStateTo(FlowState.TOKEN_SELECTION, loadedTokens);
                        }
                    });
                }
            }

            public void onErrorResponse(VolleyError error) {
                ErrorHandler.distributeVolleyError(error, TokenLoadingStateHandler.this.configuration);
            }
        });
    }

    @Override
    public View createView(ViewGroup container) {
        throw new IllegalStateException("This method should not be called in State " + this.getClass().getCanonicalName());
    }
}

