/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.flow.config;

import android.content.Context;
import com.android.volley.RequestQueue;
import com.wallee.android.sdk.credentials.CredentialsProvider;
import com.wallee.android.sdk.flow.config.VolleyRequestQueueHolder;
import com.wallee.android.sdk.flow.listener.FlowListener;
import com.wallee.android.sdk.request.api.VolleyWebServiceApiClient;
import com.wallee.android.sdk.request.api.WebServiceApiClient;
import com.wallee.android.sdk.request.icon.IconCache;
import com.wallee.android.sdk.request.icon.IconRequestManager;
import com.wallee.android.sdk.request.icon.InMemoryIconCache;
import com.wallee.android.sdk.request.icon.VolleyIconRequestManager;
import com.wallee.android.sdk.util.Check;
import com.wallee.android.sdk.view.awaiting.AwaitingFinalStateViewFactory;
import com.wallee.android.sdk.view.awaiting.DefaultAwaitingFinalStateViewFactory;
import com.wallee.android.sdk.view.failure.DefaultFailureViewFactory;
import com.wallee.android.sdk.view.failure.FailureViewFactory;
import com.wallee.android.sdk.view.form.DefaultPaymentFormViewFactory;
import com.wallee.android.sdk.view.form.PaymentFormViewFactory;
import com.wallee.android.sdk.view.selection.method.DefaultPaymentMethodListViewFactory;
import com.wallee.android.sdk.view.selection.method.PaymentMethodListViewFactory;
import com.wallee.android.sdk.view.selection.token.DefaultTokenListViewFactory;
import com.wallee.android.sdk.view.selection.token.TokenListViewFactory;
import com.wallee.android.sdk.view.success.DefaultSuccessViewFactory;
import com.wallee.android.sdk.view.success.SuccessViewFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class FlowConfiguration {
    private final PaymentFormViewFactory paymentFormViewFactory;
    private final TokenListViewFactory tokenListViewFactory;
    private final PaymentMethodListViewFactory paymentMethodListViewFactory;
    private final SuccessViewFactory successViewFactory;
    private final FailureViewFactory failureViewFactory;
    private final AwaitingFinalStateViewFactory awaitingFinalStateViewFactory;
    private final IconCache iconCache;
    private final List<? extends FlowListener> listeners;
    private final IconRequestManager iconRequestManager;
    private final WebServiceApiClient webServiceApiClient;

    public FlowConfiguration(PaymentFormViewFactory paymentFormViewFactory, TokenListViewFactory tokenListViewFactory, PaymentMethodListViewFactory paymentMethodListViewFactory, SuccessViewFactory successViewFactory, AwaitingFinalStateViewFactory awaitingFinalStateViewFactory, FailureViewFactory failureViewFactory, IconCache iconCache, List<? extends FlowListener> listeners, IconRequestManager iconRequestManager, WebServiceApiClient webServiceApiClient) {
        this.paymentFormViewFactory = Check.requireNonNull(paymentFormViewFactory, "The paymentFormViewFactory is required.");
        this.tokenListViewFactory = Check.requireNonNull(tokenListViewFactory, "The tokenListViewFactory is required.");
        this.paymentMethodListViewFactory = Check.requireNonNull(paymentMethodListViewFactory, "The paymentMethodListViewFactory is required.");
        this.successViewFactory = Check.requireNonNull(successViewFactory, "The successViewFactory is required.");
        this.iconCache = Check.requireNonNull(iconCache, "The iconCache is required.");
        this.listeners = Collections.unmodifiableList(new ArrayList(Check.requireNonNull(listeners, "The listeners is required.")));
        this.failureViewFactory = Check.requireNonNull(failureViewFactory, "The failureViewFactory is required.");
        this.awaitingFinalStateViewFactory = Check.requireNonNull(awaitingFinalStateViewFactory, "The awaitingFinalStateViewFactory is required.");
        this.iconRequestManager = Check.requireNonNull(iconRequestManager, "The iconRequestManager is required.");
        this.webServiceApiClient = Check.requireNonNull(webServiceApiClient, "The webServiceApiClient is required.");
    }

    public PaymentFormViewFactory getPaymentFormViewFactory() {
        return this.paymentFormViewFactory;
    }

    public TokenListViewFactory getTokenListViewFactory() {
        return this.tokenListViewFactory;
    }

    public PaymentMethodListViewFactory getPaymentMethodListViewFactory() {
        return this.paymentMethodListViewFactory;
    }

    public SuccessViewFactory getSuccessViewFactory() {
        return this.successViewFactory;
    }

    public IconCache getIconCache() {
        return this.iconCache;
    }

    public List<? extends FlowListener> getListeners() {
        return this.listeners;
    }

    public FailureViewFactory getFailureViewFactory() {
        return this.failureViewFactory;
    }

    public AwaitingFinalStateViewFactory getAwaitingFinalStateViewFactory() {
        return this.awaitingFinalStateViewFactory;
    }

    public IconRequestManager getIconRequestManager() {
        return this.iconRequestManager;
    }

    public WebServiceApiClient getWebServiceApiClient() {
        return this.webServiceApiClient;
    }

    public <L extends FlowListener> List<L> getListenersByType(Class<L> type) {
        ArrayList<L> result = new ArrayList<L>();
        for (FlowListener flowListener : this.getListeners()) {
            if (!type.isInstance(flowListener)) continue;
            result.add(type.cast(flowListener));
        }
        return Collections.unmodifiableList(result);
    }

    public static class Builder {
        private PaymentFormViewFactory paymentFormViewFactory = new DefaultPaymentFormViewFactory();
        private TokenListViewFactory tokenListViewFactory = new DefaultTokenListViewFactory();
        private PaymentMethodListViewFactory paymentMethodListViewFactory = new DefaultPaymentMethodListViewFactory();
        private SuccessViewFactory successViewFactory = new DefaultSuccessViewFactory();
        private FailureViewFactory failureViewFactory = new DefaultFailureViewFactory();
        private AwaitingFinalStateViewFactory awaitingFinalStateViewFactory = new DefaultAwaitingFinalStateViewFactory();
        private final List<FlowListener> listeners = new ArrayList<FlowListener>();
        private IconCache iconCache;
        private IconRequestManager iconRequestManager;
        private WebServiceApiClient webServiceApiClient;

        public static Builder minimal(CredentialsProvider credentialsProvider, Context context) {
            RequestQueue queue = VolleyRequestQueueHolder.getRequestQueue(context);
            return new Builder().setWebServiceApiClient(new VolleyWebServiceApiClient(queue, credentialsProvider)).setIconRequestManager(new VolleyIconRequestManager(queue)).setIconCache(new InMemoryIconCache(new VolleyIconRequestManager(queue), 10000L));
        }

        public Builder addListeners(FlowListener ... listeners) {
            return this.addListeners(Arrays.asList(listeners));
        }

        public Builder addListeners(Collection<FlowListener> listeners) {
            for (FlowListener listener : listeners) {
                this.listeners.add(listener);
            }
            return this;
        }

        public Builder setListeners(Collection<? extends FlowListener> listeners) {
            this.listeners.clear();
            for (FlowListener flowListener : listeners) {
                this.listeners.add(flowListener);
            }
            return this;
        }

        public Builder setIconCache(IconCache iconCache) {
            this.iconCache = iconCache;
            return this;
        }

        public Builder setIconRequestManager(IconRequestManager iconRequestManager) {
            this.iconRequestManager = iconRequestManager;
            return this;
        }

        public Builder setWebServiceApiClient(WebServiceApiClient webServiceApiClient) {
            this.webServiceApiClient = webServiceApiClient;
            return this;
        }

        public Builder setPaymentFormViewFactory(PaymentFormViewFactory paymentFormViewFactory) {
            this.paymentFormViewFactory = paymentFormViewFactory;
            return this;
        }

        public Builder setTokenListViewFactory(TokenListViewFactory tokenListViewFactory) {
            this.tokenListViewFactory = tokenListViewFactory;
            return this;
        }

        public Builder setPaymentMethodListViewFactory(PaymentMethodListViewFactory paymentMethodListViewFactory) {
            this.paymentMethodListViewFactory = paymentMethodListViewFactory;
            return this;
        }

        public Builder setSuccessViewFactory(SuccessViewFactory successViewFactory) {
            this.successViewFactory = successViewFactory;
            return this;
        }

        public Builder setFailureViewFactory(FailureViewFactory failureViewFactory) {
            this.failureViewFactory = failureViewFactory;
            return this;
        }

        public Builder setAwaitingFinalStateViewFactory(AwaitingFinalStateViewFactory awaitingFinalStateViewFactory) {
            this.awaitingFinalStateViewFactory = awaitingFinalStateViewFactory;
            return this;
        }

        public FlowConfiguration build() {
            return new FlowConfiguration(this.paymentFormViewFactory, this.tokenListViewFactory, this.paymentMethodListViewFactory, this.successViewFactory, this.awaitingFinalStateViewFactory, this.failureViewFactory, this.iconCache, this.listeners, this.iconRequestManager, this.webServiceApiClient);
        }
    }
}

