/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.fragment;

import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.volley.RequestQueue;
import com.wallee.android.sdk.R;
import com.wallee.android.sdk.credentials.CredentialsProvider;
import com.wallee.android.sdk.flow.FlowAction;
import com.wallee.android.sdk.flow.FlowCoordinator;
import com.wallee.android.sdk.flow.config.FlowConfiguration;
import com.wallee.android.sdk.flow.config.VolleyRequestQueueHolder;
import com.wallee.android.sdk.flow.listener.FlowListener;
import com.wallee.android.sdk.fragment.CredentialsProviderResolver;
import com.wallee.android.sdk.fragment.FragmentFlowListener;
import com.wallee.android.sdk.fragment.FragmentTerminationListener;
import com.wallee.android.sdk.fragment.HierarchicalPaymentContainerEnlarger;
import com.wallee.android.sdk.fragment.PaymentContainerEnlarger;
import com.wallee.android.sdk.request.api.VolleyWebServiceApiClient;
import com.wallee.android.sdk.request.icon.InMemoryIconCache;
import com.wallee.android.sdk.request.icon.VolleyIconRequestManager;

public abstract class AbstractPaymentFragment
extends Fragment {
    private FlowCoordinator flowCoordinator;

    public boolean onBackPressed() {
        if (this.flowCoordinator != null) {
            return this.flowCoordinator.triggerAction(FlowAction.GO_BACK);
        }
        return false;
    }

    protected abstract CredentialsProviderResolver getCredentialsProviderResolver();

    protected abstract FragmentTerminationListener getFragmentTerminationListener();

    @Nullable
    public final View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        ViewGroup fragmentView = (ViewGroup)inflater.inflate(R.layout.wallee_fragment, container, false);
        ViewGroup paymentFormContainer = (ViewGroup)fragmentView.findViewById(R.id.wallee_payment_form_container);
        FragmentTerminationListener fragmentTerminationListener = this.getFragmentTerminationListener();
        if (fragmentTerminationListener == null) {
            throw new IllegalStateException("The fragment termination listener cannot be null.");
        }
        PaymentContainerEnlarger enlarger = this.createPaymentContainerEnlarger(paymentFormContainer);
        FragmentFlowListener listener = this.createEventListener(enlarger, fragmentTerminationListener, fragmentView);
        if (listener == null) {
            throw new IllegalStateException("The listener cannot be null.");
        }
        FlowConfiguration configuration = this.createFlowConfigurationBuilder(listener).build();
        this.flowCoordinator = new FlowCoordinator(configuration);
        listener.setFlowCoordinator(this.flowCoordinator);
        View paymentPanel = this.flowCoordinator.onCreateView(inflater, paymentFormContainer, savedInstanceState);
        paymentFormContainer.removeAllViews();
        paymentFormContainer.addView(paymentPanel);
        return fragmentView;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.flowCoordinator != null) {
            this.flowCoordinator.onSaveInstanceState(outState);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.flowCoordinator != null) {
            this.flowCoordinator.onDestroy();
        }
    }

    protected FlowConfiguration.Builder createFlowConfigurationBuilder(FlowListener listener) {
        CredentialsProvider credentialsProvider = this.getCredentialsProviderResolver().resolveCredentialsProvider();
        if (credentialsProvider == null) {
            throw new IllegalStateException("The credentials provider cannot be null.");
        }
        RequestQueue queue = VolleyRequestQueueHolder.getRequestQueue((Context)this.getActivity().getApplication());
        return new FlowConfiguration.Builder().setWebServiceApiClient(new VolleyWebServiceApiClient(queue, credentialsProvider)).setIconRequestManager(new VolleyIconRequestManager(queue)).setIconCache(new InMemoryIconCache(new VolleyIconRequestManager(queue), 10000L)).addListeners(listener);
    }

    protected FragmentFlowListener createEventListener(PaymentContainerEnlarger enlarger, FragmentTerminationListener fragmentTerminationListener, ViewGroup fragmentView) {
        return new FragmentFlowListener<AbstractPaymentFragment>(this, enlarger, fragmentTerminationListener, fragmentView);
    }

    protected PaymentContainerEnlarger createPaymentContainerEnlarger(ViewGroup paymentFormContainer) {
        return new HierarchicalPaymentContainerEnlarger((View)paymentFormContainer, this.getActivity());
    }
}

