/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.fragment;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.android.volley.VolleyError;
import com.wallee.android.sdk.R;
import com.wallee.android.sdk.flow.FlowAction;
import com.wallee.android.sdk.flow.FlowCoordinator;
import com.wallee.android.sdk.flow.listener.OnBeforeLoadingPaymentMethodListener;
import com.wallee.android.sdk.flow.listener.OnErrorListener;
import com.wallee.android.sdk.flow.listener.OnPaymentContainerResizeListener;
import com.wallee.android.sdk.flow.listener.OnPaymentFormValidationListener;
import com.wallee.android.sdk.flow.listener.OnPaymentFormViewReadyListener;
import com.wallee.android.sdk.flow.listener.OnTokenSelectedListener;
import com.wallee.android.sdk.flow.listener.OnTokenSelectionViewReady;
import com.wallee.android.sdk.flow.listener.OnTransactionFailureListener;
import com.wallee.android.sdk.flow.listener.OnTransactionSuccessListener;
import com.wallee.android.sdk.fragment.AbstractPaymentFragment;
import com.wallee.android.sdk.fragment.FragmentTerminationListener;
import com.wallee.android.sdk.fragment.PaymentContainerEnlarger;
import com.wallee.android.sdk.request.model.base.ClientError;
import com.wallee.android.sdk.request.model.base.ClientErrorType;
import com.wallee.android.sdk.request.model.base.FailureReason;
import com.wallee.android.sdk.request.model.base.ServerError;
import com.wallee.android.sdk.request.model.token.TokenVersion;
import com.wallee.android.sdk.request.model.transaction.Transaction;
import com.wallee.android.sdk.util.Check;
import com.wallee.android.sdk.util.HttpError;
import java.util.List;

public class FragmentFlowListener<T extends AbstractPaymentFragment>
implements OnTokenSelectionViewReady,
OnErrorListener,
OnPaymentFormValidationListener,
OnPaymentFormViewReadyListener,
OnPaymentContainerResizeListener,
OnTransactionSuccessListener,
OnTransactionFailureListener,
OnTokenSelectedListener,
OnBeforeLoadingPaymentMethodListener {
    private static final String TAG = FragmentFlowListener.class.getSimpleName();
    private final T fragment;
    private final PaymentContainerEnlarger enlarger;
    private final FragmentTerminationListener fragmentTerminationListener;
    private final ViewGroup fragmentView;
    private FlowCoordinator coordinator;
    private final Button formSubmitButton;
    private final Button otherPaymentMethodButton;

    protected FragmentFlowListener(T fragment, PaymentContainerEnlarger enlarger, FragmentTerminationListener fragmentTerminationListener, ViewGroup fragmentView) {
        this.fragment = (AbstractPaymentFragment)((Object)Check.requireNonNull(fragment, "The fragment is required."));
        this.enlarger = Check.requireNonNull(enlarger, "The enlarger is required.");
        this.fragmentTerminationListener = Check.requireNonNull(fragmentTerminationListener, "The fragment termination listener is required.");
        this.fragmentView = Check.requireNonNull(fragmentView, "The fragment view cannot be empty.");
        this.formSubmitButton = this.setupFormSubmitButton();
        this.otherPaymentMethodButton = this.setupOtherPaymentMethodButton();
    }

    public final void setFlowCoordinator(FlowCoordinator coordinator) {
        if (this.coordinator != null) {
            throw new IllegalStateException("Once the coordinator has been set it cannot be set again.");
        }
        this.coordinator = coordinator;
    }

    protected T getFragment() {
        return this.fragment;
    }

    protected PaymentContainerEnlarger getPaymentContainerEnlarger() {
        return this.enlarger;
    }

    protected Context getContext() {
        return this.fragment.getActivity().getApplicationContext();
    }

    protected void runOnUiThread(Runnable task) {
        this.fragment.getActivity().runOnUiThread(task);
    }

    protected final Button getFormSubmitButton() {
        return this.formSubmitButton;
    }

    protected final Button getOtherPaymentMethodButton() {
        return this.otherPaymentMethodButton;
    }

    protected ViewGroup getFragmentView() {
        return this.fragmentView;
    }

    protected Button setupFormSubmitButton() {
        final Button button = (Button)this.getFragmentView().findViewById(R.id.wallee_button_submit_payment_form);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                button.setVisibility(8);
                if (!FragmentFlowListener.this.coordinator.triggerAction(FlowAction.VALIDATE_PAYMENT_FORM)) {
                    button.setVisibility(0);
                }
            }
        });
        return button;
    }

    protected Button setupOtherPaymentMethodButton() {
        final Button button = (Button)this.getFragmentView().findViewById(R.id.wallee_button_other_payment_method);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                button.setVisibility(8);
                if (!FragmentFlowListener.this.coordinator.triggerAction(FlowAction.SWITCH_TO_PAYMENT_METHOD_SELECTION)) {
                    button.setVisibility(0);
                }
            }
        });
        return button;
    }

    @Override
    public void onValidationFailure(List<String> errors) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FragmentFlowListener.this.getFormSubmitButton().setVisibility(0);
            }
        });
    }

    @Override
    public void onValidationSuccess() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!FragmentFlowListener.this.coordinator.triggerAction(FlowAction.SUBMIT_PAYMENT_FORM)) {
                    FragmentFlowListener.this.getFormSubmitButton().setVisibility(0);
                }
            }
        });
    }

    @Override
    public void onNetworkError(VolleyError error) {
        Log.e((String)TAG, (String)"Unexpected network error occurred.", (Throwable)error);
        this.fragmentTerminationListener.onFailureTermination(this.getContext().getString(R.string.wallee_unexpected_error), null);
    }

    @Override
    public void onClientError(ClientError error) {
        if (error.getType() == ClientErrorType.END_USER_ERROR) {
            Log.i((String)TAG, (String)("User error occurred. UUID: " + error.getId() + " Message: " + error.getDefaultMessage()));
            this.fragmentTerminationListener.onFailureTermination(error.getMessage(), null);
        } else {
            Log.e((String)TAG, (String)("Unexpected server error occurred. UUID for support: " + error.getId() + " Date: " + error.getDate() + " Message: " + error.getMessage()));
            this.fragmentTerminationListener.onFailureTermination(this.getContext().getString(R.string.wallee_unexpected_error), null);
        }
    }

    @Override
    public void onServerError(ServerError error) {
        Log.e((String)TAG, (String)("Unexpected server error occurred. UUID for support: " + error.getId() + " Date: " + error.getDate() + " Message: " + error.getMessage()));
        this.fragmentTerminationListener.onFailureTermination(this.getContext().getString(R.string.wallee_unexpected_error), null);
    }

    @Override
    public void onTokenSelectionViewReady() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FragmentFlowListener.this.getOtherPaymentMethodButton().setVisibility(0);
            }
        });
    }

    @Override
    public void onPaymentFormViewReady(boolean userInputRequired) {
        if (userInputRequired) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    FragmentFlowListener.this.getFormSubmitButton().setVisibility(0);
                }
            });
        } else if (!this.coordinator.triggerAction(FlowAction.SUBMIT_PAYMENT_FORM)) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    FragmentFlowListener.this.getFormSubmitButton().setVisibility(0);
                }
            });
        }
    }

    @Override
    public void onHttpError(HttpError error) {
        Log.e((String)TAG, (String)("Unexpected HTTP error: " + error.getHttpStatusCode() + " " + error.getMessage()), (Throwable)error);
        this.fragmentTerminationListener.onFailureTermination(this.getContext().getString(R.string.wallee_unexpected_error), null);
    }

    @Override
    public void onPaymentContainerEnlarge() {
        this.enlarger.enlarge();
    }

    @Override
    public void onPaymentContainerReduce() {
        this.enlarger.restore();
    }

    @Override
    public void onTransactionSuccess(Transaction transaction) {
        this.fragmentTerminationListener.onSuccessfulTermination(transaction);
    }

    @Override
    public void onTransactionFailure(Transaction transaction, FailureReason failureReason, String userFailureMessage) {
        Log.i((String)TAG, (String)("The transaction failed. Failure ID: " + failureReason.getId() + " Message: " + failureReason.getDescription()));
        this.fragmentTerminationListener.onFailureTermination(userFailureMessage, transaction);
    }

    @Override
    public void onTokenSelected(TokenVersion selectedTokenVersion) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FragmentFlowListener.this.getOtherPaymentMethodButton().setVisibility(8);
            }
        });
    }

    @Override
    public void onBeforeLoadingPaymentMethod() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FragmentFlowListener.this.getFormSubmitButton().setVisibility(8);
            }
        });
    }
}

