/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.fragment;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.wallee.android.sdk.fragment.PaymentContainerEnlarger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class HierarchicalPaymentContainerEnlarger
implements PaymentContainerEnlarger {
    private final View viewToEnlarge;
    private final View container;
    private final Object lock = new Object();
    private final Set<View> keepingViews = new HashSet<View>();
    private final Map<View, Integer> viewVisibilities = new HashMap<View, Integer>();
    private final Map<View, LayoutSizeParams> enlargedViewLayoutParameters = new HashMap<View, LayoutSizeParams>();
    private volatile boolean expanded = false;
    private final Handler uiThreadHandler;

    public HierarchicalPaymentContainerEnlarger(View viewToEnlarge, Activity activity) {
        this(viewToEnlarge, ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0));
    }

    public HierarchicalPaymentContainerEnlarger(View viewToEnlarge, View container) {
        this.viewToEnlarge = viewToEnlarge;
        this.container = container;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void enlarge() {
        this.uiThreadHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!HierarchicalPaymentContainerEnlarger.this.expanded) {
                    Object object = HierarchicalPaymentContainerEnlarger.this.lock;
                    synchronized (object) {
                        if (!HierarchicalPaymentContainerEnlarger.this.expanded) {
                            HierarchicalPaymentContainerEnlarger.this.expandOneLevel(HierarchicalPaymentContainerEnlarger.this.viewToEnlarge);
                            HierarchicalPaymentContainerEnlarger.this.expanded = true;
                        }
                    }
                }
            }
        });
    }

    @Override
    public void restore() {
        this.uiThreadHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (HierarchicalPaymentContainerEnlarger.this.expanded) {
                    Object object = HierarchicalPaymentContainerEnlarger.this.lock;
                    synchronized (object) {
                        if (HierarchicalPaymentContainerEnlarger.this.expanded) {
                            HierarchicalPaymentContainerEnlarger.this.runRestore();
                        }
                    }
                }
            }
        });
    }

    private void expandOneLevel(View view) {
        if (view != this.container) {
            this.keepingViews.add(view);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            this.enlargedViewLayoutParameters.put(view, new LayoutSizeParams(params));
            params.height = -1;
            params.width = -1;
            view.setLayoutParams(params);
            ViewParent parent = view.getParent();
            if (parent instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)parent;
                for (int i = 0; i < group.getChildCount(); ++i) {
                    View child = group.getChildAt(i);
                    if (this.keepingViews.contains(child) || child.getVisibility() == 8) continue;
                    this.viewVisibilities.put(child, child.getVisibility());
                    child.setVisibility(8);
                }
                this.expandOneLevel((View)group);
            }
        }
    }

    private void runRestore() {
        for (View view : this.keepingViews) {
            LayoutSizeParams storedParams = this.enlargedViewLayoutParameters.get(view);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            storedParams.applyOn(params);
            view.setLayoutParams(params);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup group = (ViewGroup)view;
            for (int i = 0; i < group.getChildCount(); ++i) {
                View child = group.getChildAt(i);
                Integer targetVisibility = this.viewVisibilities.get(child);
                if (targetVisibility == null) continue;
                if (targetVisibility == 8) {
                    child.setVisibility(8);
                    continue;
                }
                if (targetVisibility == 0) {
                    child.setVisibility(0);
                    continue;
                }
                if (targetVisibility != 4) continue;
                child.setVisibility(4);
            }
        }
        this.expanded = false;
    }

    private static class LayoutSizeParams {
        private final int width;
        private final int height;

        private LayoutSizeParams(ViewGroup.LayoutParams params) {
            this.width = params.width;
            this.height = params.height;
        }

        private LayoutSizeParams(int width, int height) {
            this.width = width;
            this.height = height;
        }

        private void applyOn(ViewGroup.LayoutParams params) {
            params.height = this.height;
            params.width = this.width;
        }
    }
}

