/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.request.api;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.toolbox.JsonArrayRequest;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wallee.android.sdk.credentials.Credentials;
import com.wallee.android.sdk.credentials.CredentialsProvider;
import com.wallee.android.sdk.request.RequestCallback;
import com.wallee.android.sdk.request.api.WebServiceApiClient;
import com.wallee.android.sdk.request.model.method.PaymentMethodConfiguration;
import com.wallee.android.sdk.request.model.token.Token;
import com.wallee.android.sdk.request.model.token.TokenVersion;
import com.wallee.android.sdk.request.model.transaction.MobileSdkUrl;
import com.wallee.android.sdk.request.model.transaction.Transaction;
import com.wallee.android.sdk.util.AsynchronousCallback;
import com.wallee.android.sdk.util.Check;
import java.lang.reflect.Type;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class VolleyWebServiceApiClient
implements WebServiceApiClient {
    public static final String DEFAULT_BASE_URL = "https://app-wallee.com/api/";
    private final RequestQueue requestQueue;
    private final CredentialsProvider credentialsProvider;
    private final String baseUrl;

    public VolleyWebServiceApiClient(RequestQueue requestQueue, CredentialsProvider credentialsProvider) {
        this(requestQueue, credentialsProvider, DEFAULT_BASE_URL);
    }

    public VolleyWebServiceApiClient(RequestQueue requestQueue, CredentialsProvider credentialsProvider, String baseUrl) {
        Check.requireNonEmpty(baseUrl, "The base url is required.");
        baseUrl = baseUrl.trim();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        baseUrl = baseUrl + "/";
        this.requestQueue = Check.requireNonNull(requestQueue, "The request queue is required.");
        this.baseUrl = baseUrl;
        this.credentialsProvider = Check.requireNonNull(credentialsProvider, "The credentialsProvider is required.");
    }

    @Override
    public void fetchTokenVersions(final RequestCallback<List<TokenVersion>> callback) {
        AsynchronousCallback<Credentials> credentialsRequestCallback = new AsynchronousCallback<Credentials>(){

            @Override
            public void process(Credentials parameter) {
                String url = VolleyWebServiceApiClient.this.baseUrl + "transaction/fetchOneClickTokensWithCredentials?credentials=" + parameter.getCredentials();
                Response.Listener<JSONArray> handler = new Response.Listener<JSONArray>(){

                    public void onResponse(JSONArray response) {
                        Gson gson = new Gson();
                        Type listType = new TypeToken<List<TokenVersion>>(){}.getType();
                        List tokenVersions = (List)gson.fromJson(response.toString(), listType);
                        callback.onSuccess(tokenVersions);
                    }
                };
                JsonArrayRequest request = new JsonArrayRequest(0, url, null, (Response.Listener)handler, (Response.ErrorListener)callback);
                VolleyWebServiceApiClient.this.requestQueue.add((Request)request);
            }
        };
        this.credentialsProvider.getCredentials(credentialsRequestCallback);
    }

    @Override
    public void buildMobileSdkUrl(final RequestCallback<MobileSdkUrl> callback) {
        AsynchronousCallback<Credentials> credentialsRequestCallback = new AsynchronousCallback<Credentials>(){

            @Override
            public void process(Credentials parameter) {
                String url = VolleyWebServiceApiClient.this.baseUrl + "transaction/buildMobileSdkUrlWithCredentials?credentials=" + parameter.getCredentials();
                Response.Listener<String> handler = new Response.Listener<String>(){

                    public void onResponse(String response) {
                        long expiryDate = System.currentTimeMillis() + 900000L;
                        MobileSdkUrl mobileSdkUrl = new MobileSdkUrl(response, expiryDate);
                        callback.onSuccess(mobileSdkUrl);
                    }
                };
                StringRequest request = new StringRequest(url, (Response.Listener)handler, (Response.ErrorListener)callback);
                VolleyWebServiceApiClient.this.requestQueue.add((Request)request);
            }
        };
        this.credentialsProvider.getCredentials(credentialsRequestCallback);
    }

    @Override
    public void fetchPaymentMethodConfigurations(final RequestCallback<List<PaymentMethodConfiguration>> callback) {
        AsynchronousCallback<Credentials> credentialsRequestCallback = new AsynchronousCallback<Credentials>(){

            @Override
            public void process(Credentials parameter) {
                String url = VolleyWebServiceApiClient.this.baseUrl + "transaction/fetchPossiblePaymentMethodsWithCredentials?credentials=" + parameter.getCredentials();
                Response.Listener<JSONArray> handler = new Response.Listener<JSONArray>(){

                    public void onResponse(JSONArray response) {
                        Gson gson = new Gson();
                        Type listType = new TypeToken<List<PaymentMethodConfiguration>>(){}.getType();
                        List paymentMethods = (List)gson.fromJson(response.toString(), listType);
                        callback.onSuccess(paymentMethods);
                    }
                };
                JsonArrayRequest request = new JsonArrayRequest(0, url, null, (Response.Listener)handler, (Response.ErrorListener)callback);
                VolleyWebServiceApiClient.this.requestQueue.add((Request)request);
            }
        };
        this.credentialsProvider.getCredentials(credentialsRequestCallback);
    }

    @Override
    public void readTransaction(final RequestCallback<Transaction> callback) {
        AsynchronousCallback<Credentials> credentialsRequestCallback = new AsynchronousCallback<Credentials>(){

            @Override
            public void process(Credentials parameter) {
                String url = VolleyWebServiceApiClient.this.baseUrl + "transaction/readWithCredentials?credentials=" + parameter.getCredentials();
                Response.Listener<JSONObject> handler = new Response.Listener<JSONObject>(){

                    public void onResponse(JSONObject response) {
                        Gson gson = new Gson();
                        Transaction transaction = (Transaction)gson.fromJson(response.toString(), Transaction.class);
                        callback.onSuccess(transaction);
                    }
                };
                JsonObjectRequest request = new JsonObjectRequest(0, url, null, (Response.Listener)handler, (Response.ErrorListener)callback);
                VolleyWebServiceApiClient.this.requestQueue.add((Request)request);
            }
        };
        this.credentialsProvider.getCredentials(credentialsRequestCallback);
    }

    @Override
    public void processOneClickToken(final Token token, final RequestCallback<Transaction> callback) {
        AsynchronousCallback<Credentials> credentialsRequestCallback = new AsynchronousCallback<Credentials>(){

            @Override
            public void process(Credentials parameter) {
                String url = VolleyWebServiceApiClient.this.baseUrl + "transaction/processOneClickTokenWithCredentials?credentials=" + parameter.getCredentials() + "&tokenId=" + token.getId();
                Response.Listener<JSONObject> handler = new Response.Listener<JSONObject>(){

                    public void onResponse(JSONObject response) {
                        Gson gson = new Gson();
                        Transaction transaction = (Transaction)gson.fromJson(response.toString(), Transaction.class);
                        callback.onSuccess(transaction);
                    }
                };
                JsonObjectRequest request = new JsonObjectRequest(1, url, null, (Response.Listener)handler, (Response.ErrorListener)callback);
                VolleyWebServiceApiClient.this.requestQueue.add((Request)request);
            }
        };
        this.credentialsProvider.getCredentials(credentialsRequestCallback);
    }
}

