/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.request.icon;

import android.util.Log;
import com.android.volley.VolleyError;
import com.wallee.android.sdk.request.RequestCallback;
import com.wallee.android.sdk.request.icon.IconCache;
import com.wallee.android.sdk.request.model.method.PaymentMethodConfiguration;
import com.wallee.android.sdk.request.model.method.PaymentMethodIcon;
import com.wallee.android.sdk.util.AsynchronousCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractIconCache
implements IconCache {
    private static final String TAG = AbstractIconCache.class.getSimpleName();
    private final Timer timer = new Timer();
    private final long timeout;
    private final ConcurrentMap<CacheKey, DelegateRequestCallback> currentCallbacks = new ConcurrentHashMap<CacheKey, DelegateRequestCallback>();

    protected AbstractIconCache(long timeout) {
        this.timeout = timeout;
    }

    protected abstract void lookupInRemoteServer(CacheKey var1, RequestCallback<PaymentMethodIcon> var2);

    protected abstract PaymentMethodIcon lookupInLocalCache(CacheKey var1);

    protected abstract void putInLocalCache(CacheKey var1, PaymentMethodIcon var2);

    @Override
    public void loadIcon(PaymentMethodConfiguration paymentMethodConfiguration, final RequestCallback<PaymentMethodIcon> callback) {
        final CacheKey cacheKey = new CacheKey(paymentMethodConfiguration);
        PaymentMethodIcon icon = this.lookupInLocalCache(cacheKey);
        if (icon == null) {
            DelegateRequestCallback existingCallback = (DelegateRequestCallback)this.currentCallbacks.get(cacheKey);
            boolean added = false;
            if (existingCallback != null && !existingCallback.invoked) {
                added = existingCallback.addCallback(callback);
            }
            if (!added) {
                RequestCallback<PaymentMethodIcon> wrapper = new RequestCallback<PaymentMethodIcon>(){

                    @Override
                    public void onSuccess(PaymentMethodIcon object) {
                        AbstractIconCache.this.putInLocalCache(cacheKey, object);
                        callback.onSuccess(AbstractIconCache.this.lookupInLocalCache(cacheKey));
                    }

                    public void onErrorResponse(VolleyError error) {
                        callback.onErrorResponse(error);
                    }
                };
                DelegateRequestCallback delegateRequestCallback = new DelegateRequestCallback(cacheKey, this.currentCallbacks);
                delegateRequestCallback.addCallback(wrapper);
                this.lookupInRemoteServer(cacheKey, delegateRequestCallback);
            }
        } else {
            callback.onSuccess(icon);
        }
    }

    @Override
    public final void fetchIcons(final Collection<PaymentMethodConfiguration> paymentMethodConfigurations, final AsynchronousCallback<Map<PaymentMethodConfiguration, PaymentMethodIcon>> callback) {
        final ConcurrentHashMap icons = new ConcurrentHashMap();
        final AtomicInteger numberOfIconsToLoad = new AtomicInteger(paymentMethodConfigurations.size());
        final AtomicBoolean callbackInvoked = new AtomicBoolean(false);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                HashMap<PaymentMethodConfiguration, PaymentMethodIcon> copy = new HashMap<PaymentMethodConfiguration, PaymentMethodIcon>(icons);
                for (PaymentMethodConfiguration method : paymentMethodConfigurations) {
                    PaymentMethodIcon fromLocalCache = AbstractIconCache.this.lookupInLocalCache(new CacheKey(method));
                    if (fromLocalCache == null) continue;
                    copy.put(method, fromLocalCache);
                }
                if (callbackInvoked.compareAndSet(false, true)) {
                    callback.process(Collections.unmodifiableMap(copy));
                }
            }
        };
        this.timer.schedule(timerTask, this.timeout);
        for (final PaymentMethodConfiguration method : paymentMethodConfigurations) {
            this.loadIcon(method, new RequestCallback<PaymentMethodIcon>(){

                @Override
                public void onSuccess(PaymentMethodIcon icon) {
                    icons.put(method, icon);
                    if (numberOfIconsToLoad.decrementAndGet() == 0 && callbackInvoked.compareAndSet(false, true)) {
                        callback.process(Collections.unmodifiableMap(new HashMap(icons)));
                    }
                }

                public void onErrorResponse(VolleyError error) {
                    Log.i((String)TAG, (String)("The loading of the image from the remote server failed. URL: " + method.getResolvedImageUrl()), (Throwable)error);
                }
            });
        }
    }

    private static class DelegateRequestCallback
    implements RequestCallback<PaymentMethodIcon> {
        private final Collection<RequestCallback<PaymentMethodIcon>> callbacks = new ArrayList<RequestCallback<PaymentMethodIcon>>();
        private final Object lock = new Object();
        private volatile boolean invoked = false;
        private final ConcurrentMap<CacheKey, DelegateRequestCallback> currentCallbacks;
        private final CacheKey cacheKey;

        private DelegateRequestCallback(CacheKey cacheKey, ConcurrentMap<CacheKey, DelegateRequestCallback> currentCallbacks) {
            this.cacheKey = cacheKey;
            this.currentCallbacks = currentCallbacks;
            currentCallbacks.put(cacheKey, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(PaymentMethodIcon object) {
            ArrayList<RequestCallback<PaymentMethodIcon>> copy;
            Iterator iterator = this.lock;
            synchronized (iterator) {
                copy = new ArrayList<RequestCallback<PaymentMethodIcon>>(this.callbacks);
                this.invoked = true;
                this.currentCallbacks.remove(this.cacheKey);
            }
            for (RequestCallback requestCallback : copy) {
                requestCallback.onSuccess(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onErrorResponse(VolleyError error) {
            ArrayList<RequestCallback<PaymentMethodIcon>> copy;
            Iterator iterator = this.lock;
            synchronized (iterator) {
                copy = new ArrayList<RequestCallback<PaymentMethodIcon>>(this.callbacks);
                this.invoked = true;
                this.currentCallbacks.remove(this.cacheKey);
            }
            for (RequestCallback requestCallback : copy) {
                requestCallback.onErrorResponse(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addCallback(RequestCallback<PaymentMethodIcon> callback) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.invoked) {
                    this.callbacks.add(callback);
                    return true;
                }
                return false;
            }
        }
    }

    protected static class CacheKey {
        private final PaymentMethodConfiguration method;
        private final int version;
        private final long id;

        private CacheKey(PaymentMethodConfiguration method) {
            this.method = method;
            this.version = method.getVersion();
            this.id = method.getId();
        }

        public PaymentMethodConfiguration getPaymentMethodConfiguration() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.version != cacheKey.version) {
                return false;
            }
            return this.id == cacheKey.id;
        }

        public int hashCode() {
            int result = this.version;
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            return result;
        }
    }
}

