/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.request.icon;

import com.wallee.android.sdk.request.RequestCallback;
import com.wallee.android.sdk.request.icon.AbstractIconCache;
import com.wallee.android.sdk.request.icon.IconCache;
import com.wallee.android.sdk.request.icon.IconRequestManager;
import com.wallee.android.sdk.request.model.method.PaymentMethodIcon;
import com.wallee.android.sdk.util.Check;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class InMemoryIconCache
extends AbstractIconCache
implements IconCache {
    private static final String TAG = InMemoryIconCache.class.getSimpleName();
    private static final ConcurrentMap<AbstractIconCache.CacheKey, PaymentMethodIcon> icons = new ConcurrentHashMap<AbstractIconCache.CacheKey, PaymentMethodIcon>();
    private final IconRequestManager iconRequestManager;

    public InMemoryIconCache(IconRequestManager iconRequestManager, long timeout) {
        super(timeout);
        this.iconRequestManager = Check.requireNonNull(iconRequestManager);
    }

    @Override
    protected PaymentMethodIcon lookupInLocalCache(AbstractIconCache.CacheKey cacheKey) {
        return (PaymentMethodIcon)icons.get(cacheKey);
    }

    @Override
    protected void lookupInRemoteServer(AbstractIconCache.CacheKey cacheKey, RequestCallback<PaymentMethodIcon> callback) {
        this.iconRequestManager.fetchIcon(cacheKey.getPaymentMethodConfiguration(), callback);
    }

    @Override
    protected void putInLocalCache(AbstractIconCache.CacheKey cacheKey, PaymentMethodIcon icon) {
        icons.putIfAbsent(cacheKey, icon);
    }
}

