/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.request.icon;

import android.util.Base64;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.wallee.android.sdk.request.RequestCallback;
import com.wallee.android.sdk.request.icon.IconRequestManager;
import com.wallee.android.sdk.request.model.method.PaymentMethodConfiguration;
import com.wallee.android.sdk.request.model.method.PaymentMethodIcon;
import com.wallee.android.sdk.util.Check;

public final class VolleyIconRequestManager
implements IconRequestManager {
    private final RequestQueue requestQueue;

    public VolleyIconRequestManager(RequestQueue requestQueue) {
        this.requestQueue = Check.requireNonNull(requestQueue);
    }

    @Override
    public void fetchIcon(PaymentMethodConfiguration paymentMethodConfiguration, RequestCallback<PaymentMethodIcon> callback) {
        this.fetchIcon(paymentMethodConfiguration.getResolvedImageUrl(), callback);
    }

    private void fetchIcon(String url, final RequestCallback<PaymentMethodIcon> callback) {
        Response.Listener<PaymentMethodIcon> imageListener = new Response.Listener<PaymentMethodIcon>(){

            public void onResponse(PaymentMethodIcon response) {
                callback.onSuccess(response);
            }
        };
        PaymentMethodIconRequest iconRequest = new PaymentMethodIconRequest(0, url, (Response.Listener)imageListener, callback);
        this.requestQueue.add((Request)iconRequest);
    }

    private static class PaymentMethodIconRequest
    extends Request<PaymentMethodIcon> {
        private final String CONTENT_TYPE = "content-type";
        private final Response.Listener<PaymentMethodIcon> listener;
        private final String url;

        private PaymentMethodIconRequest(int method, String url, Response.Listener<PaymentMethodIcon> responseListener, Response.ErrorListener errorListener) {
            super(method, url, errorListener);
            this.listener = responseListener;
            this.url = url;
        }

        protected Response<PaymentMethodIcon> parseNetworkResponse(NetworkResponse response) {
            try {
                String data = Base64.encodeToString((byte[])response.data, (int)2);
                PaymentMethodIcon paymentMethodIcon = new PaymentMethodIcon(this.url, data, this.extractMimeType(response));
                return Response.success((Object)paymentMethodIcon, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            }
            catch (Throwable e) {
                return Response.error((VolleyError)new ParseError(e));
            }
        }

        private String extractMimeType(NetworkResponse response) {
            for (String key : response.headers.keySet()) {
                if (!"content-type".equalsIgnoreCase(key)) continue;
                String mimeType = (String)response.headers.get(key);
                if (mimeType != null && !mimeType.isEmpty()) {
                    return mimeType;
                }
                throw new RuntimeException("Icon response does contain an invalid content type header.");
            }
            throw new RuntimeException("Icon response does not contain a content type header.");
        }

        protected void deliverResponse(PaymentMethodIcon response) {
            this.listener.onResponse((Object)response);
        }
    }
}

