/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.request.model.method;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.wallee.android.sdk.request.model.base.DatabaseTranslatedString;
import com.wallee.android.sdk.request.model.base.ImageResourcePath;
import com.wallee.android.sdk.request.model.method.DataCollectionType;
import com.wallee.android.sdk.request.model.method.OneClickPaymentMode;
import com.wallee.android.sdk.util.CompareUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PaymentMethodConfiguration
implements Comparable<PaymentMethodConfiguration>,
Parcelable {
    private DataCollectionType dataCollectionType;
    private DatabaseTranslatedString description;
    private long id;
    private ImageResourcePath imageResourcePath;
    private long linkedSpaceId;
    private String name;
    private OneClickPaymentMode oneClickPaymentMode;
    private long paymentMethod;
    private String plannedPurgeDate;
    private Map<String, String> resolvedDescription = new HashMap<String, String>();
    private String resolvedImageUrl;
    private Map<String, String> resolvedTitle = new HashMap<String, String>();
    private int sortOrder;
    private long spaceId;
    private DatabaseTranslatedString title;
    private int version;
    public static final Parcelable.Creator<PaymentMethodConfiguration> CREATOR = new Parcelable.Creator<PaymentMethodConfiguration>(){

        public PaymentMethodConfiguration createFromParcel(Parcel in) {
            return new PaymentMethodConfiguration(in);
        }

        public PaymentMethodConfiguration[] newArray(int size) {
            return new PaymentMethodConfiguration[size];
        }
    };

    protected PaymentMethodConfiguration(Parcel in) {
        this.dataCollectionType = (DataCollectionType)in.readParcelable(DataCollectionType.class.getClassLoader());
        this.description = (DatabaseTranslatedString)in.readParcelable(DatabaseTranslatedString.class.getClassLoader());
        this.id = in.readLong();
        this.imageResourcePath = (ImageResourcePath)in.readParcelable(ImageResourcePath.class.getClassLoader());
        this.linkedSpaceId = in.readLong();
        this.name = in.readString();
        this.oneClickPaymentMode = (OneClickPaymentMode)in.readParcelable(OneClickPaymentMode.class.getClassLoader());
        this.paymentMethod = in.readLong();
        this.plannedPurgeDate = in.readString();
        this.sortOrder = in.readInt();
        this.spaceId = in.readLong();
        this.title = (DatabaseTranslatedString)in.readParcelable(DatabaseTranslatedString.class.getClassLoader());
        this.version = in.readInt();
        int resolvedDescription = in.readInt();
        for (int i = 0; i < resolvedDescription; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.resolvedDescription.put(key, value);
        }
        int resolveTitleSize = in.readInt();
        for (int i = 0; i < resolveTitleSize; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.resolvedTitle.put(key, value);
        }
        this.resolvedImageUrl = in.readString();
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeParcelable((Parcelable)this.dataCollectionType, i);
        parcel.writeParcelable((Parcelable)this.description, i);
        parcel.writeLong(this.id);
        parcel.writeParcelable((Parcelable)this.imageResourcePath, i);
        parcel.writeLong(this.linkedSpaceId);
        parcel.writeString(this.name);
        parcel.writeParcelable((Parcelable)this.oneClickPaymentMode, i);
        parcel.writeLong(this.paymentMethod);
        parcel.writeString(this.plannedPurgeDate);
        parcel.writeInt(this.sortOrder);
        parcel.writeLong(this.spaceId);
        parcel.writeParcelable((Parcelable)this.title, i);
        parcel.writeInt(this.version);
        parcel.writeInt(this.resolvedDescription.size());
        for (Map.Entry<String, String> entry : this.resolvedDescription.entrySet()) {
            parcel.writeString(entry.getKey());
            parcel.writeString(entry.getValue());
        }
        parcel.writeInt(this.resolvedTitle.size());
        for (Map.Entry<String, String> entry : this.resolvedTitle.entrySet()) {
            parcel.writeString(entry.getKey());
            parcel.writeString(entry.getValue());
        }
        parcel.writeString(this.resolvedImageUrl);
    }

    public String getResolvedImageUrl() {
        return this.resolvedImageUrl;
    }

    @Override
    public int compareTo(@NonNull PaymentMethodConfiguration paymentMethodConfiguration) {
        int result = CompareUtil.compare(this.sortOrder, paymentMethodConfiguration.getSortOrder());
        if (result == 0) {
            return CompareUtil.compare(this.getId(), paymentMethodConfiguration.getId());
        }
        return result;
    }

    public DataCollectionType getDataCollectionType() {
        return this.dataCollectionType;
    }

    public DatabaseTranslatedString getDescription() {
        return this.description;
    }

    public long getId() {
        return this.id;
    }

    public ImageResourcePath getImageResourcePath() {
        return this.imageResourcePath;
    }

    public long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    public String getName() {
        return this.name;
    }

    public OneClickPaymentMode getOneClickPaymentMode() {
        return this.oneClickPaymentMode;
    }

    public long getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    public Map<String, String> getResolvedDescription() {
        return this.resolvedDescription;
    }

    public Map<String, String> getResolvedTitle() {
        return this.resolvedTitle;
    }

    public String getResolvedTitle(Locale locale) {
        String language = locale.getLanguage();
        String key = language + "-" + locale.getCountry();
        String rs = this.resolvedTitle.get(key);
        if (rs != null) {
            return rs;
        }
        for (Map.Entry<String, String> entry : this.resolvedTitle.entrySet()) {
            if (!entry.getKey().toLowerCase().startsWith(language)) continue;
            return entry.getValue();
        }
        return this.resolvedTitle.entrySet().iterator().next().getValue();
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public long getSpaceId() {
        return this.spaceId;
    }

    public DatabaseTranslatedString getTitle() {
        return this.title;
    }

    public int getVersion() {
        return this.version;
    }

    public int describeContents() {
        return 0;
    }
}

