/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.request.model.token;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.wallee.android.sdk.request.model.base.Label;
import com.wallee.android.sdk.request.model.method.ConnectorConfiguration;
import com.wallee.android.sdk.request.model.token.Token;
import com.wallee.android.sdk.request.model.token.TokenVersionState;
import com.wallee.android.sdk.request.model.transaction.Address;
import com.wallee.android.sdk.request.model.transaction.ChargeAttemptEnvironment;
import java.io.Serializable;
import java.util.List;

public class TokenVersion
implements Serializable,
Comparable<TokenVersion>,
Parcelable {
    private String activatedOn;
    private Address billingAddress;
    private String createdOn;
    private ChargeAttemptEnvironment environment;
    private long id;
    private List<Label> labels;
    private String language;
    private long linkedSpaceId;
    private String name;
    private String obsoletedOn;
    private ConnectorConfiguration paymentConnectorConfiguration;
    private String plannedPurgeDate;
    private String processorToken;
    private Address shippingAddress;
    private TokenVersionState state;
    private int version;
    private Token token;
    public static final Parcelable.Creator<TokenVersion> CREATOR = new Parcelable.Creator<TokenVersion>(){

        public TokenVersion createFromParcel(Parcel in) {
            return new TokenVersion(in);
        }

        public TokenVersion[] newArray(int size) {
            return new TokenVersion[size];
        }
    };

    protected TokenVersion(Parcel in) {
        this.activatedOn = in.readString();
        this.billingAddress = (Address)in.readParcelable(Address.class.getClassLoader());
        this.createdOn = in.readString();
        this.environment = (ChargeAttemptEnvironment)in.readParcelable(ChargeAttemptEnvironment.class.getClassLoader());
        this.id = in.readLong();
        this.labels = in.createTypedArrayList(Label.CREATOR);
        this.language = in.readString();
        this.linkedSpaceId = in.readLong();
        this.name = in.readString();
        this.obsoletedOn = in.readString();
        this.paymentConnectorConfiguration = (ConnectorConfiguration)in.readParcelable(ConnectorConfiguration.class.getClassLoader());
        this.plannedPurgeDate = in.readString();
        this.processorToken = in.readString();
        this.shippingAddress = (Address)in.readParcelable(Address.class.getClassLoader());
        this.state = (TokenVersionState)in.readParcelable(TokenVersionState.class.getClassLoader());
        this.version = in.readInt();
        this.token = (Token)in.readParcelable(Token.class.getClassLoader());
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public ConnectorConfiguration getPaymentConnectorConfiguration() {
        return this.paymentConnectorConfiguration;
    }

    public String getActivatedOn() {
        return this.activatedOn;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public ChargeAttemptEnvironment getEnvironment() {
        return this.environment;
    }

    public long getId() {
        return this.id;
    }

    public String getLanguage() {
        return this.language;
    }

    public long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    public String getName() {
        return this.name;
    }

    public String getObsoletedOn() {
        return this.obsoletedOn;
    }

    public String getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    public String getProcessorToken() {
        return this.processorToken;
    }

    public TokenVersionState getState() {
        return this.state;
    }

    public int getVersion() {
        return this.version;
    }

    public Token getToken() {
        return this.token;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @Override
    public int compareTo(@NonNull TokenVersion tokenVersion) {
        if (this.id < tokenVersion.getId()) {
            return -1;
        }
        if (this.id > tokenVersion.getId()) {
            return 1;
        }
        return 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.activatedOn);
        parcel.writeParcelable((Parcelable)this.billingAddress, i);
        parcel.writeString(this.createdOn);
        parcel.writeParcelable((Parcelable)this.environment, i);
        parcel.writeLong(this.id);
        parcel.writeTypedList(this.labels);
        parcel.writeString(this.language);
        parcel.writeLong(this.linkedSpaceId);
        parcel.writeString(this.name);
        parcel.writeString(this.obsoletedOn);
        parcel.writeParcelable((Parcelable)this.paymentConnectorConfiguration, i);
        parcel.writeString(this.plannedPurgeDate);
        parcel.writeString(this.processorToken);
        parcel.writeParcelable((Parcelable)this.shippingAddress, i);
        parcel.writeParcelable((Parcelable)this.state, i);
        parcel.writeInt(this.version);
        parcel.writeParcelable((Parcelable)this.token, i);
    }
}

