/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.request.model.transaction;

import android.os.Parcel;
import android.os.Parcelable;
import com.wallee.android.sdk.request.model.base.Tax;
import com.wallee.android.sdk.request.model.transaction.LineItemAttribute;
import com.wallee.android.sdk.request.model.transaction.LineItemType;
import com.wallee.android.sdk.util.ParcelableHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LineItem
implements Parcelable {
    private float aggregatedTaxRate;
    private float amountExcludingTax;
    private float amountIncludingTax;
    private Map<String, LineItemAttribute> attributes;
    private String name;
    private float quantity;
    private boolean shippingRequired;
    private String sku;
    private float taxAmount;
    private float taxAmountPerUnit;
    private List<Tax> taxes;
    private LineItemType type;
    private String uniqueId;
    private float unitPriceExcludingTax;
    private float unitPriceIncludingTax;
    public static final Parcelable.Creator<LineItem> CREATOR = new Parcelable.Creator<LineItem>(){

        public LineItem createFromParcel(Parcel in) {
            return new LineItem(in);
        }

        public LineItem[] newArray(int size) {
            return new LineItem[size];
        }
    };

    protected LineItem(Parcel in) {
        this.aggregatedTaxRate = in.readFloat();
        this.amountExcludingTax = in.readFloat();
        this.amountIncludingTax = in.readFloat();
        this.attributes = new HashMap<String, LineItemAttribute>();
        ParcelableHelper.readSerializableMap(in, this.attributes, String.class, LineItemAttribute.class);
        this.name = in.readString();
        this.quantity = in.readFloat();
        this.shippingRequired = in.readByte() != 0;
        this.sku = in.readString();
        this.taxAmount = in.readFloat();
        this.taxAmountPerUnit = in.readFloat();
        this.taxes = in.createTypedArrayList(Tax.CREATOR);
        this.taxes = new ArrayList<Tax>();
        in.readList(this.taxes, Tax.class.getClassLoader());
        this.type = (LineItemType)in.readParcelable(LineItemType.class.getClassLoader());
        this.uniqueId = in.readString();
        this.unitPriceExcludingTax = in.readFloat();
        this.unitPriceIncludingTax = in.readFloat();
    }

    public float getAggregatedTaxRate() {
        return this.aggregatedTaxRate;
    }

    public float getAmountExcludingTax() {
        return this.amountExcludingTax;
    }

    public float getAmountIncludingTax() {
        return this.amountIncludingTax;
    }

    public Map<String, LineItemAttribute> getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public float getQuantity() {
        return this.quantity;
    }

    public boolean isShippingRequired() {
        return this.shippingRequired;
    }

    public String getSku() {
        return this.sku;
    }

    public float getTaxAmount() {
        return this.taxAmount;
    }

    public float getTaxAmountPerUnit() {
        return this.taxAmountPerUnit;
    }

    public LineItemType getType() {
        return this.type;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public float getUnitPriceExcludingTax() {
        return this.unitPriceExcludingTax;
    }

    public float getUnitPriceIncludingTax() {
        return this.unitPriceIncludingTax;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeFloat(this.aggregatedTaxRate);
        parcel.writeFloat(this.amountExcludingTax);
        parcel.writeFloat(this.amountIncludingTax);
        ParcelableHelper.writeSerializableMap(parcel, this.attributes);
        parcel.writeString(this.name);
        parcel.writeFloat(this.quantity);
        parcel.writeByte((byte)(this.shippingRequired ? 1 : 0));
        parcel.writeString(this.sku);
        parcel.writeFloat(this.taxAmount);
        parcel.writeFloat(this.taxAmountPerUnit);
        parcel.writeTypedList(this.taxes);
        parcel.writeParcelable((Parcelable)this.type, i);
        parcel.writeString(this.uniqueId);
        parcel.writeFloat(this.unitPriceExcludingTax);
        parcel.writeFloat(this.unitPriceIncludingTax);
    }
}

