/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.request.model.transaction;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.wallee.android.sdk.util.Check;
import java.io.Serializable;

public final class MobileSdkUrl
implements Serializable,
Parcelable {
    public static final long EXPIRY_TIME_IN_MM = 900000L;
    public static final long EXPIRY_THRESHOLD = 120000L;
    private static final String PAYMENT_METHOD_QUERY_PARAM_NAME = "paymentMethodConfigurationId";
    private final String url;
    private final long expiryDate;
    public static final Parcelable.Creator<MobileSdkUrl> CREATOR = new Parcelable.Creator<MobileSdkUrl>(){

        public MobileSdkUrl createFromParcel(Parcel in) {
            return new MobileSdkUrl(in);
        }

        public MobileSdkUrl[] newArray(int size) {
            return new MobileSdkUrl[size];
        }
    };

    public MobileSdkUrl(String url, long expiryDate) {
        this.url = Check.requireNonEmpty(url, "The url is required.");
        this.expiryDate = expiryDate;
    }

    protected MobileSdkUrl(Parcel in) {
        this.url = in.readString();
        this.expiryDate = in.readLong();
    }

    public String getUrl() {
        return this.url;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiryDate - 120000L;
    }

    public Uri buildPaymentMethodUrl(long paymentMethodConfigurationId) {
        if (System.currentTimeMillis() > this.expiryDate) {
            throw new IllegalStateException("The URL is expired. It cannot be used anymore to create a payment method specific URL.");
        }
        return Uri.parse((String)this.url).buildUpon().appendQueryParameter(PAYMENT_METHOD_QUERY_PARAM_NAME, Long.toString(paymentMethodConfigurationId)).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.url);
        dest.writeLong(this.expiryDate);
    }
}

