/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.request.model.transaction;

import android.os.Parcel;
import android.os.Parcelable;
import com.wallee.android.sdk.request.model.base.FailureReason;
import com.wallee.android.sdk.request.model.method.ConnectorConfiguration;
import com.wallee.android.sdk.request.model.method.PaymentMethodBrand;
import com.wallee.android.sdk.request.model.token.Token;
import com.wallee.android.sdk.request.model.transaction.Address;
import com.wallee.android.sdk.request.model.transaction.CustomersPresence;
import com.wallee.android.sdk.request.model.transaction.LineItem;
import com.wallee.android.sdk.request.model.transaction.TransactionGroup;
import com.wallee.android.sdk.request.model.transaction.TransactionState;
import com.wallee.android.sdk.request.model.transaction.TransactionUserInterfaceType;
import com.wallee.android.sdk.util.ParcelableHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Transaction
implements Parcelable {
    private String acceptHeader;
    private List<PaymentMethodBrand> allowedPaymentMethodBrands;
    private List<Long> allowedPaymentMethodConfigurations;
    private float authorizationAmount;
    private String authorizedOn;
    private Address billingAddress;
    private boolean chargeRetryEnabled;
    private String completedOn;
    private String completionTimeoutOn;
    private long confirmedBy;
    private String confirmedOn;
    private long createdBy;
    private String createdOn;
    private String currency;
    private String customerEmailAddress;
    private String customerId;
    private CustomersPresence customersPresence;
    private String endOfLife;
    private String failedOn;
    private String failedUrl;
    private FailureReason failureReason;
    private TransactionGroup group;
    private long id;
    private String internetProtocolAddress;
    private String internetProtocolAddressCountry;
    private String invoiceMerchantReference;
    private String language;
    private List<LineItem> lineItems;
    private long linkedSpaceId;
    private String merchantReference;
    private Map<String, String> metaData;
    private ConnectorConfiguration paymentConnectorConfiguration;
    private String plannedPurgeDate;
    private String processingOn;
    private float refundedAmount;
    private Address shippingAddress;
    private String shippingMethod;
    private long spaceViewId;
    private TransactionState state;
    private String successUrl;
    private Token token;
    private String userAgentHeader;
    private String userFailureMessage;
    private TransactionUserInterfaceType userInterfaceType;
    private int version;
    public static final Parcelable.Creator<Transaction> CREATOR = new Parcelable.Creator<Transaction>(){

        public Transaction createFromParcel(Parcel in) {
            return new Transaction(in);
        }

        public Transaction[] newArray(int size) {
            return new Transaction[size];
        }
    };

    protected Transaction(Parcel in) {
        this.acceptHeader = in.readString();
        this.allowedPaymentMethodBrands = in.createTypedArrayList(PaymentMethodBrand.CREATOR);
        this.allowedPaymentMethodConfigurations = new ArrayList<Long>();
        in.readList(this.allowedPaymentMethodConfigurations, Long.class.getClassLoader());
        this.authorizationAmount = in.readFloat();
        this.authorizedOn = in.readString();
        this.billingAddress = (Address)in.readParcelable(Address.class.getClassLoader());
        this.chargeRetryEnabled = in.readByte() != 0;
        this.completedOn = in.readString();
        this.completionTimeoutOn = in.readString();
        this.confirmedBy = in.readLong();
        this.confirmedOn = in.readString();
        this.createdBy = in.readLong();
        this.createdOn = in.readString();
        this.currency = in.readString();
        this.customerEmailAddress = in.readString();
        this.customerId = in.readString();
        this.customersPresence = (CustomersPresence)in.readParcelable(CustomersPresence.class.getClassLoader());
        this.endOfLife = in.readString();
        this.failedOn = in.readString();
        this.failedUrl = in.readString();
        this.group = (TransactionGroup)in.readParcelable(TransactionGroup.class.getClassLoader());
        this.id = in.readLong();
        this.internetProtocolAddress = in.readString();
        this.internetProtocolAddressCountry = in.readString();
        this.invoiceMerchantReference = in.readString();
        this.language = in.readString();
        this.lineItems = in.createTypedArrayList(LineItem.CREATOR);
        this.linkedSpaceId = in.readLong();
        this.merchantReference = in.readString();
        this.metaData = new HashMap<String, String>();
        ParcelableHelper.readSerializableMap(in, this.metaData, String.class, String.class);
        this.paymentConnectorConfiguration = (ConnectorConfiguration)in.readParcelable(ConnectorConfiguration.class.getClassLoader());
        this.plannedPurgeDate = in.readString();
        this.processingOn = in.readString();
        this.refundedAmount = in.readFloat();
        this.shippingAddress = (Address)in.readParcelable(Address.class.getClassLoader());
        this.shippingMethod = in.readString();
        this.spaceViewId = in.readLong();
        this.state = (TransactionState)in.readParcelable(TransactionState.class.getClassLoader());
        this.successUrl = in.readString();
        this.token = (Token)in.readParcelable(Token.class.getClassLoader());
        this.userAgentHeader = in.readString();
        this.userInterfaceType = (TransactionUserInterfaceType)in.readParcelable(TransactionUserInterfaceType.class.getClassLoader());
        this.version = in.readInt();
    }

    public boolean isAwaitingFinalState() {
        return this.state == TransactionState.PENDING || this.state == TransactionState.PROCESSING || this.state == TransactionState.CONFIRMED;
    }

    public boolean isFailed() {
        return this.state == TransactionState.FAILED || this.state == TransactionState.DECLINE;
    }

    public boolean isSuccessful() {
        return this.state == TransactionState.AUTHORIZED || this.state == TransactionState.COMPLETED || this.state == TransactionState.FULFILL;
    }

    public String getAcceptHeader() {
        return this.acceptHeader;
    }

    public float getAuthorizationAmount() {
        return this.authorizationAmount;
    }

    public String getAuthorizedOn() {
        return this.authorizedOn;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public boolean isChargeRetryEnabled() {
        return this.chargeRetryEnabled;
    }

    public String getCompletedOn() {
        return this.completedOn;
    }

    public String getCompletionTimeoutOn() {
        return this.completionTimeoutOn;
    }

    public long getConfirmedBy() {
        return this.confirmedBy;
    }

    public String getConfirmedOn() {
        return this.confirmedOn;
    }

    public long getCreatedBy() {
        return this.createdBy;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getCustomerEmailAddress() {
        return this.customerEmailAddress;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public CustomersPresence getCustomersPresence() {
        return this.customersPresence;
    }

    public String getEndOfLife() {
        return this.endOfLife;
    }

    public String getFailedOn() {
        return this.failedOn;
    }

    public String getFailedUrl() {
        return this.failedUrl;
    }

    public long getId() {
        return this.id;
    }

    public String getInternetProtocolAddress() {
        return this.internetProtocolAddress;
    }

    public String getInternetProtocolAddressCountry() {
        return this.internetProtocolAddressCountry;
    }

    public String getInvoiceMerchantReference() {
        return this.invoiceMerchantReference;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    public String getMerchantReference() {
        return this.merchantReference;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public String getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    public String getProcessingOn() {
        return this.processingOn;
    }

    public float getRefundedAmount() {
        return this.refundedAmount;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public String getShippingMethod() {
        return this.shippingMethod;
    }

    public long getSpaceViewId() {
        return this.spaceViewId;
    }

    public TransactionState getState() {
        return this.state;
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public Token getToken() {
        return this.token;
    }

    public String getUserAgentHeader() {
        return this.userAgentHeader;
    }

    public List<PaymentMethodBrand> getAllowedPaymentMethodBrands() {
        return this.allowedPaymentMethodBrands;
    }

    public List<Long> getAllowedPaymentMethodConfigurations() {
        return this.allowedPaymentMethodConfigurations;
    }

    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    public TransactionGroup getGroup() {
        return this.group;
    }

    public ConnectorConfiguration getPaymentConnectorConfiguration() {
        return this.paymentConnectorConfiguration;
    }

    public String getUserFailureMessage() {
        return this.userFailureMessage;
    }

    public TransactionUserInterfaceType getUserInterfaceType() {
        return this.userInterfaceType;
    }

    public int getVersion() {
        return this.version;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.acceptHeader);
        parcel.writeTypedList(this.allowedPaymentMethodBrands);
        parcel.writeList(this.allowedPaymentMethodConfigurations);
        parcel.writeFloat(this.authorizationAmount);
        parcel.writeString(this.authorizedOn);
        parcel.writeParcelable((Parcelable)this.billingAddress, i);
        parcel.writeByte((byte)(this.chargeRetryEnabled ? 1 : 0));
        parcel.writeString(this.completedOn);
        parcel.writeString(this.completionTimeoutOn);
        parcel.writeLong(this.confirmedBy);
        parcel.writeString(this.confirmedOn);
        parcel.writeLong(this.createdBy);
        parcel.writeString(this.createdOn);
        parcel.writeString(this.currency);
        parcel.writeString(this.customerEmailAddress);
        parcel.writeString(this.customerId);
        parcel.writeParcelable((Parcelable)this.customersPresence, i);
        parcel.writeString(this.endOfLife);
        parcel.writeString(this.failedOn);
        parcel.writeString(this.failedUrl);
        parcel.writeParcelable((Parcelable)this.group, i);
        parcel.writeLong(this.id);
        parcel.writeString(this.internetProtocolAddress);
        parcel.writeString(this.internetProtocolAddressCountry);
        parcel.writeString(this.invoiceMerchantReference);
        parcel.writeString(this.language);
        parcel.writeTypedList(this.lineItems);
        parcel.writeLong(this.linkedSpaceId);
        parcel.writeString(this.merchantReference);
        ParcelableHelper.writeSerializableMap(parcel, this.metaData);
        parcel.writeParcelable((Parcelable)this.paymentConnectorConfiguration, i);
        parcel.writeString(this.plannedPurgeDate);
        parcel.writeString(this.processingOn);
        parcel.writeFloat(this.refundedAmount);
        parcel.writeParcelable((Parcelable)this.shippingAddress, i);
        parcel.writeString(this.shippingMethod);
        parcel.writeLong(this.spaceViewId);
        parcel.writeParcelable((Parcelable)this.state, i);
        parcel.writeString(this.successUrl);
        parcel.writeParcelable((Parcelable)this.token, i);
        parcel.writeString(this.userAgentHeader);
        parcel.writeParcelable((Parcelable)this.userInterfaceType, i);
        parcel.writeInt(this.version);
    }
}

