/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.util;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.Map;

public final class ParcelableHelper {
    public static <K extends Serializable, V extends Serializable> void writeSerializableMap(Parcel parcel, Map<K, V> map) {
        parcel.writeInt(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            parcel.writeSerializable((Serializable)e.getKey());
            parcel.writeSerializable((Serializable)e.getValue());
        }
    }

    public static <K extends Serializable, V extends Serializable> void readSerializableMap(Parcel parcel, Map<K, V> map, Class<K> keyType, Class<V> valueType) {
        int size = parcel.readInt();
        for (int i = 0; i < size; ++i) {
            map.put(keyType.cast(parcel.readSerializable()), valueType.cast(parcel.readSerializable()));
        }
    }

    public static <K extends Parcelable, V extends Parcelable> void writeParcelableMap(Parcel parcel, Map<K, V> map, int flags) {
        parcel.writeInt(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            parcel.writeParcelable((Parcelable)e.getKey(), flags);
            parcel.writeParcelable((Parcelable)e.getValue(), flags);
        }
    }

    public static <K extends Parcelable, V extends Parcelable> void readParcelableMap(Parcel parcel, Map<K, V> map, Class<K> kClass, Class<V> vClass) {
        int size = parcel.readInt();
        for (int i = 0; i < size; ++i) {
            map.put(kClass.cast(parcel.readParcelable(kClass.getClassLoader())), vClass.cast(parcel.readParcelable(vClass.getClassLoader())));
        }
    }

    private ParcelableHelper() {
        throw new IllegalAccessError();
    }
}

