/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.view.form;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.wallee.android.sdk.request.model.transaction.MobileSdkUrl;
import com.wallee.android.sdk.util.AsynchronousCallback;
import com.wallee.android.sdk.util.Check;
import com.wallee.android.sdk.util.HttpError;
import com.wallee.android.sdk.util.MeasurementUnitUtil;
import com.wallee.android.sdk.view.form.PaymentFormView;
import com.wallee.android.sdk.view.form.PaymentFormViewFactory;
import com.wallee.android.sdk.view.form.PaymentFormWebViewClient;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultPaymentFormView
extends WebView
implements PaymentFormView {
    private static final String TAG = DefaultPaymentFormView.class.getSimpleName();
    private static final String PARCEABLE_IDENTIFIER = DefaultPaymentFormView.class.getCanonicalName();
    private final PaymentFormView.Listener<DefaultPaymentFormView> listener;
    private final PaymentFormViewFactory.UrlFetcher urlFetcher;
    private final AtomicBoolean submitted = new AtomicBoolean(false);
    private final AtomicBoolean executingValidation = new AtomicBoolean(false);
    private final AtomicReference<MobileSdkUrl> mobileSdkUrl = new AtomicReference();
    private final long paymentMethodConfigurationId;
    private volatile int currentHeight = 0;
    private final AtomicBoolean enlarged = new AtomicBoolean(false);
    private final AtomicBoolean ready = new AtomicBoolean(false);
    private final Handler uiThreadHandler;
    private final Timer timer = new Timer();
    private final AtomicReference<TimerTask> timerTask = new AtomicReference();

    public DefaultPaymentFormView(Context context, PaymentFormView.Listener<DefaultPaymentFormView> listener, PaymentFormViewFactory.UrlFetcher urlFetcher, long selectedPaymentMethodConfigurationId) {
        super(context);
        this.listener = Check.requireNonNull(listener, "The listener is required.");
        this.urlFetcher = Check.requireNonNull(urlFetcher, "The URL provider is required.");
        this.paymentMethodConfigurationId = selectedPaymentMethodConfigurationId;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.init();
        this.setupTimerTask();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelTimerTask();
    }

    @Override
    public void saveViewState(Bundle outState) {
        this.saveState(outState);
        outState.putParcelable(PARCEABLE_IDENTIFIER, (Parcelable)new PaymentFormState(this.submitted.get(), this.executingValidation.get(), this.mobileSdkUrl.get(), this.paymentMethodConfigurationId, this.currentHeight, this.enlarged.get(), this.ready.get()));
    }

    @Override
    public void restoreViewState(Bundle inState) {
        this.restoreState(inState);
        Parcelable state = inState.getParcelable(PARCEABLE_IDENTIFIER);
        if (state != null && state instanceof PaymentFormState) {
            PaymentFormState casted = (PaymentFormState)state;
            this.submitted.set(casted.isSubmitted());
            this.executingValidation.set(casted.isExecutingValidation());
            this.ready.set(casted.isReady());
            this.enlarged.set(casted.isEnlarged());
            this.mobileSdkUrl.set(casted.getMobileSdkUrl());
            if (this.paymentMethodConfigurationId != casted.getPaymentMethodConfigurationId()) {
                throw new IllegalStateException("It is not allowed to change the payment method configuration ID during the view usage. To change the payment method configuration the whole we has to be reloaded.");
            }
            this.currentHeight = casted.getCurrentHeight();
        }
    }

    private void init() {
        super.setWebViewClient((WebViewClient)new PaymentFormWebViewClient(new CallbackListenerMapper(this)));
        super.getSettings().setJavaScriptEnabled(true);
        super.getSettings().setSaveFormData(false);
        super.getSettings().setSupportMultipleWindows(false);
        super.getSettings().setAllowUniversalAccessFromFileURLs(true);
        DefaultPaymentFormView view = this;
        if (!this.ready.get()) {
            this.listener.onLoading(view);
        }
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                return false;
            }
        });
        if (this.mobileSdkUrl.get() == null) {
            this.urlFetcher.fetchMobileSdkUrl(new AsynchronousCallback<MobileSdkUrl>(){

                @Override
                public void process(MobileSdkUrl parameter) {
                    if (DefaultPaymentFormView.this.mobileSdkUrl.compareAndSet(null, parameter)) {
                        DefaultPaymentFormView.this.loadSdkUrl(parameter);
                        DefaultPaymentFormView.this.setupTimerTask();
                    }
                }
            });
        } else if (this.isExpired()) {
            this.listener.onExpired(this);
        } else {
            if (this.ready.get()) {
                this.listener.onReady(this);
                this.setupTimerTask();
            }
            if (this.enlarged.get()) {
                this.listener.onEnlargeView(this);
            } else {
                this.adjustViewHeight();
            }
        }
    }

    private void setupTimerTask() {
        DefaultPaymentFormView view;
        boolean added;
        if (this.mobileSdkUrl.get() != null && !this.enlarged.get() && (added = this.timerTask.compareAndSet(null, new TimerTask(view = this){
            final /* synthetic */ DefaultPaymentFormView val$view;
            {
                this.val$view = defaultPaymentFormView;
            }

            @Override
            public void run() {
                DefaultPaymentFormView.this.listener.onExpired(this.val$view);
            }
        }))) {
            this.timer.schedule(this.timerTask.get(), this.mobileSdkUrl.get().getExpiryDate() - System.currentTimeMillis());
        }
    }

    private void cancelTimerTask() {
        TimerTask task = this.timerTask.get();
        if (task != null) {
            task.cancel();
        }
    }

    private void adjustViewHeight() {
        final DefaultPaymentFormView view = this;
        this.uiThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (!view.enlarged.get()) {
                    ViewGroup.LayoutParams params = view.getLayoutParams();
                    params.height = view.getCurrentTargetHeight();
                    Log.i((String)TAG, (String)("Adjust Height to: " + params.height));
                    view.setLayoutParams(params);
                }
            }
        });
    }

    private void resetViewHeight() {
        final DefaultPaymentFormView view = this;
        this.uiThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (view.enlarged.get()) {
                    ViewGroup.LayoutParams params = view.getLayoutParams();
                    params.height = -2;
                    Log.i((String)TAG, (String)"Reset View Height.");
                    view.setLayoutParams(params);
                }
            }
        });
    }

    private boolean isExpired() {
        return this.getUrl().startsWith(this.mobileSdkUrl.get().toString()) && this.mobileSdkUrl.get().isExpired();
    }

    private void loadSdkUrl(MobileSdkUrl url) {
        super.loadUrl(url.buildPaymentMethodUrl(this.paymentMethodConfigurationId).toString());
        this.setBackgroundColor(0);
    }

    @Override
    public boolean isSubmitted() {
        return this.submitted.get();
    }

    @Override
    public final void validate() {
        if (this.executingValidation.compareAndSet(false, true)) {
            this.uiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    DefaultPaymentFormView.this.sendValidationCommand();
                }
            });
        }
    }

    private void sendValidationCommand() {
        super.loadUrl("javascript:(function () { MobileSdkHandler.validate(); })()");
    }

    @Override
    public final void submit() {
        if (this.submitted.compareAndSet(false, true)) {
            this.uiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    DefaultPaymentFormView.this.sendSubmitCommand();
                }
            });
        }
    }

    private void sendSubmitCommand() {
        super.loadUrl("javascript:(function () { MobileSdkHandler.submit(); })()");
    }

    public final void loadData(String data, String mimeType, String encoding) {
        throw new UnsupportedOperationException("This method cannot be invoked in " + DefaultPaymentFormView.class + ".");
    }

    public final void loadUrl(String url) {
        throw new UnsupportedOperationException("This method cannot be invoked in " + DefaultPaymentFormView.class + ".");
    }

    public final void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        throw new UnsupportedOperationException("This method cannot be invoked in " + DefaultPaymentFormView.class + ".");
    }

    public final void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        throw new UnsupportedOperationException("This method cannot be invoked in " + DefaultPaymentFormView.class + ".");
    }

    public final void setWebViewClient(WebViewClient client) {
        throw new UnsupportedOperationException("The web client cannot be overridden in the " + DefaultPaymentFormView.class + ".");
    }

    @Override
    public int getCurrentTargetHeight() {
        return (int)Math.ceil(MeasurementUnitUtil.convertDpToPixel(this.currentHeight, this.getContext()));
    }

    private static class PaymentFormState
    implements Parcelable {
        private final boolean submitted;
        private final boolean executingValidation;
        private final MobileSdkUrl mobileSdkUrl;
        private final long paymentMethodConfigurationId;
        private final int currentHeight;
        private final boolean enlarged;
        private final boolean ready;
        public static final Parcelable.Creator<PaymentFormState> CREATOR = new Parcelable.Creator<PaymentFormState>(){

            public PaymentFormState createFromParcel(Parcel in) {
                return new PaymentFormState(in);
            }

            public PaymentFormState[] newArray(int size) {
                return new PaymentFormState[size];
            }
        };

        PaymentFormState(boolean submitted, boolean executingValidation, MobileSdkUrl mobileSdkUrl, long paymentMethodConfigurationId, int currentHeight, boolean enlarged, boolean ready) {
            this.submitted = submitted;
            this.executingValidation = executingValidation;
            this.mobileSdkUrl = mobileSdkUrl;
            this.paymentMethodConfigurationId = paymentMethodConfigurationId;
            this.currentHeight = currentHeight;
            this.enlarged = enlarged;
            this.ready = ready;
        }

        protected PaymentFormState(Parcel in) {
            this.submitted = in.readByte() != 0;
            this.executingValidation = in.readByte() != 0;
            this.mobileSdkUrl = (MobileSdkUrl)in.readParcelable(MobileSdkUrl.class.getClassLoader());
            this.paymentMethodConfigurationId = in.readLong();
            this.currentHeight = in.readInt();
            this.enlarged = in.readByte() != 0;
            this.ready = in.readByte() != 0;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByte((byte)(this.submitted ? 1 : 0));
            dest.writeByte((byte)(this.executingValidation ? 1 : 0));
            dest.writeParcelable((Parcelable)this.mobileSdkUrl, flags);
            dest.writeLong(this.paymentMethodConfigurationId);
            dest.writeInt(this.currentHeight);
            dest.writeByte((byte)(this.enlarged ? 1 : 0));
            dest.writeByte((byte)(this.ready ? 1 : 0));
        }

        public boolean isSubmitted() {
            return this.submitted;
        }

        public boolean isExecutingValidation() {
            return this.executingValidation;
        }

        public MobileSdkUrl getMobileSdkUrl() {
            return this.mobileSdkUrl;
        }

        public long getPaymentMethodConfigurationId() {
            return this.paymentMethodConfigurationId;
        }

        public int getCurrentHeight() {
            return this.currentHeight;
        }

        public boolean isEnlarged() {
            return this.enlarged;
        }

        public boolean isReady() {
            return this.ready;
        }

        public static Parcelable.Creator<PaymentFormState> getCREATOR() {
            return CREATOR;
        }
    }

    private static class CallbackListenerMapper
    implements PaymentFormWebViewClient.CallbackListener {
        private final DefaultPaymentFormView view;

        CallbackListenerMapper(DefaultPaymentFormView view) {
            this.view = view;
        }

        @Override
        public void onInitialize() {
        }

        @Override
        public void onHeightChange(int targetHeight) {
            this.view.currentHeight = targetHeight;
            this.view.adjustViewHeight();
            if (this.view.ready.compareAndSet(false, true)) {
                this.view.listener.onReady(this.view);
            }
        }

        @Override
        public void onEnlargeView() {
            if (this.view.enlarged.compareAndSet(false, true)) {
                this.view.resetViewHeight();
                this.view.listener.onEnlargeView(this.view);
                this.view.cancelTimerTask();
            }
        }

        @Override
        public void onValidationSuccess() {
            this.view.executingValidation.set(false);
            this.view.listener.onValidationSuccess(this.view);
        }

        @Override
        public void onValidationFailure(List<String> messages) {
            this.view.executingValidation.set(false);
            this.view.listener.onValidationFailure(this.view, messages);
        }

        @Override
        public void onAwaitingFinalStatus(long transactionId) {
            if (this.view.enlarged.compareAndSet(true, false)) {
                this.view.listener.onResetView(this.view);
            }
            this.view.listener.onAwaitingFinalState(this.view);
        }

        @Override
        public void onSuccess() {
            if (this.view.enlarged.compareAndSet(true, false)) {
                this.view.listener.onResetView(this.view);
            }
            this.view.listener.onSuccess(this.view);
        }

        @Override
        public void onFailure() {
            if (this.view.enlarged.compareAndSet(true, false)) {
                this.view.listener.onResetView(this.view);
            }
            this.view.listener.onFailure(this.view);
        }

        @Override
        public void onHttpError(HttpError error) {
            this.view.listener.onHttpError(this.view, error);
        }
    }
}

