/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.view.form;

import android.net.Uri;
import android.util.Log;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.gson.Gson;
import com.wallee.android.sdk.util.Check;
import com.wallee.android.sdk.util.HttpError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

final class PaymentFormWebViewClient
extends WebViewClient {
    private final String TAG = PaymentFormWebViewClient.class.getCanonicalName();
    private static final String URL_PROTOCOL_HTTP = "https://localhost/mobile-sdk-callback/";
    private final CallbackListener listener;

    PaymentFormWebViewClient(CallbackListener listener) {
        this.listener = Check.requireNonNull(listener, "The listener is required.");
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        if (this.triggerCallback(url)) {
            try {
                return new WebResourceResponse("text/html", "UTF-8", (InputStream)new ByteArrayInputStream("".getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private boolean triggerCallback(String url) {
        String callbackName = this.extractCallbackName(url);
        if (callbackName != null) {
            Uri uri = Uri.parse((String)url);
            if (callbackName == null || callbackName.isEmpty()) {
                Log.e((String)this.TAG, (String)"The callback name (host) is empty which should not be the case. We ignore it and continue.");
            } else {
                Callback callback = Callback.getByName(callbackName);
                if (callback != null) {
                    callback.invokeListener(uri, this.listener);
                } else {
                    Log.e((String)this.TAG, (String)("The callback name (host) is not known. We ignore it and continue. Callback Name: " + callbackName));
                }
            }
            return true;
        }
        return false;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (this.triggerCallback(url)) {
            return true;
        }
        this.listener.onEnlargeView();
        return false;
    }

    private String extractCallbackName(String url) {
        if (url.startsWith(URL_PROTOCOL_HTTP)) {
            String callbackPart = url.substring(URL_PROTOCOL_HTTP.length());
            int queryStart = callbackPart.indexOf(63);
            if (queryStart > 0) {
                return callbackPart.substring(0, queryStart);
            }
            return callbackPart;
        }
        return null;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        this.listener.onHttpError(new HttpError(failingUrl, description, errorCode));
    }

    private static class ValidationResult {
        private boolean success;
        private List<String> errors;

        private ValidationResult() {
        }

        public boolean isSuccess() {
            return this.success;
        }

        public List<String> getErrors() {
            return this.errors;
        }
    }

    static interface CallbackListener {
        public void onInitialize();

        public void onHeightChange(int var1);

        public void onEnlargeView();

        public void onValidationSuccess();

        public void onValidationFailure(List<String> var1);

        public void onAwaitingFinalStatus(long var1);

        public void onSuccess();

        public void onFailure();

        public void onHttpError(HttpError var1);
    }

    private static enum Callback {
        INITIALIZE("initializeCallback"){

            @Override
            void invokeListener(Uri url, CallbackListener listener) {
                listener.onInitialize();
            }
        }
        ,
        HEIGHT_CHANGE("heightChangeCallback"){

            @Override
            void invokeListener(Uri url, CallbackListener listener) {
                try {
                    listener.onHeightChange(Integer.parseInt(this.readDataParameter(url)));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("The callback should contain an integer with the desired height of the view. However it seems as it is not a valid number. Callback: " + url, e);
                }
            }
        }
        ,
        VALIDATION("validationCallback"){

            @Override
            void invokeListener(Uri url, CallbackListener listener) {
                Gson gson = new Gson();
                String data = this.readDataParameter(url);
                ValidationResult result = (ValidationResult)gson.fromJson(data, ValidationResult.class);
                if (result.isSuccess()) {
                    listener.onValidationSuccess();
                } else {
                    listener.onValidationFailure(result.getErrors());
                }
            }
        }
        ,
        AWAITING_FINAL_RESULT("awaitingFinalResultCallback"){

            @Override
            void invokeListener(Uri url, CallbackListener listener) {
                String id = this.readDataParameter(url);
                listener.onAwaitingFinalStatus(Long.parseLong(id));
            }
        }
        ,
        SUCCESS("successCallback"){

            @Override
            void invokeListener(Uri url, CallbackListener listener) {
                listener.onSuccess();
            }
        }
        ,
        FAILED("failureCallback"){

            @Override
            void invokeListener(Uri url, CallbackListener listener) {
                listener.onFailure();
            }
        };

        private final String name;
        private static final Map<String, Callback> BY_NAME;

        private Callback(String name) {
            this.name = name;
        }

        static Callback getByName(String name) {
            Check.requireNonEmpty(name, "The name is required.");
            return BY_NAME.get(name.toLowerCase(Locale.ROOT));
        }

        abstract void invokeListener(Uri var1, CallbackListener var2);

        protected String readDataParameter(Uri url) {
            String data = url.getQueryParameter("data");
            if (data == null || data.isEmpty()) {
                throw new IllegalArgumentException("The callback does not contain a data object even the contract says it should. Callback: " + url);
            }
            return data;
        }

        static {
            HashMap<String, Callback> map = new HashMap<String, Callback>();
            for (Callback callback : Callback.values()) {
                map.put(callback.name.toLowerCase(Locale.ROOT), callback);
            }
            BY_NAME = Collections.unmodifiableMap(map);
        }
    }
}

