/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.view.selection.method;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.wallee.android.sdk.R;
import com.wallee.android.sdk.request.model.method.PaymentMethodConfiguration;
import com.wallee.android.sdk.request.model.method.PaymentMethodIcon;
import com.wallee.android.sdk.view.selection.PaymentMethodImageView;
import com.wallee.android.sdk.view.selection.method.PaymentMethodListViewFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultPaymentMethodListViewAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<PaymentMethodConfiguration> paymentMethods;
    private PaymentMethodListViewFactory.PaymentMethodListViewListener paymentMethodListViewListener;
    private Map<PaymentMethodConfiguration, PaymentMethodIcon> icons;

    public DefaultPaymentMethodListViewAdapter(List<PaymentMethodConfiguration> paymentMethods, PaymentMethodListViewFactory.PaymentMethodListViewListener paymentMethodListViewListener, Map<PaymentMethodConfiguration, PaymentMethodIcon> icons) {
        this.paymentMethodListViewListener = paymentMethodListViewListener;
        ArrayList<PaymentMethodConfiguration> list = new ArrayList<PaymentMethodConfiguration>(paymentMethods);
        Collections.sort(list);
        this.paymentMethods = Collections.unmodifiableList(list);
        this.icons = Collections.unmodifiableMap(new HashMap<PaymentMethodConfiguration, PaymentMethodIcon>(icons));
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.wallee_payment_method_item_view, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.nameTextView.setText((CharSequence)this.paymentMethods.get(position).getName());
        holder.iconView.setIcon(this.icons.get(this.paymentMethods.get(position)));
    }

    private void onItemClicked(int position) {
        if (position < this.paymentMethods.size()) {
            this.paymentMethodListViewListener.onPaymentMethodClicked(this.paymentMethods.get(position));
        }
    }

    public int getItemCount() {
        return this.paymentMethods.size();
    }

    public final class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private final PaymentMethodImageView iconView;
        private final TextView nameTextView;

        protected ViewHolder(View v) {
            super(v);
            this.nameTextView = (TextView)v.findViewById(R.id.wallee_payment_method_name);
            this.iconView = (PaymentMethodImageView)v.findViewById(R.id.wallee_payment_method_icon);
            v.setOnClickListener((View.OnClickListener)this);
            this.iconView.setOnClickListener(this);
        }

        public void onClick(View view) {
            DefaultPaymentMethodListViewAdapter.this.onItemClicked(this.getAdapterPosition());
        }
    }
}

