/*
 * Decompiled with CFR 0.152.
 */
package com.wallee.android.sdk.view.selection.token;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.wallee.android.sdk.R;
import com.wallee.android.sdk.request.model.method.PaymentMethodConfiguration;
import com.wallee.android.sdk.request.model.method.PaymentMethodIcon;
import com.wallee.android.sdk.request.model.token.TokenVersion;
import com.wallee.android.sdk.view.selection.PaymentMethodImageView;
import com.wallee.android.sdk.view.selection.token.TokenListViewFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultTokenListViewAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final List<TokenVersion> tokenVersions;
    private final TokenListViewFactory.TokenViewListener tokenClickHandler;
    private final Map<PaymentMethodConfiguration, PaymentMethodIcon> icons;

    public DefaultTokenListViewAdapter(List<TokenVersion> tokens, TokenListViewFactory.TokenViewListener listener, Map<PaymentMethodConfiguration, PaymentMethodIcon> icons) {
        ArrayList<TokenVersion> list = new ArrayList<TokenVersion>(tokens);
        Collections.sort(list);
        this.tokenVersions = Collections.unmodifiableList(list);
        this.tokenClickHandler = listener;
        this.icons = Collections.unmodifiableMap(new HashMap<PaymentMethodConfiguration, PaymentMethodIcon>(icons));
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.wallee_token_version_item_view, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        TokenVersion version = this.tokenVersions.get(position);
        String paymentMethodName = version.getPaymentConnectorConfiguration().getPaymentMethodConfiguration().getResolvedTitle(((ViewHolder)holder).iconView.getContext().getResources().getConfiguration().locale);
        holder.paymentMethodNameTextView.setText((CharSequence)paymentMethodName);
        holder.tokenTextView.setText((CharSequence)version.getName());
        holder.iconView.setIcon(this.icons.get(version.getPaymentConnectorConfiguration().getPaymentMethodConfiguration()));
    }

    protected final void triggerClickEvent(int position) {
        if (position < this.tokenVersions.size()) {
            this.tokenClickHandler.onTokenClicked(this.tokenVersions.get(position));
        }
    }

    public int getItemCount() {
        return this.tokenVersions.size();
    }

    public final class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private final TextView paymentMethodNameTextView;
        private final TextView tokenTextView;
        private final PaymentMethodImageView iconView;

        protected ViewHolder(View v) {
            super(v);
            this.paymentMethodNameTextView = (TextView)v.findViewById(R.id.payment_method_name_view);
            this.tokenTextView = (TextView)v.findViewById(R.id.token_name_view);
            this.iconView = (PaymentMethodImageView)v.findViewById(R.id.token_payment_method_icon_view);
            v.setOnClickListener((View.OnClickListener)this);
            this.iconView.setOnClickListener(this);
        }

        public void onClick(View view) {
            DefaultTokenListViewAdapter.this.triggerClickEvent(this.getAdapterPosition());
        }
    }
}

