/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.ollie.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMemorySize;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.walmartlabs.ollie.config.ConfigExtractor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

enum ConfigExtractors implements ConfigExtractor
{
    BOOLEAN(new Class[]{Boolean.TYPE, Boolean.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getBoolean(path);
        }
    }
    ,
    BYTE(new Class[]{Byte.TYPE, Byte.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return (byte)config.getInt(path);
        }
    }
    ,
    SHORT(new Class[]{Short.TYPE, Short.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return (short)config.getInt(path);
        }
    }
    ,
    INTEGER(new Class[]{Integer.TYPE, Integer.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getInt(path);
        }
    }
    ,
    LONG(new Class[]{Long.TYPE, Long.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getLong(path);
        }
    }
    ,
    FLOAT(new Class[]{Float.TYPE, Float.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return Float.valueOf((float)config.getDouble(path));
        }
    }
    ,
    DOUBLE(new Class[]{Double.TYPE, Double.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getDouble(path);
        }
    }
    ,
    STRING(new Class[]{String.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getString(path);
        }
    }
    ,
    PATH(new Class[]{Path.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return Paths.get(config.getString(path), new String[0]);
        }
    }
    ,
    ANY_REF(new Class[]{Object.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getAnyRef(path);
        }
    }
    ,
    CONFIG(new Class[]{Config.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getConfig(path);
        }
    }
    ,
    CONFIG_OBJECT(new Class[]{ConfigObject.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getObject(path);
        }
    }
    ,
    CONFIG_VALUE(new Class[]{ConfigValue.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getValue(path);
        }
    }
    ,
    CONFIG_LIST(new Class[]{ConfigList.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getList(path);
        }
    }
    ,
    DURATION(new Class[]{Duration.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getDuration(path);
        }
    }
    ,
    MEMORY_SIZE(new Class[]{ConfigMemorySize.class}){

        @Override
        public Object extractValue(Config config, String path) {
            return config.getMemorySize(path);
        }
    }
    ,
    BYTE_ARRAY(new Class[]{byte[].class}){

        @Override
        public Object extractValue(Config config, String path) {
            return Base64.getDecoder().decode(config.getString(path));
        }
    };

    private final Class<?>[] matchingClasses;
    private static final Map<Class<?>, ConfigExtractor> EXTRACTOR_MAP;

    static {
        EXTRACTOR_MAP = new HashMap();
        ConfigExtractors[] configExtractorsArray = ConfigExtractors.values();
        int n = configExtractorsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigExtractors extractor = configExtractorsArray[n2];
            Class<?>[] classArray = extractor.getMatchingClasses();
            int n3 = classArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> clazz = classArray[n4];
                EXTRACTOR_MAP.put(clazz, extractor);
                ++n4;
            }
            ++n2;
        }
    }

    private ConfigExtractors(Class<?> ... matchingClasses) {
        this.matchingClasses = matchingClasses;
    }

    @Override
    public Class<?>[] getMatchingClasses() {
        return this.matchingClasses;
    }

    static Optional<Object> extractConfigValue(Config config, Class<?> paramClass, String path) {
        if (config.hasPath(path) && EXTRACTOR_MAP.containsKey(paramClass)) {
            return Optional.of(EXTRACTOR_MAP.get(paramClass).extractValue(config, path));
        }
        return Optional.empty();
    }

    /* synthetic */ ConfigExtractors(String string, int n, Class[] classArray, ConfigExtractors configExtractors) {
        this(classArray);
    }
}

