/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.ollie.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigResolver;
import com.typesafe.config.ConfigValue;
import com.walmartlabs.ollie.config.Environment;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProcessor {
    public static final String CONFIG_FILE = "ollie.conf";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationProcessor.class);
    private final String name;
    private final Environment environment;
    private final File overridesFile;
    private final File secretsProperties;
    private static ConfigResolver secretsResolver = new ConfigResolver(){

        public ConfigValue lookup(String path) {
            return null;
        }

        public ConfigResolver withFallback(ConfigResolver fallback) {
            return fallback;
        }
    };

    public ConfigurationProcessor(String name) {
        this(name, Environment.DEVELOPMENT, null, null);
    }

    public ConfigurationProcessor(String name, File overridesFile) {
        this(name, Environment.DEVELOPMENT, overridesFile, null);
    }

    public ConfigurationProcessor(String name, Environment environment) {
        this(name, environment, null, null);
    }

    public ConfigurationProcessor(String name, Environment environment, File overridesFile, File secretsProperties) {
        this.name = name;
        this.environment = environment;
        this.overridesFile = overridesFile;
        this.secretsProperties = secretsProperties;
    }

    public Config process() {
        String configurationName = String.valueOf(this.name) + ".conf";
        logger.info("Processing configuration resource {}", (Object)configurationName);
        ConfigResolveOptions resolveOptions = ConfigResolveOptions.defaults().setAllowUnresolved(true);
        Config configuration = ConfigFactory.load((String)configurationName, (ConfigParseOptions)ConfigParseOptions.defaults(), (ConfigResolveOptions)resolveOptions);
        Config result = configuration.getConfig(this.name);
        if (System.getProperty(CONFIG_FILE) != null) {
            String p = System.getProperty(CONFIG_FILE);
            logger.info("Processing configuration file {}", (Object)p);
            Config externalConfiguration = ConfigFactory.parseFile((File)new File(p)).getConfig(this.name);
            result = externalConfiguration.withFallback((ConfigMergeable)result);
        }
        Config environmentConfiguration = result.getConfig(this.environment.id());
        Environment[] environmentArray = Environment.values();
        int n = environmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Environment e = environmentArray[n2];
            result = result.withoutPath(e.id());
            ++n2;
        }
        result = environmentConfiguration.withFallback((ConfigMergeable)result);
        if (this.environment == Environment.DEVELOPMENT && this.overridesFile != null) {
            if (!this.overridesFile.exists()) {
                throw new RuntimeException(String.format("The specified overrides configuration doesn't exist: '%s'.", this.overridesFile));
            }
            Config overrides = ConfigFactory.parseFile((File)this.overridesFile);
            try {
                overrides = overrides.getConfig(this.name);
            }
            catch (ConfigException configException) {
                throw new RuntimeException(String.format("The specified application '%s' is not present in the overrides file '%s'.", this.name, this.overridesFile));
            }
            try {
                overrides = overrides.getConfig(this.environment.id());
            }
            catch (ConfigException configException) {
                throw new RuntimeException(String.format("The specified environment '%s' is not present in the application configuration '%s' in the overrides file '%s'.", this.environment.id(), this.name, this.overridesFile));
            }
            result = overrides.withFallback((ConfigMergeable)result);
        }
        if (this.secretsProperties != null && this.secretsProperties.exists()) {
            Config secrets = ConfigFactory.parseFile((File)this.secretsProperties);
            result = result.resolveWith(secrets);
        }
        return result.resolve();
    }
}

