/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.ollie.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMemorySize;
import com.typesafe.config.ConfigObject;
import com.walmartlabs.ollie.config.ListExtractor;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public enum ListExtractors implements ListExtractor
{
    BOOLEAN((Class)Boolean.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getBooleanList(path);
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getIntList(path);
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getDoubleList(path);
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getLongList(path);
        }
    }
    ,
    STRING((Class)String.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getStringList(path);
        }
    }
    ,
    DURATION((Class)Duration.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getDurationList(path);
        }
    }
    ,
    MEMORY_SIZE((Class)ConfigMemorySize.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getMemorySizeList(path);
        }
    }
    ,
    OBJECT((Class)Object.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getAnyRefList(path);
        }
    }
    ,
    CONFIG((Class)Config.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getConfigList(path);
        }
    }
    ,
    CONFIG_OBJECT((Class)ConfigObject.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getObjectList(path);
        }
    }
    ,
    CONFIG_VALUE((Class)ConfigObject.class){

        @Override
        public List<?> extractListValue(Config config, String path) {
            return config.getList(path);
        }
    };

    private final Class<?> parameterizedTypeClass;
    private static final Map<Type, ListExtractor> EXTRACTOR_MAP;

    static {
        EXTRACTOR_MAP = new HashMap<Type, ListExtractor>();
        ListExtractors[] listExtractorsArray = ListExtractors.values();
        int n = listExtractorsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListExtractors extractor = listExtractorsArray[n2];
            EXTRACTOR_MAP.put(extractor.getMatchingParameterizedType(), extractor);
            ++n2;
        }
    }

    private ListExtractors(Class<?> parameterizedTypeClass) {
        this.parameterizedTypeClass = parameterizedTypeClass;
    }

    @Override
    public Type getMatchingParameterizedType() {
        return this.parameterizedTypeClass;
    }

    static Optional<List<?>> extractConfigListValue(Config config, Type listType, String path) {
        if (EXTRACTOR_MAP.containsKey(listType)) {
            return Optional.of(EXTRACTOR_MAP.get(listType).extractListValue(config, path));
        }
        return Optional.empty();
    }

    /* synthetic */ ListExtractors(String string, int n, Class clazz, ListExtractors listExtractors) {
        this(clazz);
    }
}

