/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.ollie.config;

import com.google.common.base.Predicate;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.typesafe.config.ConfigBeanFactory;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.walmartlabs.ollie.config.Config;
import com.walmartlabs.ollie.config.ConfigExtractors;
import com.walmartlabs.ollie.config.ListExtractors;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class OllieConfigurationModule
extends AbstractModule {
    private static final Provider<Object> NULL_PROVIDER = () -> null;
    private final com.typesafe.config.Config config;
    private final Reflections reflections;
    private final Set<Config> boundAnnotations;

    public OllieConfigurationModule(String packageToScan, com.typesafe.config.Config config) {
        ConfigurationBuilder configBuilder = new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageToScan})).setUrls(ClasspathHelper.forPackage((String)packageToScan, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new TypeAnnotationsScanner(), new MethodParameterScanner(), new MethodAnnotationsScanner(), new FieldAnnotationsScanner()});
        this.config = config;
        this.reflections = new Reflections((Configuration)configBuilder);
        this.boundAnnotations = new HashSet<Config>();
    }

    protected void configure() {
        Set annotatedConstructors = this.reflections.getConstructorsWithAnyParamAnnotated(Config.class);
        for (Constructor c : annotatedConstructors) {
            Parameter[] params = c.getParameters();
            this.bindParameters(params);
        }
        Set annotatedMethods = this.reflections.getMethodsWithAnyParamAnnotated(Config.class);
        for (Method m : annotatedMethods) {
            Parameter[] params = m.getParameters();
            this.bindParameters(params);
        }
        Set annotatedFields = this.reflections.getFieldsAnnotatedWith(Config.class);
        for (Field f : annotatedFields) {
            Config annotation = f.getAnnotation(Config.class);
            this.bindValue(f.getType(), f.getAnnotatedType().getType(), annotation, OllieConfigurationModule.isNullable(f.getAnnotations()));
        }
    }

    private void bindParameters(Parameter[] params) {
        Parameter[] parameterArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            if (p.isAnnotationPresent(Config.class)) {
                Config annotation = p.getAnnotation(Config.class);
                this.bindValue(p.getType(), p.getAnnotatedType().getType(), annotation, OllieConfigurationModule.isNullable(p.getAnnotations()));
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bindValue(Class<?> paramClass, Type paramType, Config annotation, boolean nullable) {
        if (this.boundAnnotations.contains(annotation)) return;
        Key key = Key.get((Type)paramType, (Annotation)annotation);
        String configPath = annotation.value();
        Object configValue = this.getConfigValue(paramClass, paramType, configPath, nullable);
        if (configValue == null) {
            if (!nullable) throw new ConfigException.Missing(configPath);
            this.bind(key).toProvider(NULL_PROVIDER);
        } else {
            this.bind(key).toInstance(configValue);
        }
        this.boundAnnotations.add(annotation);
    }

    private Object getConfigValue(Class<?> paramClass, Type paramType, String path, boolean nullable) {
        Optional<Object> extractedValue = ConfigExtractors.extractConfigValue(this.config, paramClass, path);
        if (extractedValue.isPresent()) {
            return extractedValue.get();
        }
        if (nullable && !this.config.hasPath(path)) {
            return null;
        }
        ConfigValue configValue = this.config.getValue(path);
        ConfigValueType valueType = configValue.valueType();
        if (valueType.equals((Object)ConfigValueType.OBJECT) && Map.class.isAssignableFrom(paramClass)) {
            ConfigObject object = this.config.getObject(path);
            return object.unwrapped();
        }
        if (valueType.equals((Object)ConfigValueType.OBJECT)) {
            Object bean = ConfigBeanFactory.create((com.typesafe.config.Config)this.config.getConfig(path), paramClass);
            return bean;
        }
        if (valueType.equals((Object)ConfigValueType.LIST) && List.class.isAssignableFrom(paramClass)) {
            Type listType = ((ParameterizedType)paramType).getActualTypeArguments()[0];
            Optional<List<?>> extractedListValue = ListExtractors.extractConfigListValue(this.config, listType, path);
            if (extractedListValue.isPresent()) {
                return extractedListValue.get();
            }
            List configList = this.config.getConfigList(path);
            return configList.stream().map(cfg -> {
                Object created = ConfigBeanFactory.create((com.typesafe.config.Config)cfg, (Class)((Class)listType));
                return created;
            }).collect(Collectors.toList());
        }
        throw new RuntimeException("Cannot obtain config value for " + paramType + " at path: " + path);
    }

    private static boolean isNullable(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return false;
        }
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if ("Nullable".equals(a.annotationType().getSimpleName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

