/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12;

import com.walmartlabs.x12.X12Segment;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SegmentIterator
implements ListIterator<X12Segment> {
    private List<X12Segment> segmentLines;
    private int currentSegmentIdx;

    public SegmentIterator(List<X12Segment> segmentLines) {
        if (segmentLines == null) {
            throw new IllegalArgumentException("segment list must not be null");
        }
        this.currentSegmentIdx = 0;
        this.segmentLines = segmentLines;
    }

    @Override
    public boolean hasNext() {
        return this.currentSegmentIdx < this.segmentLines.size();
    }

    @Override
    public X12Segment next() {
        if (this.hasNext()) {
            return this.segmentLines.get(this.currentSegmentIdx++);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        return this.currentSegmentIdx != 0;
    }

    @Override
    public X12Segment previous() {
        if (this.hasPrevious()) {
            return this.segmentLines.get(--this.currentSegmentIdx);
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        if (this.hasNext()) {
            return this.currentSegmentIdx;
        }
        return this.segmentLines.size();
    }

    @Override
    public int previousIndex() {
        if (this.hasPrevious()) {
            return this.currentSegmentIdx - 1;
        }
        return -1;
    }

    @Override
    public void add(X12Segment segment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(X12Segment segment) {
        throw new UnsupportedOperationException();
    }

    public int currentIndex() {
        return this.currentSegmentIdx;
    }

    public int lastIndex() {
        return this.segmentLines.size() - 1;
    }

    public void reset(int index) {
        this.currentSegmentIdx = index;
    }

    public List<X12Segment> subList(int fromIndex, int toIndex) {
        return this.segmentLines.subList(fromIndex, toIndex);
    }
}

