/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12;

import com.walmartlabs.x12.util.SourceToSegmentUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class X12Segment {
    private String segmentValue;
    private List<String> segmentElements;

    public X12Segment(String segment) {
        this(segment, SourceToSegmentUtil.DEFAULT_DATA_ELEMENT_SEPARATOR);
    }

    public X12Segment(String segment, Character dataElementDelimiter) {
        this.segmentValue = segment;
        this.segmentElements = this.splitSegmentIntoDataElements(segment, dataElementDelimiter);
    }

    public String toString() {
        return this.segmentValue;
    }

    public String getIdentifier() {
        if (this.segmentElements != null && !this.segmentElements.isEmpty()) {
            return this.segmentElements.get(0);
        }
        return "";
    }

    public String getElement(int index) {
        if (this.segmentElements.size() > index) {
            String value = this.segmentElements.get(index);
            return StringUtils.isEmpty((CharSequence)value) ? null : value;
        }
        return null;
    }

    public int segmentSize() {
        return this.segmentElements.size();
    }

    private List<String> splitSegmentIntoDataElements(String segment, Character dataElementDelimiter) {
        if (StringUtils.isEmpty((CharSequence)segment)) {
            return Collections.emptyList();
        }
        String splitRegEx = this.convertDataElementDelimiterToRegEx(dataElementDelimiter);
        return Arrays.asList(segment.split(splitRegEx));
    }

    private String convertDataElementDelimiterToRegEx(Character dataElementDelimiter) {
        if (dataElementDelimiter != null) {
            if (Character.isLetterOrDigit(dataElementDelimiter.charValue())) {
                return dataElementDelimiter.toString();
            }
            return "\\" + dataElementDelimiter;
        }
        return String.valueOf('\u0000');
    }
}

