/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.common.segment.parser;

import com.walmartlabs.x12.SegmentIterator;
import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.common.segment.N1PartyIdentification;
import com.walmartlabs.x12.common.segment.parser.N3PartyLocationParser;
import com.walmartlabs.x12.common.segment.parser.N4GeographicLocationParser;
import com.walmartlabs.x12.common.segment.parser.REFReferenceInformationParser;

public final class N1PartyIdentificationParser {
    public static N1PartyIdentification parse(X12Segment segment) {
        String segmentIdentifier;
        N1PartyIdentification n1 = null;
        if (segment != null && "N1".equals(segmentIdentifier = segment.getIdentifier())) {
            n1 = new N1PartyIdentification();
            n1.setEntityIdentifierCode(segment.getElement(1));
            n1.setName(segment.getElement(2));
            n1.setIdentificationCodeQualifier(segment.getElement(3));
            n1.setIdentificationCode(segment.getElement(4));
        }
        return n1;
    }

    public static N1PartyIdentification handleN1Loop(X12Segment segment, SegmentIterator segmentIterator) {
        N1PartyIdentification n1 = N1PartyIdentificationParser.parse(segment);
        boolean keepLooping = true;
        while (n1 != null && keepLooping && segmentIterator.hasNext()) {
            X12Segment nextSegment = segmentIterator.next();
            switch (nextSegment.getIdentifier()) {
                case "N3": {
                    n1.addN3PartyLocation(N3PartyLocationParser.parse(nextSegment));
                    break;
                }
                case "N4": {
                    n1.setN4(N4GeographicLocationParser.parse(nextSegment));
                    break;
                }
                case "REF": {
                    n1.addReferenceInformation(REFReferenceInformationParser.parse(nextSegment));
                    break;
                }
                default: {
                    segmentIterator.previous();
                    keepLooping = false;
                }
            }
        }
        return n1;
    }

    private N1PartyIdentificationParser() {
    }
}

