/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.common.segment.parser;

import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.common.segment.TD1CarrierDetail;
import org.apache.commons.lang3.StringUtils;

public final class TD1CarrierDetailParser {
    public static TD1CarrierDetail parse(X12Segment segment) {
        String segmentIdentifier;
        TD1CarrierDetail td1 = null;
        if (segment != null && "TD1".equals(segmentIdentifier = segment.getIdentifier())) {
            td1 = new TD1CarrierDetail();
            String packagingCode = segment.getElement(1);
            td1.setRawPackagingCode(packagingCode);
            if (StringUtils.isNotEmpty((CharSequence)packagingCode) && (packagingCode.length() == 3 || packagingCode.length() == 5)) {
                td1.setPackagingCodePartOne(packagingCode.substring(0, 3));
                td1.setPackagingCodePartTwo(packagingCode.substring(3));
            }
            td1.setLadingQuantity(segment.getElement(2));
            td1.setWeightQualifier(segment.getElement(6));
            td1.setWeight(segment.getElement(7));
            td1.setUnitOfMeasure(segment.getElement(8));
        }
        return td1;
    }

    private TD1CarrierDetailParser() {
    }
}

