/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.dex.dx894;

import com.walmartlabs.x12.X12Parser;
import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.dex.dx894.Dex894;
import com.walmartlabs.x12.dex.dx894.Dex894Allowance;
import com.walmartlabs.x12.dex.dx894.Dex894Item;
import com.walmartlabs.x12.dex.dx894.Dex894TransactionSet;
import com.walmartlabs.x12.exceptions.X12ErrorDetail;
import com.walmartlabs.x12.exceptions.X12ParserException;
import com.walmartlabs.x12.types.InvoiceType;
import com.walmartlabs.x12.types.ProductQualifier;
import com.walmartlabs.x12.types.UnitMeasure;
import com.walmartlabs.x12.util.ConversionUtil;
import com.walmartlabs.x12.util.SourceToSegmentUtil;
import com.walmartlabs.x12.util.X12ParsingUtil;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDex894Parser
implements X12Parser<Dex894> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDex894Parser.class);
    public static final String DEX_HEADER_ID = "DXS";
    public static final String DEX_TRAILER_ID = "DXE";
    public static final String TRANSACTION_SET_HEADER_ID = "ST";
    public static final String TRANSACTION_SET_TRAILER_ID = "SE";
    public static final String G82_ID = "G82";
    public static final String G83_ID = "G83";
    public static final String G22_ID = "G22";
    public static final String G72_ID = "G72";
    public static final String G84_ID = "G84";
    public static final String G85_ID = "G85";
    public static final String G86_ID = "G86";
    public static final String LOOP_HEADER_ID = "LS";
    public static final String LOOP_TRAILER_ID = "LE";

    @Override
    public Dex894 parse(String sourceData) {
        Dex894 dex = null;
        if (StringUtils.isNotEmpty((CharSequence)sourceData)) {
            dex = new Dex894();
            List<X12Segment> segmentLines = SourceToSegmentUtil.splitSourceDataIntoSegments(sourceData);
            if (!this.isValidEnvelope(segmentLines)) {
                throw new X12ParserException("invalid envelope");
            }
            try {
                int lastSegmentIndex = this.findLastSegmentIndex(segmentLines);
                this.parseApplicationHeader(segmentLines.get(0), dex);
                int idx = 1;
                do {
                    Dex894TransactionSet dexTx = new Dex894TransactionSet();
                    idx = this.parseDexTransaction(idx, segmentLines, dexTx);
                    dex.addTransaction(dexTx);
                } while (idx < lastSegmentIndex);
                this.parseApplicationTrailer(segmentLines.get(lastSegmentIndex), dex);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new X12ParserException("Invalid DEX message: missing mandatory fields");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new X12ParserException("Invalid DEX message: unexpected segments");
            }
        }
        return dex;
    }

    protected boolean isValidEnvelope(List<X12Segment> dexSegments) {
        return X12ParsingUtil.isValidEnvelope(dexSegments, DEX_HEADER_ID, DEX_TRAILER_ID);
    }

    protected int parseDexTransaction(int startingIdx, List<X12Segment> dexSegments, Dex894TransactionSet dexTx) {
        LOGGER.debug("parseDexTransaction:" + startingIdx);
        X12Segment segment = dexSegments.get(startingIdx);
        String segmentId = segment.getIdentifier();
        int segmentIdx = startingIdx;
        if (!TRANSACTION_SET_HEADER_ID.equals(segmentId)) {
            throw new X12ParserException("Expected start of DEX transaction");
        }
        this.parseTransactionSetHeader(segment, dexTx);
        segment = dexSegments.get(++segmentIdx);
        this.parseG82(segment, dexTx);
        ++segmentIdx;
        while (TRANSACTION_SET_HEADER_ID.equals(segmentId = (segment = dexSegments.get(segmentIdx = this.parseDexTransactionLoop(segmentIdx, dexSegments, dexTx))).getIdentifier())) {
        }
        segment = dexSegments.get(segmentIdx);
        segmentId = segment.getIdentifier();
        if (G84_ID.equals(segmentId)) {
            this.parseG84(segment, dexTx);
            segment = dexSegments.get(++segmentIdx);
            segmentId = segment.getIdentifier();
        }
        if (G86_ID.equals(segmentId)) {
            this.parseG86(segment, dexTx);
            segment = dexSegments.get(++segmentIdx);
        }
        StringBuilder transactionData = new StringBuilder();
        IntStream.range(startingIdx, segmentIdx).forEach(i -> transactionData.append(dexSegments.get(i)).append("\r\n"));
        dexTx.setTransactionData(transactionData.toString());
        this.parseG85(segment, dexTx);
        segment = dexSegments.get(++segmentIdx);
        this.parseTransactionSetTrailer(segment, dexTx);
        dexTx.setActualNumberOfSegments(++segmentIdx - startingIdx);
        return segmentIdx;
    }

    protected int parseDexTransactionLoop(int startingIdx, List<X12Segment> dexSegments, Dex894TransactionSet dexTx) {
        LOGGER.debug("parseDexTransactionLoop:" + startingIdx);
        X12Segment segment = dexSegments.get(startingIdx);
        String segmentId = segment.getIdentifier();
        int segmentIdx = startingIdx;
        if (!LOOP_HEADER_ID.equals(segmentId)) {
            throw new X12ParserException("Expected start of DEX transaction loop");
        }
        this.parseLoopHeader(segment, dexTx);
        ++segmentIdx;
        do {
            if (G83_ID.equals(segmentId = (segment = dexSegments.get(segmentIdx)).getIdentifier())) {
                segmentIdx = this.parseDexItem(segmentIdx, dexSegments, dexTx);
                continue;
            }
            if (LOOP_TRAILER_ID.equals(segmentId)) {
                this.parseLoopTrailer(segment, dexTx);
                ++segmentIdx;
                continue;
            }
            this.handleUnexpectedSegment(G83_ID, segmentId);
        } while (!LOOP_TRAILER_ID.equals(segmentId));
        return segmentIdx;
    }

    protected int parseDexItem(int startingIdx, List<X12Segment> dexSegments, Dex894TransactionSet dexTx) {
        LOGGER.debug("parseDexItem:" + startingIdx);
        int segmentIdx = startingIdx;
        X12Segment segment = dexSegments.get(segmentIdx);
        Dex894Item dexItem = new Dex894Item();
        this.parseG83(segment, dexItem);
        segment = dexSegments.get(++segmentIdx);
        String segmentId = segment.getIdentifier();
        if (G22_ID.equals(segmentId)) {
            this.parseG22(segment, dexItem);
            segment = dexSegments.get(++segmentIdx);
            segmentId = segment.getIdentifier();
        }
        while (G72_ID.equals(segmentId)) {
            this.parseG72(segment, dexItem);
            segment = dexSegments.get(++segmentIdx);
            segmentId = segment.getIdentifier();
        }
        dexTx.addItem(dexItem);
        return segmentIdx;
    }

    protected void parseApplicationHeader(X12Segment headerSegment, Dex894 dex) {
        LOGGER.debug(headerSegment.getIdentifier());
        String segmentIdentifer = headerSegment.getIdentifier();
        if (DEX_HEADER_ID.equals(segmentIdentifer)) {
            dex.setSenderCommId(headerSegment.getElement(1));
            dex.setFunctionalId(headerSegment.getElement(2));
            dex.setVersion(headerSegment.getElement(3));
            this.parseVersion(dex);
            dex.setHeaderTransmissionControlNumber(headerSegment.getElement(4));
            dex.setReceiverCommId(headerSegment.getElement(5));
            dex.setTestIndicator(headerSegment.getElement(6));
        } else {
            this.handleUnexpectedSegment(DEX_HEADER_ID, segmentIdentifer);
        }
    }

    protected void parseVersion(Dex894 dex) {
        Integer version = X12ParsingUtil.parseVersion(dex.getVersion());
        if (version == null) {
            throw new X12ParserException(new X12ErrorDetail(DEX_HEADER_ID, "DXS03", "Invalid version format"));
        }
        dex.setVersionNumber(version);
    }

    protected void parseTransactionSetHeader(X12Segment segment, Dex894TransactionSet dexTx) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (TRANSACTION_SET_HEADER_ID.equals(segmentIdentifier)) {
            dexTx.setTransactionSetIdentifierCode(segment.getElement(1));
            dexTx.setHeaderControlNumber(segment.getElement(2));
        } else {
            this.handleUnexpectedSegment(TRANSACTION_SET_HEADER_ID, segmentIdentifier);
        }
    }

    protected void parseG82(X12Segment segment, Dex894TransactionSet dexTx) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (G82_ID.equals(segmentIdentifier)) {
            dexTx.setDebitCreditFlag(InvoiceType.convert(segment.getElement(1)));
            dexTx.setSupplierNumber(segment.getElement(2));
            dexTx.setReceiverDuns(segment.getElement(3));
            dexTx.setReceiverLocation(segment.getElement(4));
            dexTx.setSupplierDuns(segment.getElement(5));
            dexTx.setSupplierLocation(segment.getElement(6));
            dexTx.setTransactionDate(segment.getElement(7));
            dexTx.setPurchaseOrderNumber(segment.getElement(8));
            dexTx.setPurchaseOrderDate(segment.getElement(9));
        } else {
            this.handleUnexpectedSegment(G82_ID, segmentIdentifier);
        }
    }

    protected void parseLoopHeader(X12Segment segment, Dex894TransactionSet dexTx) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (!LOOP_HEADER_ID.equals(segmentIdentifier)) {
            this.handleUnexpectedSegment(LOOP_HEADER_ID, segmentIdentifier);
        }
    }

    protected void parseG83(X12Segment segment, Dex894Item dexItem) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (G83_ID.equals(segmentIdentifier)) {
            dexItem.setItemSequenceNumber(segment.getElement(1));
            dexItem.setQuantity(ConversionUtil.convertStringToBigDecimal(segment.getElement(2), 3));
            dexItem.setUom(UnitMeasure.convert(segment.getElement(3)));
            dexItem.setUpc(segment.getElement(4));
            dexItem.setConsumerProductQualifier(ProductQualifier.convert(segment.getElement(5)));
            dexItem.setConsumerProductId(segment.getElement(6));
            dexItem.setCaseUpc(segment.getElement(7));
            dexItem.setItemListCost(ConversionUtil.convertStringToBigDecimal(segment.getElement(8), 4));
            dexItem.setPackCount(ConversionUtil.convertStringToInteger(segment.getElement(9)));
            dexItem.setItemDescription(segment.getElement(10));
            dexItem.setCaseProductQualifier(ProductQualifier.convert(segment.getElement(11)));
            dexItem.setCaseProductId(segment.getElement(12));
            dexItem.setInnerPackCount(ConversionUtil.convertStringToInteger(segment.getElement(13)));
        } else {
            this.handleUnexpectedSegment(G83_ID, segmentIdentifier);
        }
    }

    protected void parseG22(X12Segment segment, Dex894Item dexItem) {
        LOGGER.debug(segment.getIdentifier());
    }

    protected void parseG72(X12Segment segment, Dex894Item dexItem) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (G72_ID.equals(segmentIdentifier)) {
            Dex894Allowance dexAllowance = new Dex894Allowance();
            dexItem.addAllowance(dexAllowance);
            dexAllowance.setAllowanceCode(segment.getElement(1));
            dexAllowance.setMethodOfHandlingCode(segment.getElement(2));
            dexAllowance.setAllowanceNumber(segment.getElement(3));
            dexAllowance.setExceptionNumber(segment.getElement(4));
            dexAllowance.setAllowanceRate(ConversionUtil.convertStringToBigDecimal(segment.getElement(5), 4));
            dexAllowance.setAllowanceQuantity(ConversionUtil.convertStringToBigDecimal(segment.getElement(6), 3));
            dexAllowance.setAllowanceUom(UnitMeasure.convert(segment.getElement(7)));
            dexAllowance.setAllowanceAmount(ConversionUtil.convertStringToBigDecimal(segment.getElement(8), 2));
            dexAllowance.setAllowancePercent(ConversionUtil.convertStringToBigDecimal(segment.getElement(9), 3));
            dexAllowance.setOptionNumber(segment.getElement(10));
        } else {
            this.handleUnexpectedSegment(G72_ID, segmentIdentifier);
        }
    }

    protected void parseLoopTrailer(X12Segment segment, Dex894TransactionSet dexTx) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (!LOOP_TRAILER_ID.equals(segmentIdentifier)) {
            this.handleUnexpectedSegment(LOOP_TRAILER_ID, segmentIdentifier);
        }
    }

    protected void parseG84(X12Segment segment, Dex894TransactionSet dexTx) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (G84_ID.equals(segmentIdentifier)) {
            dexTx.setTransactionTotalQuantity(ConversionUtil.convertStringToBigDecimal(segment.getElement(1), 3));
            dexTx.setTransactionTotalAmount(ConversionUtil.convertStringToBigDecimal(segment.getElement(2), 2));
            dexTx.setTransactionTotalDepositAmount(ConversionUtil.convertStringToBigDecimal(segment.getElement(3), 2));
        } else {
            this.handleUnexpectedSegment(G84_ID, segmentIdentifier);
        }
    }

    protected void parseG85(X12Segment segment, Dex894TransactionSet dexTx) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (G85_ID.equals(segmentIdentifier)) {
            dexTx.setIntegrityCheckValue(segment.getElement(1));
        } else {
            this.handleUnexpectedSegment(G85_ID, segmentIdentifier);
        }
    }

    protected void parseG86(X12Segment segment, Dex894TransactionSet dexTx) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (G86_ID.equals(segmentIdentifier)) {
            dexTx.setElectronicSignature(segment.getElement(1));
            dexTx.setSignatureName(segment.getElement(2));
        } else {
            this.handleUnexpectedSegment(G86_ID, segmentIdentifier);
        }
    }

    protected void parseTransactionSetTrailer(X12Segment segment, Dex894TransactionSet dexTx) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (TRANSACTION_SET_TRAILER_ID.equals(segmentIdentifier)) {
            dexTx.setExpectedNumberOfSegments(ConversionUtil.convertStringToInteger(segment.getElement(1)));
            dexTx.setTrailerControlNumber(segment.getElement(2));
        } else {
            this.handleUnexpectedSegment(TRANSACTION_SET_TRAILER_ID, segmentIdentifier);
        }
    }

    protected void parseApplicationTrailer(X12Segment trailerSegment, Dex894 dex) {
        LOGGER.debug(trailerSegment.getIdentifier());
        String segmentIdentifier = trailerSegment.getIdentifier();
        if (DEX_TRAILER_ID.equals(segmentIdentifier)) {
            dex.setTrailerTransmissionControlNumber(trailerSegment.getElement(1));
            dex.setNumberOfTransactions(ConversionUtil.convertStringToInteger(trailerSegment.getElement(2)));
        } else {
            this.handleUnexpectedSegment(DEX_TRAILER_ID, segmentIdentifier);
        }
    }

    protected int findLastSegmentIndex(List<X12Segment> dexSegments) {
        return dexSegments.size() - 1;
    }
}

