/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.dex.dx894;

import com.walmartlabs.x12.X12Validator;
import com.walmartlabs.x12.dex.dx894.Dex894;
import com.walmartlabs.x12.dex.dx894.Dex894Allowance;
import com.walmartlabs.x12.dex.dx894.Dex894Item;
import com.walmartlabs.x12.dex.dx894.Dex894TransactionSet;
import com.walmartlabs.x12.exceptions.X12ErrorDetail;
import com.walmartlabs.x12.types.UnitMeasure;
import com.walmartlabs.x12.util.crc.CyclicRedundancyCheck;
import com.walmartlabs.x12.util.crc.DefaultCrc16;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultDex894Validator
implements X12Validator<Dex894> {
    public static final int DEX_CRC_VALUE_MIN_SIZE = 4;
    public static final int DEX_4010 = 4010;
    public static final int DEX_5010 = 5010;
    public CyclicRedundancyCheck crc16;

    public DefaultDex894Validator() {
        this.crc16 = new DefaultCrc16();
    }

    public DefaultDex894Validator(CyclicRedundancyCheck crc16) {
        this.crc16 = crc16;
    }

    @Override
    public Set<X12ErrorDetail> validate(Dex894 dex, boolean performCrcCheck) {
        HashSet<X12ErrorDetail> errors = new HashSet<X12ErrorDetail>();
        if (dex != null) {
            errors.add(this.compareTransactionCounts(dex));
            errors.add(this.checkForDuplicateInvoiceNumbers(dex));
            List<Dex894TransactionSet> dexTxList = dex.getTransactions();
            for (Dex894TransactionSet dexTx : dexTxList) {
                errors.addAll(this.validateDexTransaction(dex.getVersionNumber(), dexTx, performCrcCheck));
            }
        }
        return this.removeNullValues(errors);
    }

    protected X12ErrorDetail compareTransactionCounts(Dex894 dex) {
        int actualTransactionCount;
        X12ErrorDetail detail = null;
        int n = actualTransactionCount = dex.getTransactions() != null ? dex.getTransactions().size() : 0;
        if (dex.getNumberOfTransactions() == null) {
            detail = new X12ErrorDetail("DXE", "DXE02", "Transaction count is missing");
        } else if (dex.getNumberOfTransactions() != actualTransactionCount) {
            StringBuilder sb = new StringBuilder();
            sb.append("Expected ").append(dex.getNumberOfTransactions()).append(" transactions");
            sb.append(" but got ").append(actualTransactionCount).append(" transactions");
            detail = new X12ErrorDetail("DXE", "", sb.toString());
        }
        return detail;
    }

    protected X12ErrorDetail checkForDuplicateInvoiceNumbers(Dex894 dex) {
        long duplicatedInvoiceCount;
        X12ErrorDetail detail = null;
        List<Dex894TransactionSet> dexTxList = dex.getTransactions();
        if (dexTxList != null && (duplicatedInvoiceCount = dexTxList.stream().map(dexTx -> dexTx.getSupplierNumber()).filter(suppNum -> suppNum != null).collect(Collectors.groupingBy(suppNum -> suppNum, Collectors.counting())).values().stream().filter(count -> count > 1L).count()) > 0L) {
            detail = new X12ErrorDetail("G82", "G8202", "Duplicate invoice numbers on DEX");
        }
        return detail;
    }

    protected Set<X12ErrorDetail> validateDexTransaction(Integer dexVersion, Dex894TransactionSet dexTx, boolean performCrcCheck) {
        HashSet<X12ErrorDetail> errors = new HashSet<X12ErrorDetail>();
        if (performCrcCheck) {
            errors.add(this.checkTransactionIntegrity(dexVersion, dexTx));
        }
        errors.add(this.checkSupplierNumber(dexVersion, dexTx));
        errors.add(this.checkReceiverLocationNumber(dexVersion, dexTx));
        errors.add(this.checkSupplierDate(dexVersion, dexTx));
        errors.add(this.compareTransactionSegmentCounts(dexVersion, dexTx));
        errors.add(this.compareTransactionControlNumbers(dexVersion, dexTx));
        errors.addAll(this.validateItems(dexVersion, dexTx));
        return this.removeNullValues(errors);
    }

    protected Set<X12ErrorDetail> validateItems(Integer dexVersion, Dex894TransactionSet dexTx) {
        List<Dex894Item> dexItems;
        HashSet<X12ErrorDetail> errors = new HashSet<X12ErrorDetail>();
        if (dexTx != null && (dexItems = dexTx.getItems()) != null) {
            for (Dex894Item dexItem : dexItems) {
                errors.add(this.checkQuantity(dexVersion, dexItem));
                errors.add(this.checkUnitMeasure(dexVersion, dexItem));
                errors.add(this.checkItemIdentifier(dexVersion, dexItem));
                errors.add(this.checkCaseUpc(dexVersion, dexItem));
                errors.add(this.checkCaseCount(dexVersion, dexItem));
                errors.addAll(this.validateAllowances(dexVersion, dexItem.getAllowances()));
            }
        }
        return this.removeNullValues(errors);
    }

    protected Set<X12ErrorDetail> validateAllowances(Integer dexVersion, List<Dex894Allowance> dexAllowances) {
        HashSet<X12ErrorDetail> errors = new HashSet<X12ErrorDetail>();
        if (dexAllowances != null && !dexAllowances.isEmpty()) {
            dexAllowances.forEach(dexAllowance -> {
                if (dexAllowance != null) {
                    errors.add(this.checkAllowanceCode(dexVersion, (Dex894Allowance)dexAllowance));
                    errors.add(this.checkMethodHandlingCode(dexVersion, (Dex894Allowance)dexAllowance));
                    errors.add(this.checkAllowanceAmount(dexVersion, (Dex894Allowance)dexAllowance));
                }
            });
        }
        return this.removeNullValues(errors);
    }

    protected X12ErrorDetail checkAllowanceCode(Integer dexVersion, Dex894Allowance dexAllowance) {
        X12ErrorDetail detail = null;
        if (StringUtils.isEmpty((CharSequence)dexAllowance.getAllowanceCode())) {
            detail = new X12ErrorDetail("G72", "G7201", "Missing allowance code");
        }
        return detail;
    }

    protected X12ErrorDetail checkMethodHandlingCode(Integer dexVersion, Dex894Allowance dexAllowance) {
        X12ErrorDetail detail = null;
        if (StringUtils.isEmpty((CharSequence)dexAllowance.getMethodOfHandlingCode())) {
            detail = new X12ErrorDetail("G72", "G7202", "Missing method of handling code");
        }
        return detail;
    }

    protected X12ErrorDetail checkAllowanceAmount(Integer dexVersion, Dex894Allowance dexAllowance) {
        X12ErrorDetail detail = null;
        if (dexAllowance.getAllowanceAmount() == null && dexAllowance.getAllowancePercent() == null && dexAllowance.getAllowanceRate() == null) {
            detail = new X12ErrorDetail("G72", "G7205", "Must have allowance rate, percent, or amount");
        }
        return detail;
    }

    protected X12ErrorDetail checkTransactionIntegrity(Integer dexVersion, Dex894TransactionSet dexTx) {
        X12ErrorDetail detail = null;
        if (dexTx != null && this.crc16 != null && !this.crc16.verifyBlockOfText(dexTx.getIntegrityCheckValue(), dexTx.getTransactionData(), 4)) {
            detail = new X12ErrorDetail("G85", "G8501", "CRC Integrity Check does not match");
        }
        return detail;
    }

    protected X12ErrorDetail checkSupplierNumber(Integer dexVersion, Dex894TransactionSet dexTx) {
        X12ErrorDetail detail = null;
        if (dexTx != null && StringUtils.isEmpty((CharSequence)dexTx.getSupplierNumber())) {
            detail = new X12ErrorDetail("G82", "G8202", "Missing supplier number");
        }
        return detail;
    }

    protected X12ErrorDetail checkReceiverLocationNumber(Integer dexVersion, Dex894TransactionSet dexTx) {
        X12ErrorDetail detail = null;
        if (dexTx != null && StringUtils.isEmpty((CharSequence)dexTx.getReceiverLocation())) {
            detail = new X12ErrorDetail("G82", "G8204", "Missing receiver location number");
        }
        return detail;
    }

    protected X12ErrorDetail checkSupplierDate(Integer dexVersion, Dex894TransactionSet dexTx) {
        X12ErrorDetail detail = null;
        if (dexTx != null) {
            if (StringUtils.isEmpty((CharSequence)dexTx.getTransactionDate())) {
                detail = new X12ErrorDetail("G82", "G8207", "Missing supplier date");
            } else if (dexTx.getTransactionDate().length() != 8) {
                detail = new X12ErrorDetail("G82", "G8207", "Date must be in YYYYMMDD format");
            }
        }
        return detail;
    }

    protected X12ErrorDetail compareTransactionSegmentCounts(Integer dexVersion, Dex894TransactionSet dexTx) {
        X12ErrorDetail detail = null;
        if (dexTx.getExpectedNumberOfSegments() != null && dexTx.getActualNumberOfSegments() != null && !dexTx.getExpectedNumberOfSegments().equals(dexTx.getActualNumberOfSegments())) {
            StringBuilder sb = new StringBuilder();
            sb.append("Expected ").append(dexTx.getExpectedNumberOfSegments()).append(" segments in a transaction");
            sb.append(" but got ").append(dexTx.getActualNumberOfSegments()).append(" segments in a transaction");
            detail = new X12ErrorDetail("SE", "", sb.toString());
        }
        return detail;
    }

    protected X12ErrorDetail compareTransactionControlNumbers(Integer dexVersion, Dex894TransactionSet dexTx) {
        X12ErrorDetail detail = null;
        if (dexTx.getHeaderControlNumber() != null && dexTx.getTrailerControlNumber() != null && !dexTx.getHeaderControlNumber().equals(dexTx.getTrailerControlNumber())) {
            StringBuilder sb = new StringBuilder();
            sb.append("Mismatched transaction control numbers: header(").append(dexTx.getHeaderControlNumber());
            sb.append(") and trailer(").append(dexTx.getTrailerControlNumber()).append(")");
            detail = new X12ErrorDetail("SE", "", sb.toString());
        }
        return detail;
    }

    protected X12ErrorDetail checkQuantity(Integer dexVersion, Dex894Item dexItem) {
        X12ErrorDetail detail = null;
        if (dexItem != null) {
            if (dexItem.getQuantity() == null) {
                detail = new X12ErrorDetail("G83", "G8302", "Missing quantity");
            } else if (dexItem.getQuantity().signum() < 0) {
                detail = new X12ErrorDetail("G83", "G8302", "Quantity must be positive");
            }
        }
        return detail;
    }

    protected X12ErrorDetail checkUnitMeasure(Integer dexVersion, Dex894Item dexItem) {
        X12ErrorDetail detail = null;
        if (dexItem != null && (dexItem.getUom() == null || UnitMeasure.UNKNOWN.equals((Object)dexItem.getUom()))) {
            detail = new X12ErrorDetail("G83", "G8303", "Missing/unknown unit of measure");
        }
        return detail;
    }

    protected X12ErrorDetail checkItemIdentifier(Integer dexVersion, Dex894Item dexItem) {
        X12ErrorDetail detail = null;
        if (dexItem != null && !UnitMeasure.CA.equals((Object)dexItem.getUom())) {
            if (dexVersion <= 4010) {
                if (StringUtils.isEmpty((CharSequence)dexItem.getUpc())) {
                    detail = new X12ErrorDetail("G83", "G8304", "Missing consumer UPC");
                }
            } else if (dexItem.getConsumerProductQualifier() == null) {
                detail = new X12ErrorDetail("G83", "G8305", "Missing consumer qualifier");
            } else if (StringUtils.isEmpty((CharSequence)dexItem.getConsumerProductId())) {
                detail = new X12ErrorDetail("G83", "G8306", "Missing consumer UPC");
            }
        }
        return detail;
    }

    protected X12ErrorDetail checkCaseUpc(Integer dexVersion, Dex894Item dexItem) {
        X12ErrorDetail detail = null;
        if (dexItem != null && UnitMeasure.CA.equals((Object)dexItem.getUom())) {
            if (dexVersion <= 4010) {
                if (StringUtils.isEmpty((CharSequence)dexItem.getCaseUpc())) {
                    detail = new X12ErrorDetail("G83", "G8307", "Missing case UPC");
                }
            } else if (dexItem.getCaseProductQualifier() == null) {
                detail = new X12ErrorDetail("G83", "G8311", "Missing case qualifier");
            } else if (StringUtils.isEmpty((CharSequence)dexItem.getCaseProductId())) {
                detail = new X12ErrorDetail("G83", "G8312", "Missing case UPC");
            }
        }
        return detail;
    }

    protected X12ErrorDetail checkCaseCount(Integer dexVersion, Dex894Item dexItem) {
        X12ErrorDetail detail = null;
        if (dexItem != null && UnitMeasure.CA.equals((Object)dexItem.getUom()) && dexItem.getPackCount() == null) {
            detail = new X12ErrorDetail("G83", "G8309", "Missing case count");
        }
        return detail;
    }

    protected Set<X12ErrorDetail> removeNullValues(Set<X12ErrorDetail> errors) {
        return errors.stream().filter(detail -> detail != null).collect(Collectors.toSet());
    }
}

