/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.rule;

import com.walmartlabs.x12.SegmentIterator;
import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.exceptions.X12ErrorDetail;
import com.walmartlabs.x12.exceptions.X12ParserException;
import com.walmartlabs.x12.rule.X12Rule;
import com.walmartlabs.x12.util.ConversionUtil;
import java.util.List;
import java.util.Optional;

public class TrailerSegmentCountX12Rule
implements X12Rule {
    @Override
    public void verify(List<X12Segment> segmentList) {
        SegmentIterator segments = new SegmentIterator(segmentList);
        int groupHeaders = 0;
        int groupTrailers = 0;
        int transactionCount = 0;
        String currentGroupControlNumber = null;
        int groupCountOnIeaTrailer = this.findGroupCountOnIeaTrailer(segmentList);
        while (segments.hasNext()) {
            X12Segment currentSegment = segments.next();
            if ("GS".equals(currentSegment.getIdentifier())) {
                ++groupHeaders;
                currentGroupControlNumber = currentSegment.getElement(6);
            }
            if ("ST".equals(currentSegment.getIdentifier())) {
                ++transactionCount;
            }
            if (!"GE".equals(currentSegment.getIdentifier())) continue;
            ++groupTrailers;
            this.verifyTransactionsOnGroupTrailer(currentGroupControlNumber, transactionCount, currentSegment);
            transactionCount = 0;
            currentGroupControlNumber = null;
        }
        this.verifyInterchangeControlTrailer(groupHeaders, groupTrailers, groupCountOnIeaTrailer);
    }

    private int findGroupCountOnIeaTrailer(List<X12Segment> segmentList) {
        int groupCountOnIeaTrailer = 0;
        int segmentCount = segmentList.size();
        X12Segment ieaTrailer = segmentList.get(segmentCount - 1);
        if (ieaTrailer == null || !"IEA".equals(ieaTrailer.getIdentifier())) {
            throw new X12ParserException(new X12ErrorDetail("IEA", "", "missing IEA segment"));
        }
        groupCountOnIeaTrailer = Optional.ofNullable(ConversionUtil.convertStringToInteger(ieaTrailer.getElement(1))).orElse(-1);
        return groupCountOnIeaTrailer;
    }

    private void verifyInterchangeControlTrailer(int groupHeaders, int groupTrailers, int groupCountOnIeaTrailer) {
        if (groupHeaders != groupTrailers || groupHeaders != groupCountOnIeaTrailer) {
            throw new X12ParserException(new X12ErrorDetail("IEA", "IEA02", "incorrect number of groups on IEA trailer"));
        }
    }

    private void verifyTransactionsOnGroupTrailer(String currentGroupControlNumber, int transactionCount, X12Segment currentSegment) {
        if (currentGroupControlNumber != null && currentGroupControlNumber.equals(currentSegment.getElement(2))) {
            int transactionCountOnGroupTrailer = Optional.ofNullable(ConversionUtil.convertStringToInteger(currentSegment.getElement(1))).orElse(-1);
            if (transactionCountOnGroupTrailer != transactionCount) {
                throw new X12ParserException(new X12ErrorDetail("GE", "GE02", "incorrect number of transactions on group"));
            }
        } else {
            throw new X12ParserException(new X12ErrorDetail("GE", "GE02", "groups seem to be misaligned"));
        }
    }
}

